/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.locus.LocusAction;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.GrantedGroupsPane;
import mausoleum.inspector.panels.SimplePane;
import mausoleum.inspector.sensitives.CSAutoGenotype;
import mausoleum.inspector.sensitives.CSForeignID;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.sensitives.CSTextFieldTag;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAddRequester;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.MouseManager;
import mausoleum.ui.UIDef;

public class InspectorPanelLocus
extends InspectorPanel {
    private static final long serialVersionUID = 14684648468L;
    private static Color cvSelectedColor = new Color(240, 210, 10);
    public CSTextField ivNameField = new CSTextFieldName(this);
    public CSTextField ivENSEMBLNameField = new CSTextFieldTag(this, "LOC_ENSEMBL_NAME", "ENSEMBL-ID");
    public CSTextField ivMGINameField = new CSTextFieldTag(this, "LOC_MGI_NAME", Babel.get("FS_LO_MGI_ID"));
    private CSTextArea ivCommentField = new CSTextArea(this, "LOC_DESCRIPTION");
    public CSAutoGenotype ivAutoGenotypeButton = new CSAutoGenotype(this);
    public final CSForeignID ivForeignIDButton = new CSForeignID(this);
    private JList ivAllelesList = new JList();
    private JTextArea ivAllelDescriptionBox = new JTextArea();
    private JLabel ivAllelLabel = new JLabel();
    private Hashtable ivAllelComments = null;
    private final Vector ivVisibleAlleles = new Vector();

    public InspectorPanelLocus() {
        super(14, "LOCI");
        this.addTab(Babel.get("ATTRIBUTES"), new LocusAttributePanel());
        SimplePane sp = new SimplePane(new BorderLayout()){
            private static final long serialVersionUID = 1232L;

            public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
                if (idObjects != null && idObjects.size() == 1) {
                    InspectorPanelLocus.this.ivCommentField.adaptToVector(idObjects);
                    InspectorPanelLocus.this.ivCommentField.setState(IDObject.nonEmptyAndAllActiveAndChangeable(idObjects) && Privileges.hasPrivilege("LOC_CH_DESCRIPRION"));
                } else {
                    InspectorPanelLocus.this.ivCommentField.setToNonApplicable();
                }
            }
        };
        sp.setOpaque(false);
        sp.add("Center", new JScrollPane(this.ivCommentField));
        this.addTab(Babel.get("DESCRIPTION"), sp);
        if (MausoleumClient.isHeadOfService()) {
            this.addTab(Babel.get("GROUPS"), new GrantedGroupsPane(14, null));
        }
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            this.addMouseTab(Babel.get("MICEOFLOCUS"), null);
            this.addCageTab(Babel.get("CAGESOFLOCUS"), null);
        }
        this.addDocumentsTab("LOC_ADD_DOC", "LOC_REM_DOC", "LOC_GET_DOC");
    }

    public ActionBundleSimple createActionBundle() {
        return new ActionBundleSimple(LocusAction.getLocusActions(), 2);
    }

    public boolean isSetAllowed() {
        return (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && IDObject.nonEmptyAndAllActiveAndChangeable(this.ivSelObjects);
    }

    public boolean doNew(boolean withExecution) {
        Locus locus;
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("CREATE_LOCUS");
        if (res && withExecution && (locus = LocusAddRequester.getNewLocus()) != null && Alert.showAlert(String.valueOf(Babel.get("ALERTWANTADDNEWLOCUS")) + " " + locus.getString("LOC_NAME") + "?", "YES", "NO", false)) {
            StringBuffer msb = new StringBuffer();
            msb.append("LOCNEW");
            msb.append(" ").append(Base64Manager.encodeBase64(locus.getString("LOC_NAME", " ")));
            msb.append(" ").append(Base64Manager.encodeBase64(locus.getString("LOC_ENSEMBL_NAME", " ")));
            msb.append(" ").append(Long.toString(UserManager.getIDOFUser()));
            if (locus.isAutosomal()) {
                msb.append(" 1");
            } else {
                msb.append(" 0");
            }
            String wtAllel = locus.getString("LOC_WT_ALLEL", null);
            if (wtAllel == null) {
                msb.append(" nix");
            } else {
                msb.append(" ").append(Base64Manager.encodeBase64(wtAllel));
            }
            StringBuffer asb = new StringBuffer();
            String[] alleles = (String[])locus.get("LOC_ALLELES");
            int i = 0;
            while (i < alleles.length) {
                if (i != 0) {
                    asb.append("\n");
                }
                asb.append(alleles[i]);
                ++i;
            }
            msb.append(" ").append(Base64Manager.encodeBase64(asb.toString()));
            msb.append(" nix");
            String allelcom = locus.getString("LOC_ALLEL_DESC", null);
            if (allelcom == null) {
                msb.append(" nix");
            } else {
                msb.append(" ").append(allelcom);
            }
            InspectorCommandSender.executeCommand(msb.toString(), UserManager.getFirstGroup());
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("REMOVE_LOCUS") && IDObject.nonEmptyAndAllActiveAndChangeable(this.ivSelObjects);
        if (res && withExecution) {
            this.removeImportantObject("REMOVE_LOCUS", "LOCRM", "ALERTSELALOCUS", "ALERTGURUREMOVELOCUS", "ALERTWANTREMOVELOCUS");
        }
        return res;
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivENSEMBLNameField.setToNonApplicable();
        this.ivMGINameField.setToNonApplicable();
        this.ivCommentField.setToNonApplicable();
        this.ivForeignIDButton.setToNonApplicable();
        this.ivAllelDescriptionBox.setText("");
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivENSEMBLNameField.setToPassive();
        this.ivMGINameField.setToPassive();
        this.ivCommentField.setToPassive();
        this.ivForeignIDButton.setToNonApplicable();
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                InspectorPanelLocus.makeCommand("LOCCHNAME", Base64Manager.encodeBase64(this.ivNameField.getText()), 1, msb, this.ivNameField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivENSEMBLNameField) {
                InspectorPanelLocus.makeCommand("LOCCHENSEMBLNAME", Base64Manager.encodeBase64(this.ivENSEMBLNameField.getText()), 1, msb, this.ivENSEMBLNameField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivMGINameField) {
                InspectorPanelLocus.makeCommand("LOCCHMGINAME", Base64Manager.encodeBase64(this.ivMGINameField.getText()), 1, msb, this.ivMGINameField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelLocus.makeCommand("LOCCHCOMMENT", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivAutoGenotypeButton && this.ivAutoGenotypeButton.didYouChange()) {
                InspectorPanelLocus.makeCommand("LOCCHAUTOGENOTYPE", this.ivAutoGenotypeButton.getValue(), 1, msb, this.ivAutoGenotypeButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivForeignIDButton && this.ivForeignIDButton.didYouChange()) {
                InspectorPanelLocus.makeCommand("SET_FOREIGN_ID", Integer.toString(14), Base64Manager.encodeBase64(this.ivForeignIDButton.getValue()), 1, msb, this.ivForeignIDButton.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    public Vector getMatchingMice() {
        return MouseManager.getActualMiceOfLoci(this.ivSelObjects);
    }

    static /* synthetic */ JLabel access$1(InspectorPanelLocus inspectorPanelLocus) {
        return inspectorPanelLocus.ivAllelLabel;
    }

    static /* synthetic */ Color access$2() {
        return cvSelectedColor;
    }

    static /* synthetic */ Hashtable access$3(InspectorPanelLocus inspectorPanelLocus) {
        return inspectorPanelLocus.ivAllelComments;
    }

    class LocusAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;
        private BorderPanel ivAP_Allele = null;

        public LocusAttributePanel() {
            InspectorPanelLocus.this.ivSensitiveTable = new SensitiveTable(InspectorPanelLocus.this.ivChangeSensitives);
            this.add(InspectorPanelLocus.this.ivSensitiveTable);
            InspectorPanelLocus.this.ivAllelesList.setCellRenderer(new ListCellRenderer(this){
                final /* synthetic */ LocusAttributePanel this$1;
                {
                    this.this$1 = locusAttributePanel;
                }

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String allel = (String)value;
                    String alias = LocusAction.cvAktLocus.getAlias(allel);
                    if (LocusAction.cvAktLocus.isAlleleAvailable(allel)) {
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setFont(FontManager.getFont("SSB11"));
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setForeground(UIDef.NEW_FOREGROUND);
                    } else {
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setFont(FontManager.getFont("SSP11"));
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setForeground(UIDef.OLD_FOREGROUND);
                    }
                    StringBuilder msb = new StringBuilder(" ");
                    msb.append(alias).append(" ");
                    if (value.equals(LocusAction.cvWildtypAllel)) {
                        msb.append("[wt] ");
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setForeground(UIDef.ALARM_COLOR);
                    }
                    if (!allel.equals(alias)) {
                        msb.append("<").append(allel).append("> ");
                    }
                    InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setText(msb.toString());
                    if (isSelected) {
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setOpaque(true);
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setBackground(InspectorPanelLocus.access$2());
                    } else {
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setOpaque(false);
                        InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1)).setBackground(null);
                    }
                    return InspectorPanelLocus.access$1(LocusAttributePanel.access$0(this.this$1));
                }
            });
            InspectorPanelLocus.this.ivAllelesList.addListSelectionListener(new ListSelectionListener(this){
                final /* synthetic */ LocusAttributePanel this$1;
                {
                    this.this$1 = locusAttributePanel;
                }

                public void valueChanged(ListSelectionEvent arg0) {
                    LocusAction.cvSelectedAllel = (String)InspectorPanelLocus.access$0(LocusAttributePanel.access$0(this.this$1)).getSelectedValue();
                    String commonGroup = IDObject.commonGroup(LocusAttributePanel.access$0((LocusAttributePanel)this.this$1).ivSelObjects);
                    LocusAttributePanel.access$0(this.this$1).manageButEnabling("LOC_SEARCH_ALLEL", commonGroup, true);
                    LocusAttributePanel.access$0(this.this$1).manageButEnabling("LOC_ALLEL_ALIAS", commonGroup, true);
                    LocusAttributePanel.access$0(this.this$1).manageButEnabling("LOC_DEVIT_ALLELE", commonGroup, true);
                    LocusAttributePanel.access$0(this.this$1).manageButEnabling("LOC_REVIT_ALLELE", commonGroup, true);
                    String allelDesc = null;
                    if (LocusAction.cvSelectedAllel != null && InspectorPanelLocus.access$3(LocusAttributePanel.access$0(this.this$1)) != null) {
                        allelDesc = (String)InspectorPanelLocus.access$3(LocusAttributePanel.access$0(this.this$1)).get(LocusAction.cvSelectedAllel);
                    }
                    InspectorPanelLocus.access$4(LocusAttributePanel.access$0(this.this$1)).setText(allelDesc);
                }
            });
            JScrollPane jsp = new JScrollPane(InspectorPanelLocus.this.ivAllelesList);
            jsp.setPreferredSize(new Dimension(120, 300));
            JSplitPane split = new JSplitPane(0);
            split.setResizeWeight(0.4);
            split.add(jsp);
            InspectorPanelLocus.this.ivAllelDescriptionBox.setFont(FontManager.getFont("SSB12"));
            InspectorPanelLocus.this.ivAllelDescriptionBox.setMargin(new Insets(4, 4, 4, 4));
            InspectorPanelLocus.this.ivAllelDescriptionBox.setEnabled(false);
            InspectorPanelLocus.this.ivAllelDescriptionBox.setDisabledTextColor(Color.black);
            jsp = new JScrollPane(InspectorPanelLocus.this.ivAllelDescriptionBox);
            jsp.setPreferredSize(new Dimension(150, 300));
            split.add(jsp);
            this.ivAP_Allele = new BorderPanel(split, Babel.get("ALLELES"));
            this.add(this.ivAP_Allele);
            this.alleleListChanged();
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int sh = InspectorPanelLocus.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelLocus.this.ivSensitiveTable.setBounds(x, y, w, sh);
            int rh = d.height - 2 * Inspector.INTER_BUT - Inspector.RAND - sh;
            this.ivAP_Allele.setBounds(x, y += sh + Inspector.RAND, w, rh);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects == null || idObjects.isEmpty()) {
                LocusAction.cvAktLocus = null;
                LocusAction.cvWildtypAllel = null;
                InspectorPanelLocus.this.ivAllelComments = null;
            } else if (idObjects.size() == 1) {
                Locus selLocus;
                LocusAction.cvAktLocus = selLocus = (Locus)InspectorPanelLocus.this.ivSelObjects.elementAt(0);
                LocusAction.cvWildtypAllel = selLocus.getString("LOC_WT_ALLEL");
                InspectorPanelLocus.this.ivAllelComments = Locus.getAllelDescriptionHashtable(LocusAction.cvAktLocus);
                boolean active = selLocus.isAliveAndVisible() && selLocus.mayAttributeBeChangedByCommand();
                InspectorPanelLocus.this.ivNameField.setState(active && Privileges.hasPrivilege("LOC_CH_NAME"));
                InspectorPanelLocus.this.ivENSEMBLNameField.setState(active && Privileges.hasPrivilege("LOC_CH_ENSEMBL"));
                InspectorPanelLocus.this.ivMGINameField.setState(active && Privileges.hasPrivilege("LOC_CH_MGI"));
                InspectorPanelLocus.this.ivAutoGenotypeButton.setState(active && Privileges.hasPrivilege("LOC_CH_AUTOGENOTYPE"));
                InspectorPanelLocus.this.ivForeignIDButton.setState(active && Privileges.hasPrivilege("EDIT_FOREIGN_ID"));
            } else {
                this.disableAllSensitives(InspectorPanelLocus.this.ivChangeSensitives);
                LocusAction.cvAktLocus = null;
                LocusAction.cvWildtypAllel = null;
                InspectorPanelLocus.this.ivAllelComments = null;
            }
            this.alleleListChanged();
        }

        private void alleleListChanged() {
            InspectorPanelLocus.this.ivVisibleAlleles.clear();
            if (LocusAction.cvAktLocus != null) {
                LocusAction.cvAktLocus.addAllAlleles(InspectorPanelLocus.this.ivVisibleAlleles, Privileges.hasPrivilege("VIEW_INACTIVE_ALLELES"), false);
            }
            InspectorPanelLocus.this.ivAllelesList.setListData(InspectorPanelLocus.this.ivVisibleAlleles);
            LocusAction.cvSelectedAllel = null;
            InspectorPanelLocus.this.manageButEnabling("LOC_DEVIT_ALLELE", null, true);
            InspectorPanelLocus.this.manageButEnabling("LOC_REVIT_ALLELE", null, true);
        }

        static /* synthetic */ InspectorPanelLocus access$0(LocusAttributePanel locusAttributePanel) {
            return locusAttributePanel.InspectorPanelLocus.this;
        }
    }
}

