/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import mausoleum.cage.Cage;
import mausoleum.factsheets.PrintElementFactSheet;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.actions.mail.MailAction;
import mausoleum.inspector.panels.MousePane;
import mausoleum.inspector.panels.SimplePane;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mail.Mail;
import mausoleum.mail.NewMailRequester;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.rack.frame.RackFrame;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.TableFrameBasicObjects;
import mausoleum.tables.TableFrameMouse;
import mausoleum.tables.models.MTMouseInMail;
import mausoleum.ui.UIDef;

public class InspectorPanelMail
extends InspectorPanel
implements HyperlinkListener {
    private static final long serialVersionUID = 50588071503369545L;
    private static final String URL_START = "<a href=\"";
    private static final String URL_END = "\">";
    private String ivAktGroup = null;
    private final JTextPane ivTextPane = new JTextPane();
    private final JScrollPane ivTextSPane = new JScrollPane(this.ivTextPane);
    private final Vector ivLinkedMice = InspectorPanelMail.showAndUseLinks() ? new Vector() : null;
    private MousePane ivMousePane = InspectorPanelMail.showAndUseLinks() ? new MousePane(Babel.get("CONVTOMOUSEDISPLAY"), new MTMouseInMail()) : null;

    private static final boolean showAndUseLinks() {
        return MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker();
    }

    public InspectorPanelMail() {
        super(11, "MAIL");
        this.ivTextPane.setEditable(false);
        this.ivTextPane.setDisabledTextColor(Color.black);
        int aa = UIDef.getScaled(4);
        this.ivTextPane.setMargin(new Insets(aa, aa, aa, aa));
        this.ivTextPane.setBackground(UIDef.GRAY_COLOR);
        this.ivTextPane.setFont(FontManager.getFont("SSP13"));
        String rule = null;
        if (InspectorPanelMail.showAndUseLinks()) {
            this.ivTextPane.addHyperlinkListener(this);
            rule = "A {color:#" + PrintElementFactSheet.HTML_LINK_COLOR_STRING + ";font-weight:bold;}";
        } else {
            rule = "A {color:#000000text-decoration:none;font-weight:normal;}";
        }
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet styleSheet = kit.getStyleSheet();
        if (rule != null) {
            styleSheet.addRule(rule);
        }
        styleSheet.addRule("body { font-family: sans-serif; font-size: " + UIDef.getScaled(11) + "px; }");
        this.ivTextPane.setEditorKit(kit);
        SimplePane sp = new SimplePane(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                if (InspectorPanelMail.this.ivMousePane != null) {
                    int oh = d.height * 2 / 3;
                    int uh = d.height - oh;
                    int x = 0;
                    int y = 0;
                    InspectorPanelMail.this.ivTextSPane.setBounds(x, y, d.width, oh);
                    InspectorPanelMail.this.ivMousePane.setBounds(x, y += oh, d.width, uh);
                } else {
                    InspectorPanelMail.this.ivTextSPane.setBounds(0, 0, d.width, d.height);
                }
            }
        }){
            private static final long serialVersionUID = 1232L;

            public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
                if (InspectorPanelMail.this.ivLinkedMice != null) {
                    InspectorPanelMail.this.ivLinkedMice.clear();
                }
                if (idObjects != null && idObjects.size() == 1) {
                    Mail mail = (Mail)InspectorPanelMail.this.ivSelObjects.elementAt(0);
                    InspectorPanelMail.this.ivAktGroup = mail.getGroup(null);
                    String cont = mail.getString("MAI_TEXT");
                    if (cont != null && cont.toLowerCase().trim().startsWith("<html>")) {
                        InspectorPanelMail.this.ivTextPane.setContentType("text/html");
                        InspectorPanelMail.this.extractLinkedMice(cont);
                        InspectorPanelMail.this.ivTextPane.setText(cont.replaceAll("\n", "<br>\n"));
                    } else {
                        InspectorPanelMail.this.ivTextPane.setContentType("text/plain");
                        InspectorPanelMail.this.ivTextPane.setText(cont);
                    }
                    InspectorPanelMail.this.ivTextPane.setBackground(Color.white);
                    if (!mail.getBoolean("MAI_READ", false)) {
                        String com = "MAI_CHREAD " + mail.getID();
                        InspectorCommandSender.executeCommand(com, mail.getGroup());
                        mail.setBoolean("MAI_READ", true);
                    }
                } else {
                    InspectorPanelMail.this.ivTextPane.setContentType("text/plain");
                    InspectorPanelMail.this.ivTextPane.setText("");
                    InspectorPanelMail.this.ivTextPane.setBackground(UIDef.GRAY_COLOR);
                    InspectorPanelMail.this.ivAktGroup = null;
                }
                if (InspectorPanelMail.this.ivMousePane != null) {
                    InspectorPanelMail.this.ivMousePane.adapt(InspectorPanelMail.this.ivLinkedMice, InspectorPanelMail.this.ivLinkedMice, null);
                }
            }
        };
        sp.setOpaque(false);
        sp.add(this.ivTextSPane);
        if (this.ivMousePane != null) {
            sp.add(this.ivMousePane);
        }
        this.addTab(Babel.get("CONTENTS"), sp);
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        return null;
    }

    public ActionBundleSimple createActionBundle() {
        String[] actions;
        return new ActionBundleSimple(actions, (actions = MailAction.getLineActions()).length > 1 ? 2 : 1);
    }

    public boolean isSetAllowed() {
        return false;
    }

    public boolean doNew(boolean withExecution) {
        if (UserManager.isRealUser()) {
            if (withExecution) {
                NewMailRequester.createNewMail();
            }
            return true;
        }
        return false;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res = true;
        String commonGroup = IDObject.commonGroup(this.ivSelObjects);
        res = !this.ivSelObjects.isEmpty() && commonGroup != null;
        if (res && withExecution) {
            Vector toRemove = new Vector();
            toRemove.addAll(this.ivSelObjects);
            StringBuilder msb = new StringBuilder();
            Iterator iter = toRemove.iterator();
            while (iter.hasNext()) {
                Mail mail = (Mail)iter.next();
                if (msb.length() != 0) {
                    msb.append("\n");
                }
                msb.append("MAI_DEL " + mail.getID());
            }
            InspectorCommandSender.executeCommand(msb.toString(), commonGroup);
        }
        return res;
    }

    public void disableFields() {
        this.ivAktGroup = null;
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (InspectorPanelMail.showAndUseLinks()) {
            if (e.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED) && this.ivAktGroup != null && e.getURL() != null) {
                try {
                    Object linkedObject;
                    String turl = e.getURL().toString();
                    if (turl != null && (linkedObject = this.getLinkedObject(turl, false)) != null) {
                        IDObject iob;
                        JFrame frame;
                        if (linkedObject instanceof Cage) {
                            Cage cage = (Cage)linkedObject;
                            if (cage.isAlive()) {
                                Vector<Cage> v = new Vector<Cage>();
                                v.addElement(cage);
                                RackFrame.showCagePosition(v);
                            }
                        } else if (linkedObject instanceof Mouse) {
                            Vector<Object> v = new Vector<Object>();
                            v.addElement(linkedObject);
                            TableFrameMouse.displayMice(v, "", Babel.get("MOUSE_FROM_MAIL"));
                        } else if (linkedObject instanceof IDObject && (frame = MausoleumTableFrame.showMainTableForType((iob = (IDObject)linkedObject).getTyp())) != null) {
                            TableFrameBasicObjects tfbo;
                            MausoleumTable mt;
                            if (frame instanceof TableFrameBasicObjects && (mt = (tfbo = (TableFrameBasicObjects)frame).getActiveTableForInspector()) != null) {
                                mt.ivModel.selectElement(iob);
                            }
                            if (frame instanceof MausoleumTableFrame) {
                                MausoleumTableFrame mtf = (MausoleumTableFrame)frame;
                                if (mtf.ivMausoleumTable != null) {
                                    mtf.ivMausoleumTable.ivModel.selectElement(iob);
                                }
                            }
                        }
                    }
                }
                catch (Exception e1) {
                    Log.error("Problem bei Hyperlinklistener", e1, this);
                }
            }
            if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                this.setMyCursor(Cursor.getPredefinedCursor(12));
            }
            if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                this.setMyCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void setMyCursor(Cursor cursor) {
        JScrollPane jsp = WindowUtils.getJScrollPane(this.ivTextPane);
        if (jsp != null) {
            jsp.setCursor(cursor);
        }
        this.ivTextPane.setCursor(cursor);
        this.setCursor(cursor);
    }

    private void extractLinkedMice(String content) {
        if (this.ivLinkedMice != null) {
            boolean cont = true;
            int pos = 0;
            while (cont) {
                String turl;
                Object linkedObject;
                if ((pos = content.indexOf(URL_START, pos)) == -1) {
                    cont = false;
                    continue;
                }
                int ind2 = content.indexOf(URL_END, pos += URL_START.length());
                if (ind2 == -1 || (linkedObject = this.getLinkedObject(turl = content.substring(pos, ind2), true)) == null) continue;
                this.ivLinkedMice.add(linkedObject);
            }
        }
    }

    private Object getLinkedObject(String turl, boolean onlyMice) {
        IDObject linkedObject = null;
        if (InspectorPanelMail.showAndUseLinks() && turl.toLowerCase().trim().startsWith("http://")) {
            if ((turl = turl.substring(7, turl.length())).toLowerCase().startsWith("c:") && !onlyMice) {
                String ids = turl.substring(2, turl.length());
                linkedObject = ObjectStore.getClientObject(2, Long.parseLong(ids), this.ivAktGroup);
            } else if (turl.toLowerCase().startsWith("m:")) {
                String ids = turl.substring(2, turl.length());
                linkedObject = MouseManager.getMouse(Long.parseLong(ids), this.ivAktGroup);
            } else if (turl.toLowerCase().startsWith("obj|") && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker())) {
                IDObject.IDObjectIdentifier ioi = new IDObject.IDObjectIdentifier(turl.substring(4, turl.length()));
                if (ioi.ivTyp == 1 || !onlyMice) {
                    linkedObject = ObjectStore.getClientObject(ioi.ivTyp, ioi.ivID, ioi.ivGroup);
                }
            }
        }
        return linkedObject;
    }
}

