/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mausoleum.gui.BorderPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.sensitives.CSColor;
import mausoleum.inspector.sensitives.CSInheritability;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.TextRequester;

public class InspectorPanelMouseCohorts
extends InspectorPanel {
    private static final long serialVersionUID = 145684313L;
    private static final String[] ACTION_BUTT_DEFS = new String[]{"MOCO_SHOW_MICE"};
    public final CSTextField ivNameField = new CSTextFieldName(this);
    private final CSTextArea ivCommentField;
    public final CSColor ivColorButton = new CSColor(this, "IOG_COL");
    public final CSInheritability ivInheritabilityButton = new CSInheritability(this);

    public InspectorPanelMouseCohorts() {
        super(21, "COHORTS");
        this.ivCommentField = new CSTextArea(this, "IOG_COM");
        this.addTab(Babel.get("ATTRIBUTES"), new CohortAttributePanel());
        this.addDocumentsTab("MCOH_ADD_DOC", "MCOH_REM_DOC", "MCOH_GET_DOC");
    }

    public ActionBundleSimple createActionBundle() {
        if (MausoleumClient.isRegularOrTGService()) {
            return new ActionBundleSimple(ACTION_BUTT_DEFS, 1);
        }
        return null;
    }

    public boolean isSetAllowed() {
        return MausoleumClient.isRegularOrTGService() && !this.ivSelObjects.isEmpty();
    }

    public boolean doNew(boolean withExecution) {
        String ns;
        boolean res;
        boolean bl = res = MausoleumClient.isRegularOrTGService() && Privileges.hasPrivilege("CREATE_MOUSE_COHORT");
        if (res && withExecution && (ns = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get("NEW_COHORT"))) != null) {
            String com = "IOGNEW " + Base64Manager.encodeBase64(ns) + " " + 2;
            InspectorCommandSender.executeCommand(com, UserManager.getFirstGroup());
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res;
        boolean bl = res = MausoleumClient.isRegularOrTGService() && Privileges.hasPrivilege("DELETE_MOUSE_COHORT") && !this.ivSelObjects.isEmpty();
        if (res && withExecution) {
            this.removeImportantObject("DELETE_MOUSE_COHORT", "IOGRM", "ALERT_MISSING_OBJECT", "ALERT_INSUFFICIENT_PRIVILEGES", "ALERT_REALLY_REMOVE");
        }
        return res;
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivCommentField.setToPassive();
        this.ivColorButton.setToPassive();
        this.ivInheritabilityButton.setToPassive();
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivCommentField.setToNonApplicable();
        this.ivColorButton.setToNonApplicable();
        this.ivInheritabilityButton.setToNonApplicable();
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                InspectorPanelMouseCohorts.makeCommand("IOGCHNAME", Base64Manager.encodeBase64(this.ivNameField.getText()), 1, msb, this.ivNameField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelMouseCohorts.makeCommand("IOGCHCOMMENT", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivColorButton) {
                InspectorPanelMouseCohorts.makeCommand("IOGCHCOLOR", this.ivColorButton.getCommandValue(), 1, msb, this.ivColorButton.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivInheritabilityButton) {
                InspectorPanelMouseCohorts.makeCommand("IOGCHINHERIT", this.ivInheritabilityButton.getValueForCommand(), 1, msb, this.ivInheritabilityButton.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    class CohortAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;
        private BorderPanel ivAP_Comment = null;

        public CohortAttributePanel() {
            InspectorPanelMouseCohorts.this.ivSensitiveTable = new SensitiveTable(InspectorPanelMouseCohorts.this.ivChangeSensitives);
            this.add(InspectorPanelMouseCohorts.this.ivSensitiveTable);
            JPanel mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add((Component)new JScrollPane(InspectorPanelMouseCohorts.this.ivCommentField), "Center");
            this.ivAP_Comment = new BorderPanel(mp, Babel.get("DESCRIPTION"));
            this.add(this.ivAP_Comment);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int sh = InspectorPanelMouseCohorts.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelMouseCohorts.this.ivSensitiveTable.setBounds(x, y, w, sh);
            int rh = d.height - (y += sh + Inspector.RAND) - Inspector.RAND;
            this.ivAP_Comment.setBounds(x, y, w, rh);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            boolean active = IDObject.allActive(idObjects);
            if (idObjects != null && !idObjects.isEmpty()) {
                if (idObjects.size() == 1) {
                    InspectorPanelMouseCohorts.this.ivNameField.setState(active && Privileges.hasPrivilege("MCOH_CH_NAME"));
                    InspectorPanelMouseCohorts.this.ivCommentField.setState(active && Privileges.hasPrivilege("MCOH_CH_DESCRIPRION"));
                    InspectorPanelMouseCohorts.this.ivColorButton.setState(active && Privileges.hasPrivilege("MCOH_CH_COLOR"));
                    InspectorPanelMouseCohorts.this.ivInheritabilityButton.setState(active && Privileges.hasPrivilege("MCOH_CH_INHERITABILITY"));
                } else {
                    this.disableAllSensitives(InspectorPanelMouseCohorts.this.ivChangeSensitives);
                    InspectorPanelMouseCohorts.this.ivInheritabilityButton.setState(active && Privileges.hasPrivilege("MCOH_CH_INHERITABILITY"));
                }
            }
        }
    }
}

