/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mausoleum.gui.BorderPanel;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.OwnerGroupMemberPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.sensitives.CSColor;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.MouseManager;
import mausoleum.requester.TextRequester;
import mausoleum.tables.models.MTMouseMikroOwnergroup;

public class InspectorPanelOwnerGroups
extends InspectorPanel {
    private static final long serialVersionUID = 145684313L;
    private static final int MEMBERS_HEIGHT = 240;
    public CSTextField ivNameField = null;
    private CSTextArea ivCommentField = null;
    public CSColor ivColorButton = null;
    private OwnerGroupMemberPanel ivMemberPanel = new OwnerGroupMemberPanel();

    public InspectorPanelOwnerGroups() {
        super(20, "OWNER_GROUPS");
        this.ivNameField = new CSTextFieldName(this);
        this.ivColorButton = new CSColor(this, "IOG_COL");
        this.ivCommentField = new CSTextArea(this, "IOG_COM");
        this.addTab(Babel.get("ATTRIBUTES"), new OwnerGroupAttributePanel());
        if (MausoleumClient.isRegular()) {
            this.addMouseTab(Babel.get("MICEOFOWNERGROUP"), new MTMouseMikroOwnergroup());
            this.addCageTab(Babel.get("CAGESOFOWNERGROUP"), null);
        }
        this.addDocumentsTab("OWG_ADD_DOC", "OWG_REM_DOC", "OWG_GET_DOC");
    }

    public ActionBundleSimple createActionBundle() {
        return null;
    }

    public boolean isSetAllowed() {
        return MausoleumClient.isRegular() && !this.ivSelObjects.isEmpty();
    }

    public boolean doNew(boolean withExecution) {
        String ns;
        boolean res;
        boolean bl = res = MausoleumClient.isRegular() && Privileges.hasPrivilege("CREATE_OWNER_GROUP");
        if (res && withExecution && (ns = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get("NEW_OWNER_GROUP"))) != null) {
            String com = "IOGNEW " + Base64Manager.encodeBase64(ns) + " " + 1;
            InspectorCommandSender.executeCommand(com, UserManager.getFirstGroup());
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        boolean res = false;
        if (MausoleumClient.isRegular() && Privileges.hasPrivilege("DELETE_OWNER_GROUP") && !this.ivSelObjects.isEmpty()) {
            res = true;
            Iterator iter = this.ivSelObjects.iterator();
            while (iter.hasNext()) {
                IDObjectGroup iog = (IDObjectGroup)iter.next();
                long[] ids = (long[])iog.get("IOG_IDS");
                if (ids == null || ids.length == 0) continue;
                res = false;
            }
            if (res && withExecution) {
                this.removeImportantObject("DELETE_OWNER_GROUP", "IOGRM", "ALERT_MISSING_OBJECT", "ALERT_INSUFFICIENT_PRIVILEGES", "ALERT_REALLY_REMOVE");
            }
        }
        return res;
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivCommentField.setToPassive();
        this.ivColorButton.setToPassive();
        this.ivMemberPanel.adaptToVector(null);
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivCommentField.setToNonApplicable();
        this.ivColorButton.setToNonApplicable();
        this.ivMemberPanel.adaptToVector(null);
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                InspectorPanelOwnerGroups.makeCommand("IOGCHNAME", Base64Manager.encodeBase64(this.ivNameField.getText()), 1, msb, this.ivNameField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelOwnerGroups.makeCommand("IOGCHCOMMENT", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, this.ivCommentField.getAffecteds(idObjects));
            } else if (changeSensitives.elementAt(i) == this.ivColorButton) {
                InspectorPanelOwnerGroups.makeCommand("IOGCHCOLOR", this.ivColorButton.getCommandValue(), 1, msb, this.ivColorButton.getAffecteds(idObjects));
            }
            ++i;
        }
        return msb.toString();
    }

    public Vector getMatchingMice() {
        return MouseManager.getActualMiceOfUsersOrUserGroups(this.ivSelObjects, "MOS_OWNERGROUPS");
    }

    class OwnerGroupAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;
        private static final int MIN_COM_HEIGHT = 60;
        private static final int MIN_MEMBERS_HEIGHT = 120;
        private BorderPanel ivAP_Comment = null;
        private BorderPanel ivAP_Members = null;
        private JScrollPane ivSensitivePane;

        public OwnerGroupAttributePanel() {
            InspectorPanelOwnerGroups.this.ivSensitiveTable = new SensitiveTable(InspectorPanelOwnerGroups.this.ivChangeSensitives);
            this.ivSensitivePane = new JScrollPane(InspectorPanelOwnerGroups.this.ivSensitiveTable);
            this.add(this.ivSensitivePane);
            this.ivAP_Members = new BorderPanel(InspectorPanelOwnerGroups.this.ivMemberPanel, Babel.get("MEMBERS"));
            this.add(this.ivAP_Members);
            JPanel mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add((Component)new JScrollPane(InspectorPanelOwnerGroups.this.ivCommentField), "Center");
            this.ivAP_Comment = new BorderPanel(mp, Babel.get("DESCRIPTION"));
            this.add(this.ivAP_Comment);
        }

        public void layoutContainer(Container parent) {
            int membersHeight;
            int sh;
            int commentHeight;
            Insets insets;
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int extra = 5;
            if (this.ivSensitivePane != null && (insets = this.ivSensitivePane.getInsets()) != null) {
                extra = insets.top + insets.bottom;
            }
            if ((commentHeight = d.height - 2 * Inspector.INTER_BUT - 2 * Inspector.RAND - (sh = InspectorPanelOwnerGroups.this.ivSensitiveTable.getPreferredSize().height + extra) - (membersHeight = 240)) < 60 && (membersHeight = d.height - 2 * Inspector.INTER_BUT - 2 * Inspector.RAND - sh - (commentHeight = 60)) < 120) {
                membersHeight = 120;
                sh = d.height - 2 * Inspector.INTER_BUT - 2 * Inspector.RAND - membersHeight - commentHeight;
            }
            this.ivSensitivePane.setBounds(x, y, w, sh);
            this.ivAP_Members.setBounds(x, y += sh + Inspector.RAND, w, membersHeight);
            this.ivAP_Comment.setBounds(x, y += membersHeight + Inspector.RAND, w, commentHeight);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            InspectorPanelOwnerGroups.this.ivMemberPanel.adaptToVector(InspectorPanelOwnerGroups.this.ivSelObjects);
            if (idObjects != null && !idObjects.isEmpty()) {
                if (idObjects.size() == 1) {
                    IDObjectGroup iog = (IDObjectGroup)InspectorPanelOwnerGroups.this.ivSelObjects.elementAt(0);
                    boolean active = iog.isAliveAndVisible();
                    InspectorPanelOwnerGroups.this.ivNameField.setState(active && Privileges.hasPrivilege("OWG_CH_NAME"));
                    InspectorPanelOwnerGroups.this.ivCommentField.setState(active && Privileges.hasPrivilege("OWG_CH_DESCRIPRION"));
                    InspectorPanelOwnerGroups.this.ivColorButton.setState(active && Privileges.hasPrivilege("OWG_CH_COLOR"));
                } else {
                    this.disableAllSensitives(InspectorPanelOwnerGroups.this.ivChangeSensitives);
                }
            }
        }
    }
}

