/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mausoleum.gui.BorderPanel;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.GrantedGroupsPane;
import mausoleum.inspector.sensitives.CSColor;
import mausoleum.inspector.sensitives.CSColorCoat;
import mausoleum.inspector.sensitives.CSForeignID;
import mausoleum.inspector.sensitives.CSMatLim;
import mausoleum.inspector.sensitives.CSPrefix;
import mausoleum.inspector.sensitives.CSStringInfo;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.MouseManager;
import mausoleum.requester.TextRequester;
import mausoleum.util.InstallationType;

public class InspectorPanelStrain
extends InspectorPanel {
    private static final long serialVersionUID = 145684313L;
    private CSTextArea ivCommentField = null;
    public final CSTextField ivNameField = new CSTextFieldName(this);
    public final CSPrefix ivPrefixButton;
    public final CSColor ivColorButton = new CSColor(this, "STR_COLOR");
    public final CSMatLim ivMatLimButton;
    public final CSForeignID ivForeignIDButton;
    public final CSColorCoat ivCSCoat;
    private BorderPanel ivAP_Comment = null;

    public InspectorPanelStrain() {
        super(8, "STRAIN");
        this.ivPrefixButton = new CSPrefix(this);
        this.ivMatLimButton = new CSMatLim(this);
        this.ivForeignIDButton = new CSForeignID(this);
        this.ivCSCoat = InstallationType.isMouse() ? new CSColorCoat(this) : null;
        this.addChangeSensitive(new CSStrainEnterer());
        this.ivColorButton.setSimpleMode();
        this.ivCommentField = new CSTextArea(this, "STR_DESCRIPTION");
        this.addTab(Babel.get("ATTRIBUTES"), new StrainAttributePanel());
        if (MausoleumClient.isHeadOfService()) {
            this.addTab(Babel.get("GROUPS"), new GrantedGroupsPane(8, null));
        }
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) {
            this.addMouseTab(Babel.get("MICEOFSTRAIN"), null);
            this.addCageTab(Babel.get("CAGESOFSTRAIN"), null);
        }
        this.addDocumentsTab("STR_ADD_DOC", "STR_REM_DOC", "STR_GET_DOC");
    }

    public ActionBundleSimple createActionBundle() {
        return null;
    }

    public boolean isSetAllowed() {
        return (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && IDObject.nonEmptyAndAllChangeable(this.ivSelObjects);
    }

    public boolean isNewAllowed() {
        return this.doNew(false);
    }

    public boolean isRemoveAllowed() {
        return this.doRemove(false);
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivCommentField.setToPassive();
        this.ivPrefixButton.setToNonApplicable();
        this.ivMatLimButton.setToPassive();
        this.ivColorButton.setToPassive();
        this.ivForeignIDButton.setToPassive();
        if (this.ivCSCoat != null) {
            this.ivCSCoat.setToPassive();
        }
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivCommentField.setToNonApplicable();
        this.ivPrefixButton.setToNonApplicable();
        this.ivColorButton.setToNonApplicable();
        this.ivForeignIDButton.setToNonApplicable();
        if (this.ivCSCoat != null) {
            this.ivCSCoat.setToNonApplicable();
        }
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                InspectorPanelStrain.makeCommand("STRCHNAME", Base64Manager.encodeBase64(this.ivNameField.getText()), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivCommentField) {
                InspectorPanelStrain.makeCommand("STRCHCOMMENT", Base64Manager.encodeBase64(this.ivCommentField.getText()), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivPrefixButton && this.ivPrefixButton.didYouChange()) {
                InspectorPanelStrain.makeCommand("STRSETPREFIX", Base64Manager.encodeBase64(this.ivPrefixButton.getValue()), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivMatLimButton && this.ivMatLimButton.didYouChange()) {
                InspectorPanelStrain.makeCommand("STRSETMATLIM", Integer.toString(this.ivMatLimButton.getValue()), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivColorButton) {
                InspectorPanelStrain.makeCommand("STRCHCOLOR", this.ivColorButton.getCommandValue(), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivForeignIDButton && this.ivForeignIDButton.didYouChange()) {
                InspectorPanelStrain.makeCommand("SET_FOREIGN_ID", Integer.toString(8), Base64Manager.encodeBase64(this.ivForeignIDButton.getValue()), 1, msb, idObjects);
            } else if (this.ivCSCoat != null && changeSensitives.elementAt(i) == this.ivCSCoat && this.ivCSCoat.didYouChange()) {
                InspectorPanelStrain.makeCommand("STRSTRSETCOATCOLOR", Integer.toString(this.ivCSCoat.getValue()), 1, msb, idObjects);
            }
            ++i;
        }
        return msb.toString();
    }

    public boolean doRemove(boolean withExecution) {
        boolean res = false;
        if ((MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("REMOVE_STRAIN") && IDObject.nonEmptyAndAllChangeable(this.ivSelObjects)) {
            res = true;
            if (withExecution) {
                this.removeImportantObject("REMOVE_STRAIN", "STRRM", "ALERTSELASTRAIN", "ALERTGURUREMOVESTRAIN", "ALERTWANTREMOVESTRAIN");
            }
        }
        return res;
    }

    public boolean doNew(boolean withExecution) {
        boolean res = false;
        if ((MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("CREATE_STRAIN")) {
            String ns;
            res = true;
            if (withExecution && (ns = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get("NEWSTRAIN"))) != null) {
                String com = "STRNEW " + Base64Manager.encodeBase64(ns) + " " + Long.toString(UserManager.getIDOFUser());
                InspectorCommandSender.executeCommand(com, UserManager.getFirstGroup());
            }
        }
        return res;
    }

    public Vector getMatchingMice() {
        return MouseManager.getActualMiceOfStrains(this.ivSelObjects);
    }

    class CSStrainEnterer
    extends CSStringInfo {
        public CSStrainEnterer() {
            super(Babel.get("ENTEREDBY"), null);
        }

        public String getValString(IDObject ido) {
            long entererID = ido.getLong("STR_ENTERER", 0L);
            if (entererID == 0L) {
                return InstallationType.getNormalProgramName();
            }
            return UserManager.getNameOfUser(entererID, ido.getGroup());
        }
    }

    class StrainAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;

        public StrainAttributePanel() {
            InspectorPanelStrain.this.ivSensitiveTable = new SensitiveTable(InspectorPanelStrain.this.ivChangeSensitives);
            this.add(InspectorPanelStrain.this.ivSensitiveTable);
            JPanel mp = new JPanel(new BorderLayout());
            mp.setOpaque(false);
            mp.add((Component)new JScrollPane(InspectorPanelStrain.this.ivCommentField), "Center");
            InspectorPanelStrain.this.ivAP_Comment = new BorderPanel(mp, Babel.get("DESCRIPTION"));
            this.add(InspectorPanelStrain.this.ivAP_Comment);
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int sh = InspectorPanelStrain.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelStrain.this.ivSensitiveTable.setBounds(x, y, w, sh);
            int rh = d.height - (y += sh + Inspector.RAND) - Inspector.RAND;
            InspectorPanelStrain.this.ivAP_Comment.setBounds(x, y, w, rh);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            boolean active = IDObject.nonEmptyAndAllActiveAndChangeable(InspectorPanelStrain.this.ivSelObjects);
            if (idObjects == null || idObjects.isEmpty()) {
                this.disableAllSensitives(InspectorPanelStrain.this.ivChangeSensitives);
            } else if (idObjects.size() == 1) {
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivNameField, active && Privileges.hasPrivilege("STR_CH_NAME"));
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivCommentField, active && Privileges.hasPrivilege("STR_CH_DESCRIPRION"));
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivMatLimButton, active && Privileges.hasPrivilege("STR_CH_MAT_LIMIT"));
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivColorButton, active && Privileges.hasPrivilege("STR_CH_COLOR"));
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivForeignIDButton, active && Privileges.hasPrivilege("EDIT_FOREIGN_ID"));
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivPrefixButton, active && Privileges.hasPrivilege("STR_CH_EARTAG_PREFIX"));
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivCSCoat, active && Privileges.hasPrivilege("STR_CH_COAT_COLOR"));
            } else {
                this.disableAllSensitives(InspectorPanelStrain.this.ivChangeSensitives);
                InspectorPanelStrain.this.adaptToSelection(InspectorPanelStrain.this.ivMatLimButton);
                InspectorPanelStrain.this.adaptToSelection(InspectorPanelStrain.this.ivCSCoat);
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivMatLimButton, active && Privileges.hasPrivilege("STR_CH_MAT_LIMIT"));
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivPrefixButton, active && Privileges.hasPrivilege("STR_CH_EARTAG_PREFIX"));
                InspectorPanelStrain.this.setCSState(InspectorPanelStrain.this.ivCSCoat, active && Privileges.hasPrivilege("STR_CH_COAT_COLOR"));
            }
        }
    }
}

