/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.PrivilegeNode;
import mausoleum.inspector.PrivilegeTreeCellRenderer;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.user.UserAction;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.DocPaneAdaptListener;
import mausoleum.inspector.panels.DocumentsPane;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.sensitives.CSColor;
import mausoleum.inspector.sensitives.CSForeignID;
import mausoleum.inspector.sensitives.CSPassword;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.sensitives.CSTextFieldTag;
import mausoleum.inspector.sensitives.CSUserLanguage;
import mausoleum.inspector.sensitives.CSUserStatus;
import mausoleum.inspector.sensitives.CSVeterinary;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.main.MausoleumClient;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.user.NewUserRequester;
import mausoleum.requester.user.PWTextRequester;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;
import mausoleum.ui.UIDef;

public class InspectorPanelUser
extends InspectorPanel
implements DocPaneAdaptListener {
    private static final long serialVersionUID = -8222757537037141389L;
    private static final DefaultTreeModel EMPTY_MODEL = new DefaultTreeModel(null);
    public final CSTextField ivNameField = new CSTextFieldName(this);
    public final CSTextField ivFullNameField;
    public final CSTextField ivEmailField;
    public final CSTextField ivTelNrField;
    private final CSPassword ivPasswordField;
    public final CSUserStatus ivStatusButton = new CSUserStatus(this);
    private final CSUserLanguage ivLanguageField = new CSUserLanguage(this);
    public final CSColor ivColorButton;
    public final CSForeignID ivForeignIDButton;
    public final CSVeterinary ivVeterinary;
    static /* synthetic */ Class class$0;

    public InspectorPanelUser() {
        super(6, "USER");
        this.ivFullNameField = new CSTextFieldTag(this, "USR_FUNA", Babel.get("FULL_NAME"), false, true);
        this.ivEmailField = new CSTextFieldTag(this, "USR_EMAIL", Babel.get("EMAIL"), false, true);
        this.ivTelNrField = new CSTextFieldTag(this, "USR_TELNR", Babel.get("TELNR"), false);
        this.ivPasswordField = new CSPassword(this);
        this.ivColorButton = new CSColor(this, "USR_COLOR");
        this.ivForeignIDButton = new CSForeignID(this);
        this.ivVeterinary = new CSVeterinary(this);
        this.addTab(Babel.get("ATTRIBUTES"), new UserAttributePanel());
        if (Privileges.hasPrivilege("SEE_PRIVILEGES")) {
            this.addTab(Babel.get("PRIVILEGES"), new PrivilegePane());
        }
        if (MausoleumClient.isRegular()) {
            this.addMouseTab(Babel.get("MICEOFUSER"), null);
            this.addCageTab(Babel.get("CAGESOFUSER"), null);
        }
        DocumentsPane dp = this.addDocumentsTab("USR_ADD_DOC", "USR_REM_DOC", "USR_GET_DOC");
        dp.setAdaptListener(this);
    }

    public ActionBundleSimple createActionBundle() {
        return new ActionBundleSimple(UserAction.getActionDefs(), 2);
    }

    public boolean doNew(boolean withExecution) {
        User newUser;
        boolean res;
        boolean bl = res = (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("CREATE_USER");
        if (res && withExecution && (newUser = NewUserRequester.getNewUser()) != null && Alert.showAlert(String.valueOf(Babel.get("ALERTNEWUSER")) + " '" + newUser.get("USR_NAME") + "'?", Babel.get("YES"), Babel.get("NO"), false)) {
            String verifyPassword = PWTextRequester.getPassword(Inspector.getInspector(), Babel.get("VERIFYPASSWORD"));
            if (!verifyPassword.equals(newUser.getString("USR_PASSWORD"))) {
                Alert.showAlert(Babel.get("ALERTVERIFYFAILED"), true);
            } else {
                String epwd = StringHelper.encrypt(newUser.getString("USR_PASSWORD"));
                String theCom = "USRNEW " + newUser.get("USR_NAME") + " " + epwd + " " + Integer.toString(newUser.getInt("USR_MODE"));
                InspectorCommandSender.executeCommand(theCom, UserManager.getFirstGroup());
            }
        }
        return res;
    }

    public boolean doRemove(boolean withExecution) {
        String group;
        boolean res = false;
        if ((MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("REMOVE_USER") && !this.ivSelObjects.isEmpty() && (group = IDObject.commonGroup(this.ivSelObjects)) != null && group.equals(UserManager.getFirstGroup())) {
            res = true;
            long myID = UserManager.getIDOFUser();
            Iterator iter = this.ivSelObjects.iterator();
            while (iter.hasNext() && res) {
                User user = (User)iter.next();
                if (user.getID() != myID) continue;
                res = false;
            }
            if (res && withExecution) {
                if (!this.allUsersRemovable()) {
                    Alert.showAlert(Babel.get("ALERT_USER_HAS_MICE"), true);
                    res = false;
                } else {
                    boolean warja = Alert.showAlert(Babel.get("ALERTWANTREMOVEUSER"), Babel.get("YES"), Babel.get("NO"), false);
                    if (warja) {
                        Iterator iter2 = this.ivSelObjects.iterator();
                        while (iter2.hasNext()) {
                            User user = (User)iter2.next();
                            InspectorCommandSender.executeCommand("USRRM " + user.getID(), user.getGroup());
                        }
                    }
                }
            }
        }
        return res;
    }

    public void passiviereFelder() {
        this.ivNameField.setToPassive();
        this.ivEmailField.setToPassive();
        this.ivFullNameField.setToPassive();
        this.ivTelNrField.setToPassive();
        this.ivPasswordField.setToPassive();
        this.ivStatusButton.setToPassive();
        this.ivLanguageField.setToPassive();
        this.ivColorButton.setToPassive();
        this.ivForeignIDButton.setToPassive();
        this.ivVeterinary.setToPassive();
    }

    public void disableFields() {
        this.ivNameField.setToNonApplicable();
        this.ivEmailField.setToNonApplicable();
        this.ivFullNameField.setToNonApplicable();
        this.ivTelNrField.setToNonApplicable();
        this.ivPasswordField.setToNonApplicable();
        this.ivColorButton.setToNonApplicable();
        this.ivForeignIDButton.setToNonApplicable();
        this.ivVeterinary.setToNonApplicable();
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        StringBuffer msb = new StringBuffer();
        int i = 0;
        while (i < changeSensitives.size()) {
            if (changeSensitives.elementAt(i) == this.ivNameField) {
                InspectorPanelUser.makeCommand("USRCHNAME", this.ivNameField.getText(), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivEmailField) {
                InspectorPanelUser.makeCommand("USRCHEMAIL", this.ivEmailField.getText(), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivFullNameField) {
                InspectorPanelUser.makeCommand("USRCHFULLNAME", Base64Manager.encodeBase64(this.ivFullNameField.getText().trim()), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivTelNrField) {
                InspectorPanelUser.makeCommand("USRCHTELNR", Base64Manager.encodeBase64(this.ivTelNrField.getText()), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivStatusButton) {
                int status = this.ivStatusButton.getUserStatus();
                if (status != 0) {
                    InspectorPanelUser.makeCommand("USRCHSTATUS", Integer.toString(status), 1, msb, idObjects);
                }
            } else if (changeSensitives.elementAt(i) == this.ivLanguageField) {
                InspectorPanelUser.makeCommand("USRCHLANGUAGE", this.ivLanguageField.getLanguage(), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivPasswordField) {
                InspectorPanelUser.makeCommand("USRCHPWD", this.ivPasswordField.getValue(), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivColorButton) {
                InspectorPanelUser.makeCommand("USRCHCOLOR", this.ivColorButton.getCommandValue(), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivForeignIDButton && this.ivForeignIDButton.didYouChange()) {
                InspectorPanelUser.makeCommand("SET_FOREIGN_ID", Integer.toString(6), Base64Manager.encodeBase64(this.ivForeignIDButton.getValue()), 1, msb, idObjects);
            } else if (changeSensitives.elementAt(i) == this.ivVeterinary && this.ivVeterinary.didYouChange()) {
                InspectorPanelUser.makeCommand("USRCHVET", this.ivVeterinary.getValue(), 1, msb, idObjects);
            }
            ++i;
        }
        return msb.toString();
    }

    public Vector getMatchingMice() {
        if (MausoleumClient.isRegular()) {
            return MouseManager.getActualMiceOfUsersOrUserGroups(this.ivSelObjects, "MOS_OWNER");
        }
        return null;
    }

    private boolean allUsersRemovable() {
        String commonGroup;
        if (MausoleumClient.isRegularOrTGService() && (commonGroup = IDObject.commonGroup(this.ivSelObjects)) != null) {
            long[] uidarr = new long[this.ivSelObjects.size()];
            int i = 0;
            while (i < this.ivSelObjects.size()) {
                User tu = (User)this.ivSelObjects.elementAt(i);
                uidarr[i] = tu.getID();
                ++i;
            }
            Vector mice = MouseManager.getActualObjects(commonGroup);
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                long[] oids = (long[])mouse.get("MOS_OWNER");
                if (oids == null) continue;
                int i2 = 0;
                while (i2 < oids.length) {
                    int j = 0;
                    while (j < uidarr.length) {
                        if (oids[i2] == uidarr[j]) {
                            return false;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
        }
        return true;
    }

    public boolean showDocs(Vector idObjects) {
        if (!Privileges.hasPrivilege("USR_MANAGE_FOREIGN_DOCS") && idObjects != null && idObjects.size() == 1) {
            User user = (User)idObjects.firstElement();
            return user.equals(UserManager.getUser());
        }
        return true;
    }

    class PrivilegePane
    extends RequesterPane
    implements IPTabPanel {
        private static final long serialVersionUID = 1L;
        private final JLabel ivPrivilegeLabel = new JLabel();
        private JTree ivPrivilegeTree = new JTree();
        private long ivLastUserID = -1L;
        private MGButton ivGrantButton = null;
        private MGButton ivUngrantButton = null;
        private final Vector ivExpandeds = new Vector();

        public PrivilegePane() {
            super((LayoutManager)new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND), "inspectorBack");
            this.ivPrivilegeLabel.setBorder(UIDef.getScaledEmptyBorder(1, 3, 1, 3));
            this.ivPrivilegeTree.setBorder(UIDef.getScaledEmptyBorder(4, 4, 4, 4));
            this.ivPrivilegeTree.setCellRenderer(new PrivilegeTreeCellRenderer());
            if (Privileges.hasPrivilege("MODIFY_PRIVILEGES")) {
                this.ivPrivilegeTree.addMouseListener(new MouseAdapter(this){
                    final /* synthetic */ PrivilegePane this$1;
                    {
                        this.this$1 = privilegePane;
                    }

                    public void mouseClicked(MouseEvent e) {
                        if (Privileges.hasPrivilege("MODIFY_PRIVILEGES") && PrivilegePane.access$2((PrivilegePane)this.this$1).ivSelObjects.size() == 1) {
                            int diff;
                            Rectangle r;
                            Point p = e.getPoint();
                            TreePath tp = PrivilegePane.access$0(this.this$1).getPathForLocation(p.x, p.y);
                            if (tp != null && (r = PrivilegePane.access$0(this.this$1).getPathBounds(tp)) != null && (diff = p.x - r.x) >= 0 && diff < 14) {
                                User user = (User)PrivilegePane.access$2((PrivilegePane)this.this$1).ivSelObjects.elementAt(0);
                                PrivilegeNode pdo = (PrivilegeNode)tp.getLastPathComponent();
                                if (pdo != null && pdo.ivPrivilege != null && !Privileges.isPrivilegeImmutable(user, pdo.ivPrivilege) && (user.getID() != UserManager.getIDOFUser() || "PETZEN".equals(pdo.getCategory()))) {
                                    StringBuilder msb = new StringBuilder();
                                    if (pdo.ivGranted) {
                                        msb.append("USRREMPRIV");
                                    } else {
                                        msb.append("USRGRANTPRIV");
                                    }
                                    msb.append(" ").append(user.getID()).append(" ");
                                    msb.append(pdo.ivPrivilege);
                                    Inspector.getInspector().setCursor(Cursor.getPredefinedCursor(3));
                                    try {
                                        InspectorCommandSender.executeCommand(msb.toString(), user.getGroup());
                                    }
                                    catch (Exception exc) {
                                        Class<?> clazz = class$0;
                                        if (clazz == null) {
                                            try {
                                                clazz = class$0 = Class.forName("mausoleum.inspector.InspectorPanelUser");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        Log.error("Problem while changing Privilege", exc, clazz);
                                    }
                                    Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
                                }
                            }
                        }
                    }
                });
            }
            this.ivPrivilegeTree.setOpaque(false);
            this.add("Center", new JScrollPane(this.ivPrivilegeTree));
            if (Privileges.hasPrivilege("MODIFY_PRIVILEGES") && Privileges.hasPrivilege("CHANGE_USER") && Privileges.hasPrivilege("SEE_FOREIGN_PRIVILEGES")) {
                this.ivGrantButton = new MGButton(Babel.get("PRIV_SELECT_ALL"));
                this.ivGrantButton.setFont(FontManager.getFont("SSB12"));
                this.ivGrantButton.addActionListener(new ActionListener(this){
                    final /* synthetic */ PrivilegePane this$1;
                    {
                        this.this$1 = privilegePane;
                    }

                    public void actionPerformed(ActionEvent e) {
                        PrivilegePane.access$1(this.this$1, true);
                    }
                });
                this.ivUngrantButton = new MGButton(Babel.get("PRIV_SELECT_NOTHING"));
                this.ivUngrantButton.setFont(FontManager.getFont("SSB12"));
                this.ivUngrantButton.addActionListener(new ActionListener(this){
                    final /* synthetic */ PrivilegePane this$1;
                    {
                        this.this$1 = privilegePane;
                    }

                    public void actionPerformed(ActionEvent e) {
                        PrivilegePane.access$1(this.this$1, false);
                    }
                });
                JPanel pan = new JPanel(new GridLayout(1, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
                pan.setOpaque(false);
                pan.add(this.ivGrantButton);
                pan.add(this.ivUngrantButton);
                this.add("South", pan);
            }
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            DefaultTreeModel dtm = null;
            if (this.ivPrivilegeTree.getModel() instanceof DefaultTreeModel) {
                dtm = (DefaultTreeModel)this.ivPrivilegeTree.getModel();
            }
            if (dtm != null && dtm != EMPTY_MODEL) {
                this.ivExpandeds.clear();
                int row = 0;
                while (row < this.ivPrivilegeTree.getRowCount()) {
                    PrivilegeNode cto;
                    Object ooo;
                    if (this.ivPrivilegeTree.isExpanded(row) && (ooo = this.ivPrivilegeTree.getPathForRow(row).getLastPathComponent()) != null && ooo instanceof PrivilegeNode && (cto = (PrivilegeNode)ooo) != null && cto.ivCategoryName != null) {
                        this.ivExpandeds.add(cto.ivCategoryName);
                    }
                    ++row;
                }
            }
            boolean opaque = false;
            if (idObjects != null && idObjects.size() == 1) {
                User user = (User)idObjects.firstElement();
                if (this.ivPrivilegeTree != null) {
                    long userID = user.getID();
                    if (userID != this.ivLastUserID) {
                        if (userID == UserManager.getIDOFUser() || Privileges.hasPrivilege("SEE_FOREIGN_PRIVILEGES")) {
                            this.ivPrivilegeTree.setModel(new DefaultTreeModel(PrivilegeNode.getTree(user)));
                        } else {
                            this.ivPrivilegeTree.setModel(EMPTY_MODEL);
                        }
                    }
                    if (this.ivPrivilegeTree.getModel() != null && this.ivPrivilegeTree.getModel() != EMPTY_MODEL) {
                        opaque = true;
                        PrivilegeNode rootNode = (PrivilegeNode)this.ivPrivilegeTree.getModel().getRoot();
                        if (rootNode != null) {
                            Vector changeSammler = new Vector();
                            rootNode.adjustForUser(user, null, changeSammler);
                            Iterator iter = changeSammler.iterator();
                            while (iter.hasNext()) {
                                PrivilegeNode node2 = (PrivilegeNode)iter.next();
                                dtm.nodeChanged(node2);
                            }
                            dtm.nodeChanged(rootNode);
                        }
                        if (this.ivGrantButton != null) {
                            this.ivGrantButton.setEnabled(userID != UserManager.getIDOFUser());
                            this.ivUngrantButton.setEnabled(userID != UserManager.getIDOFUser());
                        }
                    } else if (this.ivGrantButton != null) {
                        this.ivGrantButton.setEnabled(false);
                        this.ivUngrantButton.setEnabled(false);
                    }
                }
                this.ivLastUserID = user.getID();
            } else {
                this.ivPrivilegeTree.setModel(EMPTY_MODEL);
                this.ivLastUserID = -1L;
                if (this.ivGrantButton != null) {
                    this.ivGrantButton.setEnabled(false);
                    this.ivUngrantButton.setEnabled(false);
                }
            }
            if (!this.ivExpandeds.isEmpty() && !this.ivPrivilegeTree.getModel().equals(EMPTY_MODEL)) {
                Object rn;
                dtm = null;
                if (this.ivPrivilegeTree.getModel() instanceof DefaultTreeModel) {
                    dtm = (DefaultTreeModel)this.ivPrivilegeTree.getModel();
                }
                if (dtm != null && (rn = dtm.getRoot()) != null && rn instanceof PrivilegeNode) {
                    PrivilegeNode rootNode = (PrivilegeNode)rn;
                    Iterator iterator = this.ivExpandeds.iterator();
                    while (iterator.hasNext()) {
                        String catName = (String)iterator.next();
                        PrivilegeNode pnode = rootNode.findCategoryNode(catName);
                        if (pnode == null) continue;
                        this.ivPrivilegeTree.expandPath(new TreePath(new Object[]{rootNode, pnode}));
                    }
                }
            }
            this.ivPrivilegeTree.setOpaque(opaque);
        }

        private void bulkModify(boolean grant) {
            User user = (User)InspectorPanelUser.this.ivSelObjects.elementAt(0);
            if (user.getID() != UserManager.getIDOFUser()) {
                PrivilegeNode privNode = (PrivilegeNode)this.ivPrivilegeTree.getModel().getRoot();
                Vector sammler = new Vector(50);
                privNode.collectForGrant(grant, sammler);
                if (!sammler.isEmpty()) {
                    StringBuilder msb = new StringBuilder();
                    Iterator iterator = sammler.iterator();
                    while (iterator.hasNext()) {
                        PrivilegeNode pdo = (PrivilegeNode)iterator.next();
                        if (Privileges.isPrivilegeImmutable(user, pdo.ivPrivilege)) continue;
                        if (msb.length() != 0) {
                            msb.append("\n");
                        }
                        if (grant) {
                            msb.append("USRGRANTPRIV");
                        } else {
                            msb.append("USRREMPRIV");
                        }
                        msb.append(" ").append(user.getID()).append(" ");
                        msb.append(pdo.ivPrivilege);
                    }
                    Inspector.getInspector().setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        InspectorCommandSender.executeCommand(msb.toString(), user.getGroup());
                    }
                    catch (Exception exc) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("mausoleum.inspector.InspectorPanelUser");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error("Problem while changing Privilege", exc, clazz);
                    }
                    Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
                }
                sammler.clear();
                sammler = null;
            }
        }

        static /* synthetic */ JTree access$0(PrivilegePane privilegePane) {
            return privilegePane.ivPrivilegeTree;
        }

        static /* synthetic */ void access$1(PrivilegePane privilegePane, boolean bl) {
            privilegePane.bulkModify(bl);
        }

        static /* synthetic */ InspectorPanelUser access$2(PrivilegePane privilegePane) {
            return privilegePane.InspectorPanelUser.this;
        }
    }

    class UserAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;
        private static final String ROOM_RESTRICTION_NOT_POSSIBLE = "ROOM_RESTRICTION_NOT_POSSIBLE";
        private static final String ROOM_NO_RESTRICTION = "ROOM_NO_RESTRICTION";
        private JLabel ivRoomRestrictionLabel = new JLabel();
        private JPanel ivRoomRestrictionPanel = new JPanel(new CardLayout());
        private JList ivRestrictedRoomsList = new JList();
        private JScrollPane ivRestrictedRoomsPane = new JScrollPane(this.ivRestrictedRoomsList);
        private BorderPanel ivRestrictedRoomsPanel = null;
        private MGButton ivAddRoomButton = new MGButton(Babel.get("RESTR_ADD_ROOM"));
        private MGButton ivRemoveRoomButton = new MGButton(Babel.get("RESTR_REMOVE_ROOM"));
        private boolean ivRestrEditAllowed = false;
        private JLabel ivRoomLabel = new JLabel();

        public UserAttributePanel() {
            InspectorPanelUser.this.ivSensitiveTable = new SensitiveTable(InspectorPanelUser.this.ivChangeSensitives);
            this.add(InspectorPanelUser.this.ivSensitiveTable);
            JPanel mp = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
            mp.setOpaque(false);
            if (this.isRoomRestrictionRelevant()) {
                this.ivRestrictedRoomsList.getSelectionModel().setSelectionMode(0);
                this.ivRestrictedRoomsList.setCellRenderer(new ListCellRenderer(this){
                    final /* synthetic */ UserAttributePanel this$1;
                    {
                        this.this$1 = userAttributePanel;
                    }

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Room room = (Room)value;
                        UserAttributePanel.access$0(this.this$1).setText(" " + room.getName() + " ");
                        if (isSelected) {
                            UserAttributePanel.access$0(this.this$1).setOpaque(true);
                            UserAttributePanel.access$0(this.this$1).setBackground(UIDef.SELECTED_BACKGROUND);
                        } else {
                            UserAttributePanel.access$0(this.this$1).setOpaque(false);
                            UserAttributePanel.access$0(this.this$1).setBackground(null);
                        }
                        return UserAttributePanel.access$0(this.this$1);
                    }
                });
                this.ivRestrictedRoomsPane.setOpaque(false);
                this.ivRestrictedRoomsPane.getViewport().setOpaque(false);
                this.ivRoomRestrictionPanel.add((Component)this.ivRestrictedRoomsPane, "LIST");
                this.ivRoomRestrictionLabel.setOpaque(false);
                this.ivRoomRestrictionLabel.setFont(FontManager.getFont("Serif", 0, 14));
                this.ivRoomRestrictionLabel.setHorizontalAlignment(0);
                this.ivRoomRestrictionLabel.setVerticalAlignment(0);
                this.ivRoomRestrictionLabel.setBorder(new LineBorder(Color.black, 1));
                this.ivRoomRestrictionPanel.add((Component)this.ivRoomRestrictionLabel, "LABEL");
                this.ivRoomRestrictionPanel.setOpaque(false);
                mp.add("Center", this.ivRoomRestrictionPanel);
                this.ivAddRoomButton.addActionListener(new ActionListener(this){
                    final /* synthetic */ UserAttributePanel this$1;
                    {
                        this.this$1 = userAttributePanel;
                    }

                    public void actionPerformed(ActionEvent arg0) {
                        if (UserAttributePanel.access$4((UserAttributePanel)this.this$1).ivSelObjects != null && UserAttributePanel.access$4((UserAttributePanel)this.this$1).ivSelObjects.size() == 1) {
                            User user = (User)UserAttributePanel.access$4((UserAttributePanel)this.this$1).ivSelObjects.firstElement();
                            if (Privileges.hasPrivilege("USR_CHANGE_ROOM_RESTRICTIONS") && Privileges.hasPrivilege(user, "USR_ROOM_RESTRICTION_POSSIBLE")) {
                                HashSet<Object> da = new HashSet<Object>();
                                long[] arr = (long[])user.get("USR_R_ROOMS");
                                if (arr != null) {
                                    int i = 0;
                                    while (i < arr.length) {
                                        da.add(new Long(arr[i]));
                                        ++i;
                                    }
                                }
                                Vector all = RoomManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup());
                                Vector<Room> poss = new Vector<Room>();
                                Iterator<E> iterator = all.iterator();
                                while (iterator.hasNext()) {
                                    Room room = (Room)iterator.next();
                                    if (da.contains(room.get("IDO_ID"))) continue;
                                    poss.add(room);
                                }
                                if (!poss.isEmpty()) {
                                    Room room;
                                    Collections.sort(poss, IDObject.SORTER_BY_NAME);
                                    Vector<String> names = new Vector<String>(poss.size());
                                    Iterator<E> iterator2 = poss.iterator();
                                    while (iterator2.hasNext()) {
                                        room = (Room)iterator2.next();
                                        names.add(room.getName());
                                    }
                                    int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("RESTR_SELECT_ROOM"), names);
                                    if (ind != -1) {
                                        room = (Room)poss.elementAt(ind);
                                        da.add(room.get("IDO_ID"));
                                        UserAttributePanel.access$1(this.this$1, user, da);
                                    }
                                }
                            }
                        }
                    }
                });
                this.ivRemoveRoomButton.addActionListener(new ActionListener(this){
                    final /* synthetic */ UserAttributePanel this$1;
                    {
                        this.this$1 = userAttributePanel;
                    }

                    public void actionPerformed(ActionEvent arg0) {
                        if (UserAttributePanel.access$4((UserAttributePanel)this.this$1).ivSelObjects != null && UserAttributePanel.access$4((UserAttributePanel)this.this$1).ivSelObjects.size() == 1) {
                            int ind;
                            User user = (User)UserAttributePanel.access$4((UserAttributePanel)this.this$1).ivSelObjects.firstElement();
                            if (Privileges.hasPrivilege("USR_CHANGE_ROOM_RESTRICTIONS") && Privileges.hasPrivilege(user, "USR_ROOM_RESTRICTION_POSSIBLE") && (ind = UserAttributePanel.access$2(this.this$1).getSelectedIndex()) != -1) {
                                HashSet<Object> da = new HashSet<Object>();
                                int i = 0;
                                while (i < UserAttributePanel.access$2(this.this$1).getModel().getSize()) {
                                    if (i != ind) {
                                        Room room = (Room)UserAttributePanel.access$2(this.this$1).getModel().getElementAt(i);
                                        da.add(room.get("IDO_ID"));
                                    }
                                    ++i;
                                }
                                UserAttributePanel.access$1(this.this$1, user, da);
                            }
                        }
                    }
                });
                this.ivRestrictedRoomsList.addListSelectionListener(new ListSelectionListener(this){
                    final /* synthetic */ UserAttributePanel this$1;
                    {
                        this.this$1 = userAttributePanel;
                    }

                    public void valueChanged(ListSelectionEvent arg0) {
                        if (!arg0.getValueIsAdjusting()) {
                            UserAttributePanel.access$3(this.this$1);
                        }
                    }
                });
                JPanel bp = new JPanel(new GridLayout(1, 2, UIDef.INNER_RAND, UIDef.INNER_RAND));
                bp.add(this.ivAddRoomButton);
                bp.add(this.ivRemoveRoomButton);
                bp.setOpaque(false);
                mp.add("South", bp);
                this.ivRestrictedRoomsPanel = new BorderPanel(mp, Babel.get("RESTRICTEDROOMS"));
                this.add(this.ivRestrictedRoomsPanel);
            }
        }

        public void layoutContainer(Container parent) {
            Dimension d = parent.getSize();
            int x = Inspector.INTER_BUT;
            int w = d.width - 2 * Inspector.INTER_BUT;
            int y = Inspector.INTER_BUT;
            int sh = InspectorPanelUser.this.ivSensitiveTable.getPreferredSize().height;
            InspectorPanelUser.this.ivSensitiveTable.setBounds(x, y, w, sh);
            y += sh + Inspector.RAND;
            if (this.ivRestrictedRoomsPanel != null) {
                this.ivRestrictedRoomsPanel.setBounds(x, y, w, d.height - y);
            }
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            Vector<Room> restrictedRooms = ArrayHelper.LEER;
            this.ivRestrEditAllowed = false;
            if (idObjects == null || idObjects.isEmpty()) {
                this.disableAllSensitives(InspectorPanelUser.this.ivChangeSensitives);
            } else if (idObjects.size() == 1) {
                User user = (User)idObjects.firstElement();
                if (Privileges.hasPrivilege("CHANGE_USER") && user.isAliveAndVisible()) {
                    InspectorPanelUser.this.ivPasswordField.adaptToVector(InspectorPanelUser.this.ivSelObjects);
                    InspectorPanelUser.this.ivNameField.setToActive();
                    InspectorPanelUser.this.ivEmailField.setToActive();
                    InspectorPanelUser.this.ivFullNameField.setToActive();
                    InspectorPanelUser.this.ivTelNrField.setToActive();
                    InspectorPanelUser.this.ivPasswordField.setToActive();
                    InspectorPanelUser.this.ivLanguageField.setToActive();
                    InspectorPanelUser.this.ivColorButton.setToActive();
                    InspectorPanelUser.this.ivForeignIDButton.setState(Privileges.hasPrivilege("EDIT_FOREIGN_ID"));
                    InspectorPanelUser.this.ivVeterinary.setToActive();
                } else if (user.getID() == UserManager.getIDOFUser() && user.isAliveAndVisible()) {
                    InspectorPanelUser.this.ivPasswordField.adaptToVector(InspectorPanelUser.this.ivSelObjects);
                    InspectorPanelUser.this.ivNameField.setState(Privileges.hasPrivilege("USR_CH_NAME"));
                    InspectorPanelUser.this.ivFullNameField.setState(Privileges.hasPrivilege("USR_CH_NAME"));
                    InspectorPanelUser.this.ivPasswordField.setState(Privileges.hasPrivilege("USR_CH_PASSWORD"));
                    InspectorPanelUser.this.ivLanguageField.setState(Privileges.hasPrivilege("USR_CH_LANGUAGE"));
                    InspectorPanelUser.this.ivEmailField.setState(Privileges.hasPrivilege("USR_CH_EMAIL"));
                    InspectorPanelUser.this.ivTelNrField.setState(Privileges.hasPrivilege("USR_CH_TELNR"));
                    InspectorPanelUser.this.ivColorButton.setState(Privileges.hasPrivilege("USR_CH_COLOR"));
                    InspectorPanelUser.this.ivForeignIDButton.setState(Privileges.hasPrivilege("EDIT_FOREIGN_ID"));
                    InspectorPanelUser.this.ivVeterinary.setToPassive();
                } else {
                    this.passivateAllSensitives(InspectorPanelUser.this.ivChangeSensitives);
                    InspectorPanelUser.this.ivPasswordField.setToNonApplicable();
                }
                if (this.isRoomRestrictionRelevant() && Privileges.hasPrivilege(user, "USR_ROOM_RESTRICTION_POSSIBLE")) {
                    this.ivRestrEditAllowed = true;
                    long[] restRooms = (long[])user.get("USR_R_ROOMS");
                    if (restRooms != null && restRooms.length != 0) {
                        restrictedRooms = new Vector<Room>();
                        int i = 0;
                        while (i < restRooms.length) {
                            Room room = (Room)ObjectStore.getObjectDeadOrAlive(10, restRooms[i], UserManager.getFirstGroup(), null, false);
                            if (room != null) {
                                restrictedRooms.add(room);
                            }
                            ++i;
                        }
                        Collections.sort(restrictedRooms, IDObject.SORTER_BY_NAME);
                    }
                }
            }
            if (this.isRoomRestrictionRelevant()) {
                String compKey = null;
                if (this.ivRestrEditAllowed) {
                    if (restrictedRooms.isEmpty()) {
                        compKey = "LABEL";
                        this.ivRoomRestrictionLabel.setText(Babel.get(ROOM_NO_RESTRICTION));
                    } else {
                        compKey = "LIST";
                        this.ivRestrictedRoomsList.setListData(restrictedRooms);
                    }
                } else {
                    compKey = "LABEL";
                    this.ivRoomRestrictionLabel.setText(Babel.get(ROOM_RESTRICTION_NOT_POSSIBLE));
                }
                if (compKey != null) {
                    CardLayout cl = (CardLayout)this.ivRoomRestrictionPanel.getLayout();
                    cl.show(this.ivRoomRestrictionPanel, compKey);
                }
                this.checkButs();
            }
        }

        private boolean isRoomRestrictionRelevant() {
            return (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("USR_CHANGE_ROOM_RESTRICTIONS");
        }

        private void checkButs() {
            if (this.ivAddRoomButton != null) {
                if (this.ivRestrEditAllowed) {
                    this.ivRemoveRoomButton.setEnabled(this.ivRestrictedRoomsList.getSelectedIndex() != -1);
                    Vector all = RoomManager.cvInstance.getActualObjectVector(UserManager.getFirstGroup());
                    this.ivAddRoomButton.setEnabled(all.size() > this.ivRestrictedRoomsList.getModel().getSize());
                    this.ivRestrictedRoomsList.setOpaque(true);
                } else {
                    this.ivRemoveRoomButton.setEnabled(false);
                    this.ivAddRoomButton.setEnabled(false);
                    this.ivRestrictedRoomsList.setOpaque(false);
                }
            }
        }

        private void executeRestrictRoomAccessAction(User user, HashSet ids) {
            StringBuilder idsb = new StringBuilder();
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                if (idsb.length() != 0) {
                    idsb.append("|");
                }
                idsb.append(id);
            }
            StringBuilder comSB = new StringBuilder();
            comSB.append("USR_SET_RESTR_ROOM_IDS").append(" ");
            comSB.append(user.getID()).append(" ");
            comSB.append(idsb.toString());
            InspectorCommandSender.executeCommand(comSB.toString(), user.getGroup());
        }

        static /* synthetic */ JLabel access$0(UserAttributePanel userAttributePanel) {
            return userAttributePanel.ivRoomLabel;
        }

        static /* synthetic */ void access$1(UserAttributePanel userAttributePanel, User user, HashSet hashSet) {
            userAttributePanel.executeRestrictRoomAccessAction(user, hashSet);
        }

        static /* synthetic */ JList access$2(UserAttributePanel userAttributePanel) {
            return userAttributePanel.ivRestrictedRoomsList;
        }

        static /* synthetic */ void access$3(UserAttributePanel userAttributePanel) {
            userAttributePanel.checkButs();
        }

        static /* synthetic */ InspectorPanelUser access$4(UserAttributePanel userAttributePanel) {
            return userAttributePanel.InspectorPanelUser.this;
        }
    }
}

