/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.cage.colors.GroupColorManager;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.gui.SimpleList;
import mausoleum.gui.SimpleListHook;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.inspector.DocumentsTable;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorActionButton;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.SensitiveTable;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.actions.documents.AddDocuButton;
import mausoleum.inspector.actions.documents.ShowDocuButton;
import mausoleum.inspector.actions.usergroup.BasicObjectMerker;
import mausoleum.inspector.actions.usergroup.UsergroupAction;
import mausoleum.inspector.panels.AttributePane;
import mausoleum.inspector.panels.DocumentsPane;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.sensitives.CSColor;
import mausoleum.inspector.sensitives.CSTextField;
import mausoleum.inspector.sensitives.CSTextFieldName;
import mausoleum.inspector.util.ActionBundleSimple;
import mausoleum.main.MausoleumClient;
import mausoleum.ui.UIDef;
import mausoleum.usergroup.UserGroup;

public class InspectorPanelUserGroup
extends InspectorPanel
implements ActionListener {
    private static final long serialVersionUID = 145684313L;
    private static final HashMap SUB_PANELS_BY_OBJECT_TYPE = new HashMap();
    private static final String[] ACTION_BUTT_DEFS_HOS = new String[]{"UGA_SWITCH_GROUP"};
    private static final boolean MIT_SWITCH = true;
    public CSTextField ivCSName = new CSTextFieldName(this);
    public CSColor ivCSColor = new CSColor(this, null){

        public void adaptToVector(Vector v) {
            if (v != null && v.size() == 1) {
                Color color = null;
                if (v.firstElement() instanceof UserGroup) {
                    UserGroup group = (UserGroup)v.firstElement();
                    color = GroupColorManager.getColor(group.getName());
                }
                this.setColor(color);
            } else {
                this.setToNonApplicable();
            }
        }
    };

    public InspectorPanelUserGroup() {
        super(18, "GROUPS");
        this.addTab(Babel.get("ATTRIBUTES"), new UserGroupAttributePanel());
        this.addTab(Babel.get("RACKS"), new ServicableGroupObjectsPanel(3, "UGA_IMPORT_RACK"));
        this.addTab(Babel.get("LINES"), new ServicableGroupObjectsPanelWithDocs(7, "UGA_IMPORT_LINE"));
        this.addTab(Babel.get("LOCI"), new ServicableGroupObjectsPanelWithDocs(14, "UGA_IMPORT_LOCUS"));
        this.addTab(Babel.get("STRAINS"), new ServicableGroupObjectsPanelWithDocs(8, "UGA_IMPORT_STRAIN"));
        this.addTab(Babel.get("LICENSES"), new ServicableGroupObjectsPanelWithDocs(16, "UGA_IMPORT_LICENSE"));
        IAManager.registerAfterBurnerForCommand("UGA_IMPORT_RACK", this);
        IAManager.registerAfterBurnerForCommand("UGA_IMPORT_LICENSE", this);
        IAManager.registerAfterBurnerForCommand("UGA_IMPORT_LINE", this);
        IAManager.registerAfterBurnerForCommand("UGA_IMPORT_STRAIN", this);
        IAManager.registerAfterBurnerForCommand("UGA_IMPORT_LOCUS", this);
    }

    public ActionBundleSimple createActionBundle() {
        return MausoleumClient.isHeadOfService() ? new ActionBundleSimple(ACTION_BUTT_DEFS_HOS, 1) : null;
    }

    public boolean isSetAllowed() {
        return MausoleumClient.isHeadOfService();
    }

    public boolean doNew(boolean withExecution) {
        return false;
    }

    public boolean doRemove(boolean withExecution) {
        return false;
    }

    public void passiviereFelder() {
        this.ivCSName.setToPassive();
        this.ivCSColor.setToPassive();
    }

    public void disableFields() {
        this.ivCSName.setToNonApplicable();
        this.ivCSColor.setToNonApplicable();
    }

    public void doTheSet() {
        if (!this.ivSelObjects.isEmpty()) {
            Vector changeSensitives = this.getTheRealChangedItems();
            if (changeSensitives != null && !changeSensitives.isEmpty()) {
                int i = 0;
                while (i < changeSensitives.size()) {
                    if (changeSensitives.elementAt(i) == this.ivCSColor) {
                        Iterator iter = this.ivSelObjects.iterator();
                        while (iter.hasNext()) {
                            UserGroup ug = (UserGroup)iter.next();
                            ug.changeColor(this.ivCSColor.getValue());
                        }
                        this.ivCSColor.adaptToVector(this.ivSelObjects);
                    }
                    ++i;
                }
            }
            this.repaint();
        }
    }

    public String getSetCommand(Vector changeSensitives, Vector idObjects) {
        return null;
    }

    public void actionPerformed(ActionEvent arg0) {
        ServicableGroupObjectsPanel rap;
        String command = arg0.getActionCommand();
        Integer typeToRefresh = UsergroupAction.getTypeForCommand(command);
        if ("UGA_IMPORT_RACK".equals(command)) {
            if (this.ivSelObjects != null && this.ivSelObjects.size() == 1) {
                UserGroup ug = (UserGroup)this.ivSelObjects.firstElement();
                UsergroupAction.invalidateRackStatus(ug.getName());
            }
        } else if (!("UGA_IMPORT_STRAIN".equals(command) || "UGA_IMPORT_LICENSE".equals(command) || "UGA_IMPORT_LINE".equals(command))) {
            "UGA_IMPORT_LOCUS".equals(command);
        }
        if (typeToRefresh != null && (rap = (ServicableGroupObjectsPanel)SUB_PANELS_BY_OBJECT_TYPE.get(typeToRefresh)) != null) {
            rap.adapt(this.ivSelObjects, null, null, true);
        }
    }

    class ServicableGroupObjectsPanel
    extends RequesterPane
    implements IPTabPanel {
        private static final long serialVersionUID = 45464561L;
        protected final int ivObjectType;
        protected final Integer ivObjectTypeINT;
        protected final String ivUGACommand;
        protected SimpleList ivMerkerList = new SimpleList();
        protected JScrollPane ivMerkerPane = new JScrollPane(this.ivMerkerList);
        protected UserGroup ivLastSelectedUserGroup = null;
        protected Vector ivMerkers = null;
        protected InspectorActionButton ivImportActionButton = null;

        public ServicableGroupObjectsPanel(int objectType, String importAction) {
            super(null, "inspectorBack");
            this.ivObjectType = objectType;
            this.ivObjectTypeINT = new Integer(objectType);
            this.ivUGACommand = importAction;
            SUB_PANELS_BY_OBJECT_TYPE.put(this.ivObjectTypeINT, this);
            if (this.ivUGACommand != null) {
                this.ivImportActionButton = InspectorActionButton.createButton(this.ivUGACommand, InspectorPanelUserGroup.this.ivActionButtons, this);
                this.add(this.ivImportActionButton);
            }
            this.setLayout(new SimpleLayoutManager(this){
                final /* synthetic */ ServicableGroupObjectsPanel this$1;
                {
                    this.this$1 = servicableGroupObjectsPanel;
                }

                public void layoutContainer(Container arg0) {
                    Dimension d = arg0.getSize();
                    if (this.this$1.ivImportActionButton != null) {
                        int oh = d.height - UIDef.INNER_RAND - UIDef.BUT_HEIGHT;
                        this.this$1.ivMerkerPane.setBounds(0, 0, d.width, oh);
                        this.this$1.ivImportActionButton.setBounds(0, oh + UIDef.INNER_RAND, d.width, UIDef.BUT_HEIGHT);
                    } else {
                        this.this$1.ivMerkerPane.setBounds(0, 0, d.width, d.height);
                    }
                }
            });
            this.add(this.ivMerkerPane);
            this.ivMerkerList.setSelectionMode(2);
            this.ivMerkerList.setRenderHook(new SimpleListHook(this){
                final /* synthetic */ ServicableGroupObjectsPanel this$1;
                {
                    this.this$1 = servicableGroupObjectsPanel;
                }

                public void modify(Object value, JLabel label) {
                    if (value != null && value instanceof BasicObjectMerker) {
                        BasicObjectMerker bom = (BasicObjectMerker)value;
                        if (bom.ivDocumentInfo != null && bom.ivDocumentInfo.length() != 0) {
                            label.setIcon(ImageProvider.getBulletIcon(Color.green));
                        } else {
                            label.setIcon(ImageProvider.CLEAR_BULLET_ICON);
                        }
                        label.setHorizontalTextPosition(4);
                        label.setIconTextGap(4);
                        if (bom.ivServiceID != -1L) {
                            label.setFont(FontManager.getFont("SSP11"));
                        } else {
                            label.setFont(FontManager.getFont("SSB11"));
                        }
                    }
                }
            });
            this.ivMerkerList.addListSelectionListener(new ListSelectionListener(this){
                final /* synthetic */ ServicableGroupObjectsPanel this$1;
                {
                    this.this$1 = servicableGroupObjectsPanel;
                }

                public void valueChanged(ListSelectionEvent arg0) {
                    this.this$1.listSelected();
                }
            });
            this.checkButs();
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            this.adapt(idObjects, mice, changeSensitives, false);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives, boolean overrideOldSelection) {
            if (idObjects == null || idObjects.size() != 1) {
                this.ivMerkerList.setListData(ArrayHelper.LEER);
            } else {
                UserGroup ug = (UserGroup)InspectorPanelUserGroup.this.ivSelObjects.firstElement();
                if (overrideOldSelection || ug != this.ivLastSelectedUserGroup) {
                    this.ivLastSelectedUserGroup = ug;
                    this.ivMerkers = this.ivObjectType == 3 ? UsergroupAction.getRackMerkers(ug.getName(), false) : UsergroupAction.getBasicObjectMerkers(ug.getName(), this.ivObjectType);
                    Collections.sort(this.ivMerkers);
                    this.ivMerkerList.setListData(this.ivMerkers);
                }
            }
            this.listSelected();
        }

        protected void listSelected() {
            UsergroupAction.setSelectedMerker(this.ivObjectTypeINT, this.ivMerkerList.getSelectedValues());
            InspectorPanelUserGroup.this.manageButEnabling(this.ivUGACommand, null, true);
            this.checkButs();
        }

        protected void checkButs() {
        }
    }

    class ServicableGroupObjectsPanelWithDocs
    extends ServicableGroupObjectsPanel {
        private static final long serialVersionUID = 45464561L;
        private DocumentsTable ivDocumentsTable = new DocumentsTable();
        private JScrollPane ivDocumentsPane = new JScrollPane(this.ivDocumentsTable);
        private MGButton ivAddDocuButton = new MGButton(Babel.get("IP_ADD_DOCU"));
        private MGButton ivShowDocuButton = new MGButton(Babel.get("IP_SHOW_DOCU"));
        private MGButton ivOpenDocuButton = new MGButton(Babel.get("IP_OPEN_DOCU"));

        public ServicableGroupObjectsPanelWithDocs(int objectType, String importAction) {
            super(objectType, importAction);
            this.setLayout(new SimpleLayoutManager(this){
                final /* synthetic */ ServicableGroupObjectsPanelWithDocs this$1;
                {
                    this.this$1 = servicableGroupObjectsPanelWithDocs;
                }

                public void layoutContainer(Container arg0) {
                    Dimension d = arg0.getSize();
                    int y = 0;
                    int oh = (d.height - UIDef.INNER_RAND) / 2;
                    int uh = d.height - UIDef.INNER_RAND - oh - UIDef.INNER_RAND - UIDef.BUT_HEIGHT;
                    this.this$1.ivMerkerPane.setBounds(0, y, d.width, oh);
                    y += oh + UIDef.INNER_RAND;
                    if (this.this$1.ivImportActionButton != null) {
                        int spaceForAB = UIDef.BUT_HEIGHT + UIDef.RAND;
                        this.this$1.ivImportActionButton.setBounds(0, oh + UIDef.INNER_RAND, d.width, UIDef.BUT_HEIGHT);
                        uh -= spaceForAB;
                        y += spaceForAB;
                    }
                    ServicableGroupObjectsPanelWithDocs.access$0(this.this$1).setBounds(0, y, d.width, uh);
                    int lw = (d.width - 2 * UIDef.INNER_RAND) / 3;
                    int rw = d.width - 2 * UIDef.INNER_RAND - 2 * lw;
                    int x = 0;
                    ServicableGroupObjectsPanelWithDocs.access$1(this.this$1).setBounds(x, y += uh + UIDef.INNER_RAND, lw, UIDef.BUT_HEIGHT);
                    ServicableGroupObjectsPanelWithDocs.access$2(this.this$1).setBounds(x += lw + UIDef.INNER_RAND, y, lw, UIDef.BUT_HEIGHT);
                    ServicableGroupObjectsPanelWithDocs.access$3(this.this$1).setBounds(x += lw + UIDef.INNER_RAND, y, rw, UIDef.BUT_HEIGHT);
                }
            });
            this.add(this.ivDocumentsPane);
            this.ivDocumentsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
                final /* synthetic */ ServicableGroupObjectsPanelWithDocs this$1;
                {
                    this.this$1 = servicableGroupObjectsPanelWithDocs;
                }

                public void valueChanged(ListSelectionEvent arg0) {
                    if (!arg0.getValueIsAdjusting()) {
                        this.this$1.checkButs();
                    }
                }
            });
            this.ivDocumentsTable.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ ServicableGroupObjectsPanelWithDocs this$1;
                {
                    this.this$1 = servicableGroupObjectsPanelWithDocs;
                }

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ServicableGroupObjectsPanelWithDocs.access$4(this.this$1, true);
                    }
                }
            });
            this.ivShowDocuButton.addActionListener(new ActionListener(this){
                final /* synthetic */ ServicableGroupObjectsPanelWithDocs this$1;
                {
                    this.this$1 = servicableGroupObjectsPanelWithDocs;
                }

                public void actionPerformed(ActionEvent arg0) {
                    ServicableGroupObjectsPanelWithDocs.access$4(this.this$1, false);
                }
            });
            this.add(this.ivShowDocuButton);
            this.ivOpenDocuButton.addActionListener(new ActionListener(this){
                final /* synthetic */ ServicableGroupObjectsPanelWithDocs this$1;
                {
                    this.this$1 = servicableGroupObjectsPanelWithDocs;
                }

                public void actionPerformed(ActionEvent arg0) {
                    ServicableGroupObjectsPanelWithDocs.access$4(this.this$1, true);
                }
            });
            this.add(this.ivOpenDocuButton);
            this.ivAddDocuButton.addActionListener(new ActionListener(this){
                final /* synthetic */ ServicableGroupObjectsPanelWithDocs this$1;
                {
                    this.this$1 = servicableGroupObjectsPanelWithDocs;
                }

                public void actionPerformed(ActionEvent arg0) {
                    BasicObjectMerker bom;
                    if (this.this$1.ivLastSelectedUserGroup != null && (bom = (BasicObjectMerker)this.this$1.ivMerkerList.getSelectedValue()) != null) {
                        long[] arr = new long[]{this.this$1.ivObjectType, bom.ivIDInGroup};
                        Vector<long[]> v = new Vector<long[]>();
                        v.add(arr);
                        HashMap<String, Vector<long[]>> obsByGroup = new HashMap<String, Vector<long[]>>();
                        obsByGroup.put(this.this$1.ivLastSelectedUserGroup.ivName, v);
                        if (AddDocuButton.addDocu(obsByGroup)) {
                            this.this$1.ivMerkers = UsergroupAction.getBasicObjectMerkers(this.this$1.ivLastSelectedUserGroup.getName(), this.this$1.ivObjectType);
                            Collections.sort(this.this$1.ivMerkers);
                            this.this$1.ivMerkerList.setListData(this.this$1.ivMerkers);
                            BasicObjectMerker bom2 = null;
                            Iterator<E> iterator = this.this$1.ivMerkers.iterator();
                            while (iterator.hasNext() && bom2 == null) {
                                BasicObjectMerker tbom = (BasicObjectMerker)iterator.next();
                                if (tbom.ivIDInGroup != bom.ivIDInGroup) continue;
                                bom2 = tbom;
                            }
                            if (bom2 != null) {
                                this.this$1.ivMerkerList.setSelectedValue(bom2, true);
                            }
                        }
                    }
                }
            });
            this.add(this.ivAddDocuButton);
        }

        protected void listSelected() {
            BasicObjectMerker bom = (BasicObjectMerker)this.ivMerkerList.getSelectedValue();
            if (bom != null) {
                HashMap hs = new HashMap();
                DocumentsPane.interpretDocString(bom.ivDocumentInfo, "service", hs);
                this.ivDocumentsTable.setData(hs);
            } else {
                this.ivDocumentsTable.setData(null);
            }
            super.listSelected();
        }

        protected void checkButs() {
            if (this.ivAddDocuButton != null) {
                boolean addOK = false;
                boolean showOK = false;
                BasicObjectMerker bom = (BasicObjectMerker)this.ivMerkerList.getSelectedValue();
                if (bom != null) {
                    addOK = true;
                    showOK = this.ivDocumentsTable.getSelectedKennung(null) != null;
                }
                this.ivAddDocuButton.setEnabled(addOK);
                this.ivShowDocuButton.setEnabled(showOK);
                this.ivOpenDocuButton.setEnabled(showOK);
            }
        }

        private void showDocu(boolean openIt) {
            BasicObjectMerker bom = (BasicObjectMerker)this.ivMerkerList.getSelectedValue();
            if (bom != null) {
                String group = bom.ivServiceID != -1L ? "service" : this.ivLastSelectedUserGroup.ivName;
                String selKennung = this.ivDocumentsTable.getSelectedKennung(null);
                if (selKennung != null && this.ivLastSelectedUserGroup != null && this.ivLastSelectedUserGroup.ivName != null) {
                    ShowDocuButton.loadDocu(selKennung, group, this.ivDocumentsTable.getSelectedFilename(null), openIt);
                }
            }
        }

        static /* synthetic */ JScrollPane access$0(ServicableGroupObjectsPanelWithDocs servicableGroupObjectsPanelWithDocs) {
            return servicableGroupObjectsPanelWithDocs.ivDocumentsPane;
        }

        static /* synthetic */ MGButton access$1(ServicableGroupObjectsPanelWithDocs servicableGroupObjectsPanelWithDocs) {
            return servicableGroupObjectsPanelWithDocs.ivAddDocuButton;
        }

        static /* synthetic */ MGButton access$2(ServicableGroupObjectsPanelWithDocs servicableGroupObjectsPanelWithDocs) {
            return servicableGroupObjectsPanelWithDocs.ivShowDocuButton;
        }

        static /* synthetic */ MGButton access$3(ServicableGroupObjectsPanelWithDocs servicableGroupObjectsPanelWithDocs) {
            return servicableGroupObjectsPanelWithDocs.ivOpenDocuButton;
        }

        static /* synthetic */ void access$4(ServicableGroupObjectsPanelWithDocs servicableGroupObjectsPanelWithDocs, boolean bl) {
            servicableGroupObjectsPanelWithDocs.showDocu(bl);
        }
    }

    class UserGroupAttributePanel
    extends AttributePane {
        private static final long serialVersionUID = 5067010713733060702L;

        public UserGroupAttributePanel() {
            InspectorPanelUserGroup.this.ivSensitiveTable = new SensitiveTable(InspectorPanelUserGroup.this.ivChangeSensitives);
            this.add(InspectorPanelUserGroup.this.ivSensitiveTable);
        }

        public void layoutContainer(Container parent) {
            InspectorPanelUserGroup.this.ivSensitiveTable.setBounds(Inspector.INTER_BUT, Inspector.INTER_BUT, parent.getSize().width - 2 * Inspector.INTER_BUT, InspectorPanelUserGroup.this.ivSensitiveTable.getPreferredSize().height);
        }

        public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
            super.adapt(idObjects, mice, changeSensitives);
            if (idObjects != null && idObjects.size() == 1) {
                InspectorPanelUserGroup.this.ivCSName.setToPassive();
                InspectorPanelUserGroup.this.ivCSColor.setState(Privileges.hasPrivilege("GROUPS_CHANGE_COLOR"));
            }
        }
    }
}

