/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.util.Date;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;

public class MousePlugDateObject {
    public final String ivGroup;
    public final long ivMouseID;
    public final int ivEartag;
    public final int ivDatum;
    public final boolean ivItsMine;
    public final boolean ivAlive;
    public final boolean ivIsCurrentPlugAlert;

    public static void addPlugDates(Mouse maus, Vector target) {
        int[] arr;
        if (maus.getSex() == 2 && (arr = (int[])maus.get("MOS_ALLPLUGDATES")) != null) {
            int i = 0;
            while (i < arr.length) {
                target.add(new MousePlugDateObject(maus, arr[i]));
                ++i;
            }
        }
    }

    private MousePlugDateObject(Mouse maus, int datum) {
        this.ivGroup = maus.getGroup();
        this.ivMouseID = maus.getID();
        this.ivEartag = maus.getInt("MOS_EARTAG");
        this.ivDatum = datum;
        this.ivItsMine = maus.itsMine(null);
        this.ivAlive = maus.isAlive();
        Date d = maus.getDate("MOS_PLUGDATE");
        this.ivIsCurrentPlugAlert = d != null && MyDate.getTage(d) == datum;
    }

    public String getCLLWEartagString() {
        return MouseManager.getMouse(this.ivMouseID, this.ivGroup).getCLLWEartagString("[?]", true, true);
    }

    public String getCLLWDateString() {
        if (this.ivIsCurrentPlugAlert) {
            return String.valueOf(DatumFormat.getJustDateString(this.ivDatum)) + " (" + Babel.get("ACT_PLUG_ALERT") + ")";
        }
        return DatumFormat.getJustDateString(this.ivDatum);
    }
}

