/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.ui.UIDef;

public class ObjectPopup
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int COLS = 3;
    private static final Border SELECT_BORDER = new EtchedBorder(Color.black, Color.white);
    private final HashSet ivAlarme = new HashSet();
    private int ivRows = 0;
    private JTable ivTable = null;
    private Container ivContainer = null;
    private JLabel ivLabel = new JLabel();
    private Point ivHighlightPoint = new Point(1, 1);
    static /* synthetic */ Class class$0;

    public ObjectPopup() {
        super(new BorderLayout());
        this.setBorder(new LineBorder(Color.black, 1));
        this.ivRows = Inspector.OBJECT_STRINGS.size() % 3 != 0 ? Inspector.OBJECT_STRINGS.size() / 3 + 1 : Inspector.OBJECT_STRINGS.size() / 3;
        this.ivLabel.setFont(FontManager.getFont("SSB16"));
        this.ivLabel.setHorizontalAlignment(0);
        int ebw = UIDef.getScaled(4);
        this.ivLabel.setBorder(new EmptyBorder(ebw, ebw, ebw, ebw));
        this.ivTable = new JTable(new TableModel(){

            public void addTableModelListener(TableModelListener arg0) {
            }

            public Class getColumnClass(int arg0) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }

            public int getColumnCount() {
                return 3;
            }

            public String getColumnName(int arg0) {
                return null;
            }

            public int getRowCount() {
                return ObjectPopup.this.ivRows;
            }

            public Object getValueAt(int row, int col) {
                int ind = row * 3 + col;
                if (ind >= 0 && ind < Inspector.OBJECT_STRINGS.size()) {
                    return Inspector.OBJECT_STRINGS.elementAt(ind);
                }
                return "";
            }

            public boolean isCellEditable(int arg0, int arg1) {
                return false;
            }

            public void removeTableModelListener(TableModelListener arg0) {
            }

            public void setValueAt(Object arg0, int arg1, int arg2) {
            }
        });
        this.ivTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                ObjectPopup.this.dismiss(arg0);
            }

            public void mouseExited(MouseEvent arg0) {
                ObjectPopup.this.dismiss(null);
            }
        });
        this.ivTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                int col = ObjectPopup.this.ivTable.columnAtPoint(e.getPoint());
                int row = ObjectPopup.this.ivTable.rowAtPoint(e.getPoint());
                if (col < 0 || col >= 3 || row < 0 || row >= ObjectPopup.this.ivRows) {
                    ObjectPopup.this.dismiss(null);
                } else if (((ObjectPopup)ObjectPopup.this).ivHighlightPoint.x != col || ((ObjectPopup)ObjectPopup.this).ivHighlightPoint.y != row) {
                    ((ObjectPopup)ObjectPopup.this).ivHighlightPoint.x = col;
                    ((ObjectPopup)ObjectPopup.this).ivHighlightPoint.y = row;
                    ObjectPopup.this.ivTable.repaint();
                }
            }
        });
        this.ivTable.setRowHeight(UIDef.getScaled(24));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ivTable.setDefaultRenderer(clazz, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String val = (String)value;
                ObjectPopup.this.ivLabel.setText(val);
                if (((ObjectPopup)ObjectPopup.this).ivHighlightPoint.x == column && ((ObjectPopup)ObjectPopup.this).ivHighlightPoint.y == row && val.trim().length() != 0) {
                    ObjectPopup.this.ivLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                    ObjectPopup.this.ivLabel.setOpaque(true);
                    ObjectPopup.this.ivLabel.setForeground(Color.black);
                    ObjectPopup.this.ivLabel.setBorder(SELECT_BORDER);
                } else if (ObjectPopup.this.ivAlarme.contains(val)) {
                    ObjectPopup.this.ivLabel.setBackground(UIDef.ALARM_COLOR);
                    ObjectPopup.this.ivLabel.setOpaque(true);
                    ObjectPopup.this.ivLabel.setForeground(Color.white);
                    ObjectPopup.this.ivLabel.setBorder(null);
                } else {
                    ObjectPopup.this.ivLabel.setBackground(null);
                    ObjectPopup.this.ivLabel.setOpaque(false);
                    ObjectPopup.this.ivLabel.setForeground(Color.black);
                    ObjectPopup.this.ivLabel.setBorder(null);
                }
                return ObjectPopup.this.ivLabel;
            }
        });
        this.ivTable.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                ObjectPopup.this.dismiss(null);
            }
        });
        this.ivTable.setShowGrid(false);
        this.add("Center", this.ivTable);
        this.setFont(FontManager.getFont("SSB18"));
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.setPreferredSize(this.ivTable.getPreferredSize());
        this.validate();
    }

    public void adaptToNewUser() {
        this.ivRows = Inspector.OBJECT_STRINGS.size() % 3 != 0 ? Inspector.OBJECT_STRINGS.size() / 3 + 1 : Inspector.OBJECT_STRINGS.size() / 3;
        this.ivTable.tableChanged(new TableModelEvent(this.ivTable.getModel()));
    }

    public void addAlarm(String s) {
        this.ivAlarme.add(s);
    }

    public void removeAlarm(String s) {
        this.ivAlarme.remove(s);
    }

    public void showUp(Container panel, JComponent drueber) {
        if (this.ivContainer == null) {
            Rectangle r = drueber.getBounds();
            this.ivContainer = panel;
            this.ivHighlightPoint.x = -1;
            this.ivHighlightPoint.y = -1;
            this.setBounds(r.x, r.y + r.height, r.width, this.getPreferredSize().height);
            this.validate();
            panel.add(this);
            panel.setComponentZOrder(this, 0);
            panel.validate();
            panel.repaint();
        }
    }

    public void dismiss(MouseEvent e) {
        if (this.ivContainer != null) {
            this.ivContainer.remove(this);
            this.ivContainer.repaint();
            this.ivContainer = null;
            if (e != null) {
                int col = this.ivTable.columnAtPoint(e.getPoint());
                int row = this.ivTable.rowAtPoint(e.getPoint());
                String val = "";
                int ind = row * 3 + col;
                if (ind >= 0 && ind < Inspector.OBJECT_COMMANDS.size()) {
                    val = (String)Inspector.OBJECT_COMMANDS.elementAt(ind);
                }
                if (val.trim().length() != 0) {
                    Inspector.getInspector().actionPerformed(new ActionEvent(this, 0, val));
                }
            }
        }
    }
}

