/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.WindowUtils;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTUserInOwnerGroupInspector;
import mausoleum.ui.UIDef;

public class OwnerGroupMemberPanel
extends JPanel
implements LayoutManager,
ActionListener,
ObjectConsumer {
    private static final long serialVersionUID = 6987705981716935926L;
    private static final int RAND = UIDef.INNER_RAND;
    private static final int BUT_HEIGHT = UIDef.getScaled(20);
    private MGButton ivAddButton = MGButton.getInspectorActionButton(Babel.get("ADD_MEMBER"), "ADD_MEMBER");
    private MGButton ivDelButton = MGButton.getInspectorActionButton(Babel.get("REMOVE_MEMBER"), "REMOVE_MEMBER");
    private MGButton ivPrimButton = MGButton.getInspectorActionButton(Babel.get("SETPRIMARYUSER"), "SETPRIMARYUSER");
    private final Vector ivOwnerGroups = new Vector();
    private MausoleumTable ivMembersTable = new MausoleumTable(new MTUserInOwnerGroupInspector(), true);
    private final Vector ivAktMembers = new Vector();
    private final Vector ivPotentialMembers = new Vector();
    static /* synthetic */ Class class$0;

    public OwnerGroupMemberPanel() {
        this.setOpaque(false);
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int innerheight = d.height;
                int innerwidth = d.width;
                int oheight = innerheight - BUT_HEIGHT - RAND;
                int y = 0;
                ((OwnerGroupMemberPanel)OwnerGroupMemberPanel.this).ivMembersTable.ivScrollPane.setBounds(0, y, innerwidth, oheight);
                int anzButs = 3;
                int lbw = (innerwidth - (anzButs - 1) * RAND) / anzButs;
                int rbw = innerwidth - (anzButs - 1) * (RAND + lbw);
                int x = 0;
                OwnerGroupMemberPanel.this.ivAddButton.setBounds(x, y += oheight + RAND, lbw, BUT_HEIGHT);
                OwnerGroupMemberPanel.this.ivDelButton.setBounds(x += lbw + RAND, y, lbw, BUT_HEIGHT);
                OwnerGroupMemberPanel.this.ivPrimButton.setBounds(x += lbw + RAND, y, rbw, BUT_HEIGHT);
            }
        });
        this.ivMembersTable.ivModel.addSelectionListener(new MausoleumTableSelectionListener(){

            public void selectionChanged(MausoleumTableModel mt) {
                OwnerGroupMemberPanel.this.checkButs();
            }
        });
        this.add(this.ivMembersTable.ivScrollPane);
        this.add(this.ivAddButton);
        this.add(this.ivDelButton);
        this.add(this.ivPrimButton);
        this.ivAddButton.addActionListener(this);
        this.ivDelButton.addActionListener(this);
        this.ivPrimButton.addActionListener(this);
        this.ivAddButton.setEnabled(false);
        this.ivDelButton.setEnabled(false);
        this.ivPrimButton.setEnabled(false);
        ObjectStoreClient.addConsumer((ObjectConsumer)this, 1);
    }

    public void adaptToVector(Vector v) {
        this.ivOwnerGroups.clear();
        if (v != null) {
            this.ivOwnerGroups.addAll(v);
        }
        if (this.ivOwnerGroups.size() == 1) {
            this.determineMembers();
        } else {
            this.ivAktMembers.clear();
            this.ivPotentialMembers.clear();
        }
        this.ivMembersTable.ivModel.setTable(this.ivAktMembers);
        this.ivMembersTable.setEnabled(this.ivOwnerGroups.size() == 1);
        this.ivAddButton.setEnabled(!this.ivPotentialMembers.isEmpty() && this.ivOwnerGroups.size() == 1);
        this.checkButs();
    }

    private void checkButs() {
        boolean delEnabled = false;
        boolean setPrimEnabled = false;
        Vector v = this.ivMembersTable.ivModel.getSelectedObjects();
        if (v != null && !v.isEmpty() && (delEnabled = Privileges.hasPrivilege("OWG_CH_USERS")) && v.size() == 1 && this.ivOwnerGroups.size() == 1) {
            User user = (User)v.elementAt(0);
            IDObjectGroup iog = (IDObjectGroup)this.ivOwnerGroups.elementAt(0);
            long[] obgMemberIDs = (long[])iog.get("IOG_IDS");
            setPrimEnabled = obgMemberIDs != null && obgMemberIDs.length > 0 && obgMemberIDs[0] != user.getID();
        }
        this.ivDelButton.setEnabled(delEnabled);
        this.ivPrimButton.setEnabled(setPrimEnabled);
    }

    private void determineMembers() {
        long primID = -1L;
        HashSet<User> memberHS = new HashSet<User>();
        Iterator iter = this.ivOwnerGroups.iterator();
        while (iter.hasNext()) {
            long[] obgMemberIDs;
            IDObjectGroup iog = (IDObjectGroup)iter.next();
            String group = iog.getGroup();
            if (group == null || (obgMemberIDs = (long[])iog.get("IOG_IDS")) == null) continue;
            int i = 0;
            while (i < obgMemberIDs.length) {
                User user;
                if (i == 0) {
                    primID = obgMemberIDs[i];
                }
                if ((user = (User)UserManager.cvInstance.getObject(new Long(obgMemberIDs[i]), group)) != null) {
                    memberHS.add(user);
                }
                ++i;
            }
        }
        this.ivAktMembers.clear();
        this.ivAktMembers.addAll(memberHS);
        ((MTUserInOwnerGroupInspector)this.ivMembersTable.ivModel).setPrimaerID(primID);
        this.ivPotentialMembers.clear();
        String group = IDObject.commonGroup(this.ivOwnerGroups);
        if (group != null) {
            Vector auv = UserManager.getActualObjects(group);
            Iterator iter2 = auv.iterator();
            while (iter2.hasNext()) {
                User user = (User)iter2.next();
                if (!Privileges.hasPrivilege(user, "CAN_OWN") || memberHS.contains(user)) continue;
                this.ivPotentialMembers.add(user);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Vector selectedUsers;
        StringBuffer msb = new StringBuffer();
        String group = IDObject.commonGroup(this.ivOwnerGroups);
        String comm = e.getActionCommand();
        if (comm.equals("ADD_MEMBER")) {
            if (this.ivOwnerGroups != null && !this.ivOwnerGroups.isEmpty() && group != null) {
                this.determineMembers();
                if (!this.ivPotentialMembers.isEmpty()) {
                    Vector<String> namen = new Vector<String>();
                    Iterator iter = this.ivPotentialMembers.iterator();
                    while (iter.hasNext()) {
                        User user = (User)iter.next();
                        namen.add(user.getName());
                    }
                    int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("SELECT_MEMBER"), namen);
                    if (ind != -1) {
                        User newMember = (User)this.ivPotentialMembers.elementAt(ind);
                        long userID = newMember.getID();
                        Iterator iter2 = this.ivOwnerGroups.iterator();
                        while (iter2.hasNext()) {
                            IDObjectGroup iog = (IDObjectGroup)iter2.next();
                            boolean isInOwnerGroup = false;
                            long[] memberIDs = (long[])iog.get("IOG_IDS");
                            if (memberIDs != null) {
                                int i = 0;
                                while (i < memberIDs.length) {
                                    if (userID == memberIDs[i]) {
                                        isInOwnerGroup = true;
                                    }
                                    ++i;
                                }
                            }
                            if (isInOwnerGroup) continue;
                            msb.append("IOGADDID").append(" ");
                            msb.append(iog.getID()).append(" ");
                            msb.append(6).append(" ");
                            msb.append(userID).append("\n");
                        }
                    }
                }
            }
        } else if (comm.equals("REMOVE_MEMBER")) {
            if (this.ivOwnerGroups != null && !this.ivOwnerGroups.isEmpty() && group != null && !(selectedUsers = this.ivMembersTable.getSelectedObjects()).isEmpty()) {
                Iterator iter = this.ivOwnerGroups.iterator();
                while (iter.hasNext()) {
                    IDObjectGroup iog = (IDObjectGroup)iter.next();
                    long groupID = iog.getID();
                    long[] memberIDs = (long[])iog.get("IOG_IDS");
                    Iterator iterator = selectedUsers.iterator();
                    while (iterator.hasNext()) {
                        User user = (User)iterator.next();
                        long userID = user.getID();
                        boolean isMember = false;
                        if (memberIDs != null) {
                            int i = 0;
                            while (i < memberIDs.length) {
                                if (memberIDs[i] == userID) {
                                    isMember = true;
                                }
                                ++i;
                            }
                        }
                        if (!isMember) continue;
                        msb.append("IOGREMID").append(" ");
                        msb.append(groupID).append(" ");
                        msb.append(6).append(" ");
                        msb.append(userID).append("\n");
                    }
                }
            }
        } else if ("SETPRIMARYUSER".equals(comm) && this.ivOwnerGroups != null && this.ivOwnerGroups.size() == 1 && group != null && (selectedUsers = this.ivMembersTable.getSelectedObjects()).size() == 1) {
            User user = (User)selectedUsers.elementAt(0);
            IDObjectGroup iog = (IDObjectGroup)this.ivOwnerGroups.elementAt(0);
            msb.append("IOGSETPRIMOWN").append(" ");
            msb.append(iog.getID()).append(" ");
            msb.append(6).append(" ");
            msb.append(user.getID()).append("\n");
        }
        if (msb.length() != 0) {
            InspectorPanel ip;
            InspectorCommandSender.executeCommand(msb.toString().toString(), group);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.inspector.InspectorPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((ip = (InspectorPanel)WindowUtils.getParent(this, clazz)) != null) {
                ip.adjustToSelectionChange(ip.ivActTable);
            }
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(300, 500);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(150, 300);
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int innerheight = d.height;
        int innerwidth = d.width;
        int oheight = innerheight - BUT_HEIGHT - RAND;
        int y = 0;
        this.ivMembersTable.ivScrollPane.setBounds(0, y, innerwidth, oheight);
        int anzButs = 2;
        int lbw = (innerwidth - (anzButs - 1) * RAND) / anzButs;
        int rbw = innerwidth - (anzButs - 1) * (RAND + lbw);
        int x = 0;
        this.ivAddButton.setBounds(x, y += oheight + RAND, lbw, BUT_HEIGHT);
        this.ivDelButton.setBounds(x += lbw + RAND, y, rbw, BUT_HEIGHT);
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
    }

    public void handleNewObject(IDObject obj) {
    }

    public void handleNewObjects(Vector idObjects) {
    }
}

