/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class PrivilegeNode
implements Comparable,
TreeNode {
    private static final HashMap TREES_BY_ROLE = new HashMap();
    private static final Vector EMPTY_VECTOR = new Vector();
    public final String ivPrivilege;
    public final String ivPrivilegeDisplay;
    public boolean ivGranted = true;
    public PrivilegeNode ivSuperNode = null;
    public Vector ivKids = null;
    public String ivCategoryName = null;
    static /* synthetic */ Class class$0;

    static {
        Vector roles = Privileges.getRoles();
        Vector categories = Privileges.getCategories();
        Iterator iter = roles.iterator();
        while (iter.hasNext()) {
            String role = (String)iter.next();
            PrivilegeNode root = new PrivilegeNode(Babel.get("PRIVILEGES"), null);
            HashMap<String, PrivilegeNode> nodesByCategory = new HashMap<String, PrivilegeNode>();
            Iterator citer = categories.iterator();
            while (citer.hasNext()) {
                String category;
                String catDisplay = category = (String)citer.next();
                String useCategory = category;
                int ind = category.indexOf("_");
                if (ind != -1) {
                    useCategory = category.substring(ind + 1, category.length());
                    catDisplay = Babel.get(useCategory);
                }
                PrivilegeNode subroot = new PrivilegeNode(catDisplay, root);
                subroot.ivCategoryName = useCategory;
                nodesByCategory.put(category, subroot);
            }
            Vector privs = Privileges.getPrivileges(role);
            Iterator piter = privs.iterator();
            while (piter.hasNext()) {
                String privilege = (String)piter.next();
                String category = Privileges.getCategory(privilege);
                if (category != null) {
                    PrivilegeNode superNode = (PrivilegeNode)nodesByCategory.get(category);
                    if (superNode != null) {
                        new PrivilegeNode(privilege, null, superNode);
                        continue;
                    }
                    String string = "Node fehlt fuer Kateogrie: " + category;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("mausoleum.inspector.PrivilegeNode");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, null, clazz);
                    continue;
                }
                String string = "Kategorie fehlt fuer Privileg: " + privilege;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.inspector.PrivilegeNode");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, null, clazz);
            }
            Vector<PrivilegeNode> toDelete = new Vector<PrivilegeNode>();
            Iterator iterator = root.ivKids.iterator();
            while (iterator.hasNext()) {
                PrivilegeNode pn = (PrivilegeNode)iterator.next();
                if (pn.getChildCount() != 0) continue;
                toDelete.add(pn);
            }
            iterator = toDelete.iterator();
            while (iterator.hasNext()) {
                root.ivKids.remove(iterator.next());
            }
            TREES_BY_ROLE.put(role, root);
        }
    }

    public static PrivilegeNode getTree(User user) {
        String roleDesc;
        if (Privileges.hasPrivilege("SEE_PRIVILEGES") && (roleDesc = User.getStringForStatus(user.getInt("USR_MODE", 0))) != null) {
            return (PrivilegeNode)TREES_BY_ROLE.get(roleDesc.toUpperCase().trim());
        }
        return null;
    }

    private PrivilegeNode(String displayName, PrivilegeNode superNode) {
        this.ivPrivilege = null;
        this.ivPrivilegeDisplay = displayName;
        this.ivKids = new Vector();
        if (superNode != null) {
            this.ivSuperNode = superNode;
            superNode.ivKids.add(this);
        }
    }

    private PrivilegeNode(String privilege, Vector subtracteds, PrivilegeNode superNode) {
        this.ivPrivilege = privilege;
        this.ivPrivilegeDisplay = Babel.get("XXXPRIV_" + privilege);
        if (subtracteds != null) {
            boolean bl = this.ivGranted = !subtracteds.contains(privilege);
        }
        if (superNode != null) {
            this.ivSuperNode = superNode;
            superNode.ivKids.add(this);
        }
    }

    public String getCategory() {
        if (this.ivCategoryName != null) {
            return this.ivCategoryName;
        }
        if (this.ivSuperNode != null) {
            return this.ivSuperNode.getCategory();
        }
        return null;
    }

    public PrivilegeNode findCategoryNode(String catName) {
        if (catName.equals(this.ivCategoryName)) {
            return this;
        }
        if (this.ivKids != null) {
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                PrivilegeNode node = (PrivilegeNode)iter.next();
                PrivilegeNode found = node.findCategoryNode(catName);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public void adjustForUser(User user, Vector subtracteds, Vector changeSammler) {
        if (subtracteds == null) {
            subtracteds = (Vector)user.get("USR_SUBPRIV", EMPTY_VECTOR);
        }
        if (this.ivPrivilege != null) {
            boolean neuGranted;
            boolean bl = neuGranted = !subtracteds.contains(this.ivPrivilege);
            if (this.ivGranted != neuGranted) {
                this.ivGranted = neuGranted;
                changeSammler.add(this);
            }
        }
        if (this.ivKids != null) {
            Iterator iter = this.ivKids.iterator();
            while (iter.hasNext()) {
                PrivilegeNode node = (PrivilegeNode)iter.next();
                node.adjustForUser(user, subtracteds, changeSammler);
            }
        }
    }

    public int countGrantedKids() {
        int sum = 0;
        if (this.ivKids != null && !this.ivKids.isEmpty()) {
            Iterator iterator = this.ivKids.iterator();
            while (iterator.hasNext()) {
                PrivilegeNode pnode = (PrivilegeNode)iterator.next();
                if (!pnode.ivGranted) continue;
                ++sum;
            }
        }
        return sum;
    }

    public void collectForGrant(boolean grant, Vector target) {
        if (this.ivKids != null && !this.ivKids.isEmpty()) {
            Iterator iterator = this.ivKids.iterator();
            while (iterator.hasNext()) {
                PrivilegeNode pnode = (PrivilegeNode)iterator.next();
                pnode.collectForGrant(grant, target);
            }
        } else if (this.ivPrivilege != null) {
            if (grant) {
                if (!this.ivGranted) {
                    target.add(this);
                }
            } else if (this.ivGranted) {
                target.add(this);
            }
        }
    }

    public int compareTo(Object o) {
        if (o instanceof PrivilegeNode) {
            PrivilegeNode pdo = (PrivilegeNode)o;
            return this.ivPrivilegeDisplay.compareToIgnoreCase(pdo.ivPrivilegeDisplay);
        }
        return 0;
    }

    public Enumeration children() {
        if (this.ivKids != null) {
            return this.ivKids.elements();
        }
        return null;
    }

    public boolean getAllowsChildren() {
        return this.ivKids != null;
    }

    public TreeNode getChildAt(int childIndex) {
        if (this.ivKids != null) {
            return (TreeNode)this.ivKids.elementAt(childIndex);
        }
        return null;
    }

    public int getChildCount() {
        if (this.ivKids != null) {
            return this.ivKids.size();
        }
        return 0;
    }

    public int getIndex(TreeNode node) {
        if (this.ivKids != null) {
            return this.ivKids.indexOf(node);
        }
        return 0;
    }

    public TreeNode getParent() {
        return this.ivSuperNode;
    }

    public boolean isLeaf() {
        return this.ivKids == null || this.ivKids.isEmpty();
    }
}

