/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.inspector.PrivilegeNode;

public class PrivilegeTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private static final long serialVersionUID = 1L;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hatFocus) {
        super.getTreeCellRendererComponent(tree, value, false, expanded, leaf, row, false);
        if (value instanceof PrivilegeNode) {
            PrivilegeNode pdo = (PrivilegeNode)value;
            if (pdo.ivSuperNode == null) {
                this.setText(pdo.ivPrivilegeDisplay);
                this.setIcon(null);
                this.setFont(FontManager.getFont("SSB11"));
            } else if (pdo.ivPrivilege == null) {
                int grantedKids = pdo.countGrantedKids();
                this.setText(String.valueOf(pdo.ivPrivilegeDisplay) + " (" + grantedKids + ")");
                this.setIcon(null);
                this.setFont(FontManager.getFont(grantedKids != 0 ? "SSB11" : "SSP11"));
            } else {
                this.setText(pdo.ivPrivilegeDisplay);
                this.setIcon(pdo.ivGranted ? ImageProvider.CHECK_SEL_ICON : ImageProvider.CHECK_UNSEL_ICON);
                this.setFont(FontManager.getFont(pdo.ivGranted ? "SSB11" : "SSP11"));
            }
        }
        this.setBorder(null);
        return this;
    }
}

