/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.sensitives.CSColor;
import mausoleum.inspector.sensitives.CSLabelLieferant;
import mausoleum.inspector.sensitives.CSTextArea;
import mausoleum.inspector.sensitives.ChangeSensitive;
import mausoleum.requester.color.ColorTestLabel;
import mausoleum.ui.UIDef;

public class SensitiveTable
extends JTable
implements TableModel,
TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX_FONT_TAG = "SSP11";
    public static final String VALUE_FONT_TAG = "SSB12";
    private static final String NOTSET_FONT_TAG = "SSI09";
    public static final Color ENABLED_COLOR = UIDef.YELLOW_COLOR;
    public static final Color NA_COLOR = UIDef.GRAY_COLOR;
    private static final Border SELECTED_BORDER = new MatteBorder(1, 5, 1, 5, UIDef.SELECTED_BACKGROUND);
    private static final Border ENABLED_BORDER = new MatteBorder(1, 5, 1, 5, ENABLED_COLOR);
    private static final Border DISABLED_BORDER = new MatteBorder(1, 5, 1, 5, Color.white);
    private final Vector ivSensitives = new Vector();
    private final JLabel ivValueLabel = new JLabel("Ay\u00f6qr");
    private final JLabel ivTileLabel = new JLabel();
    private final JLabel ivNALabel = new JLabel();
    private final ColorTestLabel ivColorTestLabel = new ColorTestLabel();
    private int ivCol0Width = 0;
    private int ivAktSel = -1;
    private int ivLastSel = -1;
    static /* synthetic */ Class class$0;

    public SensitiveTable(Vector sensitives) {
        this.ivValueLabel.setFont(FontManager.getFont(VALUE_FONT_TAG));
        this.ivTileLabel.setForeground(Color.black);
        this.ivTileLabel.setOpaque(false);
        this.ivTileLabel.setHorizontalAlignment(2);
        this.ivTileLabel.setFont(FontManager.getFont(PREFIX_FONT_TAG));
        this.ivNALabel.setOpaque(true);
        this.ivNALabel.setBackground(NA_COLOR);
        this.ivNALabel.setHorizontalAlignment(0);
        this.ivNALabel.setFont(FontManager.getFont(NOTSET_FONT_TAG));
        this.ivNALabel.setText(" - " + Babel.get("NOTAPPLIC") + " - ");
        this.setRowHeight(this.ivValueLabel.getPreferredSize().height + 1);
        this.setBorder(new LineBorder(Color.black, 1));
        FontMetrics fm = this.getFontMetrics(FontManager.getFont(PREFIX_FONT_TAG));
        Iterator iter = sensitives.iterator();
        while (iter.hasNext()) {
            ChangeSensitive cs = (ChangeSensitive)iter.next();
            if (cs instanceof CSTextArea) continue;
            this.ivSensitives.add(cs);
            int sw = fm.stringWidth(cs.getPrefixText()) + UIDef.getScaled(12);
            if (sw <= this.ivCol0Width) continue;
            this.ivCol0Width = sw;
        }
        this.setModel(this);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, this);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int csIndex = SensitiveTable.this.getIndexOfChangesensitive(e);
                if (SensitiveTable.this.ivAktSel == -1 && csIndex >= 0 && csIndex == SensitiveTable.this.ivLastSel) {
                    SensitiveTable.this.ivAktSel = SensitiveTable.this.ivLastSel;
                    SensitiveTable.this.repaint();
                } else if (SensitiveTable.this.ivAktSel != -1 && csIndex != SensitiveTable.this.ivAktSel) {
                    SensitiveTable.this.ivAktSel = -1;
                    SensitiveTable.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                int csIndex;
                if (SensitiveTable.this.ivLastSel != -1 && (csIndex = SensitiveTable.this.getIndexOfChangesensitive(e)) >= 0 && csIndex == SensitiveTable.this.ivLastSel) {
                    SensitiveTable.this.ivAktSel = SensitiveTable.this.ivLastSel;
                    SensitiveTable.this.repaint();
                }
            }

            public void mouseExited(MouseEvent e) {
                SensitiveTable.this.ivAktSel = -1;
                SensitiveTable.this.repaint();
            }

            public void mousePressed(MouseEvent e) {
                int csIndex;
                boolean repaint = false;
                if (SensitiveTable.this.ivAktSel != -1) {
                    SensitiveTable.this.ivAktSel = -1;
                    repaint = true;
                }
                if ((csIndex = SensitiveTable.this.getIndexOfChangesensitive(e)) >= 0) {
                    SensitiveTable.this.ivAktSel = csIndex;
                    SensitiveTable.this.ivLastSel = csIndex;
                    repaint = true;
                }
                if (repaint) {
                    SensitiveTable.this.repaint();
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (SensitiveTable.this.ivAktSel != -1) {
                    boolean repaint = false;
                    int csIndex = SensitiveTable.this.getIndexOfChangesensitive(e);
                    if (csIndex == SensitiveTable.this.ivAktSel) {
                        ChangeSensitive cs = (ChangeSensitive)SensitiveTable.this.ivSensitives.elementAt(csIndex);
                        Inspector.getInspector().setCursor(Cursor.getPredefinedCursor(3));
                        try {
                            ((ActionListener)((Object)cs)).actionPerformed(null);
                        }
                        catch (Exception e2) {
                            Log.error("Error changing attribute for " + cs.getClass().getName(), e2, this);
                        }
                        Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
                        repaint = true;
                    }
                    SensitiveTable.this.ivAktSel = -1;
                    SensitiveTable.this.ivLastSel = -1;
                    if (repaint) {
                        SensitiveTable.this.repaint();
                    }
                }
            }
        });
        this.setTableHeader(null);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                SensitiveTable.this.getColumnModel().getColumn(0).setPreferredWidth(SensitiveTable.this.ivCol0Width);
                SensitiveTable.this.getColumnModel().getColumn(1).setPreferredWidth(SensitiveTable.this.getSize().width - SensitiveTable.this.ivCol0Width - UIDef.getScaled(4));
            }
        });
    }

    private int getIndexOfChangesensitive(MouseEvent e) {
        ChangeSensitive cs;
        int row;
        Point p = e.getPoint();
        if (this.columnAtPoint(p) == 1 && (row = this.rowAtPoint(p)) >= 0 && row < this.ivSensitives.size() && (cs = (ChangeSensitive)this.ivSensitives.elementAt(row)) instanceof ActionListener && cs.isActive()) {
            return row;
        }
        return -1;
    }

    public void addTableModelListener(TableModelListener arg0) {
    }

    public Class getColumnClass(int arg0) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "NAME";
            }
            case 1: {
                return "VALUE";
            }
        }
        return null;
    }

    public int getRowCount() {
        return this.ivSensitives.size();
    }

    public Object getValueAt(int row, int column) {
        if (row >= 0 && row < this.ivSensitives.size()) {
            ChangeSensitive cs = (ChangeSensitive)this.ivSensitives.elementAt(row);
            switch (column) {
                case 0: {
                    return cs.getPrefixText();
                }
                case 1: {
                    return cs.getValueText();
                }
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }

    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel resLabel = this.ivValueLabel;
        if (row >= 0 && row < this.ivSensitives.size()) {
            if (column == 0) {
                this.ivTileLabel.setText(value != null ? " " + value + " " : "");
                return this.ivTileLabel;
            }
            if (column == 1) {
                ChangeSensitive cs = (ChangeSensitive)this.ivSensitives.elementAt(row);
                if (cs.isNonApplicable()) {
                    return this.ivNALabel;
                }
                if (cs instanceof CSLabelLieferant) {
                    JLabel lab = ((CSLabelLieferant)((Object)cs)).getExtraLabel();
                    if (lab != null) {
                        resLabel = lab;
                    }
                } else {
                    this.ivValueLabel.setText(value != null ? " " + value + " " : "");
                    this.ivValueLabel.setFont(FontManager.getFont(VALUE_FONT_TAG));
                    this.ivValueLabel.setHorizontalAlignment(2);
                    this.ivValueLabel.setBorder(null);
                }
                resLabel.setForeground(Color.black);
                resLabel.setOpaque(false);
                if (cs instanceof CSColor) {
                    CSColor cb = (CSColor)cs;
                    if (cs.isActive()) {
                        this.ivColorTestLabel.setBorder(row == this.ivAktSel ? SELECTED_BORDER : ENABLED_BORDER);
                    } else {
                        this.ivColorTestLabel.setBorder(DISABLED_BORDER);
                    }
                    this.ivColorTestLabel.setBackground(cb.getValue());
                    return this.ivColorTestLabel;
                }
                if (cs.isActive()) {
                    if (cs.didYouChange()) {
                        resLabel.setForeground(UIDef.CHANGED_FOREGROUND);
                        resLabel.setBackground(UIDef.CHANGED_BACKGROUND);
                    } else if (row == this.ivAktSel) {
                        resLabel.setBackground(UIDef.SELECTED_BACKGROUND);
                    } else {
                        resLabel.setBackground(ENABLED_COLOR);
                    }
                    resLabel.setOpaque(true);
                }
                if (cs.getStatus() == -2) {
                    resLabel.setHorizontalAlignment(0);
                    resLabel.setFont(FontManager.getFont(NOTSET_FONT_TAG));
                    resLabel.setText(" - " + Babel.get("MULTIPLE") + " - ");
                } else if (cs.getStatus() == -1) {
                    resLabel.setHorizontalAlignment(0);
                    resLabel.setFont(FontManager.getFont(NOTSET_FONT_TAG));
                    resLabel.setText(" - " + Babel.get("NOTSET") + " - ");
                } else if (cs.getStatus() == -4) {
                    resLabel.setHorizontalAlignment(0);
                    resLabel.setFont(FontManager.getFont(NOTSET_FONT_TAG));
                    resLabel.setText(" - " + Babel.get("IRRELEVANT") + " - ");
                }
            }
        }
        return resLabel;
    }
}

