/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.InspectorAction;
import mausoleum.inspector.actions.cage.CageAction;
import mausoleum.inspector.actions.experiment.ExperimentAction;
import mausoleum.inspector.actions.license.LicenseAction;
import mausoleum.inspector.actions.line.LineAction;
import mausoleum.inspector.actions.locus.LocusAction;
import mausoleum.inspector.actions.mail.MailAction;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.actions.mousecohorts.CohortAction;
import mausoleum.inspector.actions.rack.RackAction;
import mausoleum.inspector.actions.room.RoomAction;
import mausoleum.inspector.actions.task.TaskAction;
import mausoleum.inspector.actions.user.UserAction;
import mausoleum.inspector.actions.usergroup.UsergroupAction;

public abstract class IAManager {
    private static final HashMap ACTIONS_BY_COMMAND = new HashMap(60);
    private static final HashMap AFTERBURNERS_BY_COMMAND = new HashMap(60);
    private static final HashMap ACTIONS_BY_IDO_CLASS = new HashMap();
    static /* synthetic */ Class class$0;

    public static void exit() {
        ACTIONS_BY_COMMAND.clear();
        AFTERBURNERS_BY_COMMAND.clear();
        ACTIONS_BY_IDO_CLASS.clear();
    }

    public static void init() {
        MouseAction.init();
        CageAction.init();
        ExperimentAction.init();
        LicenseAction.init();
        LineAction.init();
        LocusAction.init();
        MailAction.init();
        CohortAction.init();
        RackAction.init();
        RoomAction.init();
        UserAction.init();
        UsergroupAction.init();
        TaskAction.init();
    }

    public static InspectorAction getAction(String command) {
        return (InspectorAction)ACTIONS_BY_COMMAND.get(command);
    }

    public static Vector getActions(Class idoclass) {
        if (idoclass != null) {
            return (Vector)ACTIONS_BY_IDO_CLASS.get(idoclass);
        }
        return null;
    }

    public static void register(String command, InspectorAction ia) {
        if (ACTIONS_BY_COMMAND.containsKey(command)) {
            String string = "Duplicate Command: " + command;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(command);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.inspector.actions.IAManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, illegalArgumentException, clazz);
        } else {
            ACTIONS_BY_COMMAND.put(command, ia);
            Vector<InspectorAction> v = (Vector<InspectorAction>)ACTIONS_BY_IDO_CLASS.get(ia.getObjectClass());
            if (v == null) {
                v = new Vector<InspectorAction>();
                ACTIONS_BY_IDO_CLASS.put(ia.getObjectClass(), v);
            }
            v.add(ia);
        }
    }

    public static void registerAfterBurnerForCommand(String command, ActionListener al) {
        AFTERBURNERS_BY_COMMAND.put(command, al);
    }

    public static boolean knownCommand(String command) {
        return ACTIONS_BY_COMMAND.containsKey(command);
    }

    public static void perform(String command, Vector idObjects, String commonGroup, boolean touchable) {
        block12: {
            Inspector.getInspector().setCursor(Cursor.getPredefinedCursor(3));
            try {
                InspectorAction ia = (InspectorAction)ACTIONS_BY_COMMAND.get(command);
                if (ia != null) {
                    boolean res = ia.checkAction(idObjects, true, commonGroup, touchable);
                    if (res) {
                        ActionListener al = (ActionListener)AFTERBURNERS_BY_COMMAND.get(command);
                        if (al != null) {
                            al.actionPerformed(new ActionEvent(ia, 0, command));
                        }
                    } else {
                        Alert.showAlert(Babel.get("ALERTREQUESTFAILED"), true);
                    }
                    break block12;
                }
                String string = "No action for command: " + command;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(command);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.inspector.actions.IAManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, illegalArgumentException, clazz);
            }
            catch (Throwable e) {
                String string = "Error while executing: " + command;
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(command);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.inspector.actions.IAManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, illegalArgumentException, clazz);
            }
        }
        Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
    }

    public static boolean isActive(String command, Vector idObjects, String commonGroup, boolean touchable) {
        boolean res = false;
        InspectorAction ia = (InspectorAction)ACTIONS_BY_COMMAND.get(command);
        if (ia != null) {
            res = ia.checkAction(idObjects, false, commonGroup, touchable);
        } else {
            String string = "No action for command: " + command;
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(command);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.inspector.actions.IAManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, illegalArgumentException, clazz);
        }
        return res;
    }
}

