/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.cage;

import de.hannse.netobjects.util.ArrayHelper;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.actions.InspectorAction;
import mausoleum.inspector.actions.cage.CACommentAdd;
import mausoleum.inspector.actions.cage.CACreateContig;
import mausoleum.inspector.actions.cage.CAGroupTransfer;
import mausoleum.inspector.actions.cage.CAMoveToOrcus;
import mausoleum.inspector.actions.cage.CAPrintLabel;
import mausoleum.inspector.actions.cage.CAShowAllMice;
import mausoleum.inspector.actions.cage.CAShowPos;
import mausoleum.inspector.actions.cage.CAShowTasks;
import mausoleum.inspector.actions.cage.CAShowWeanings;
import mausoleum.inspector.actions.cage.CATransfer;
import mausoleum.main.MausoleumClient;
import mausoleum.util.InstallationType;

public abstract class CageAction
implements InspectorAction {
    public static final String COM_SHOW_POS = "CA_SHOWPOS";
    public static final String COM_PRINT_LABEL = "CA_PRINTLABEL";
    public static final String COM_SHOW_TASKS = "CA_SHOW_TASKS";
    public static final String COM_MOVE_TO_ORCUS = "CA_MOVETOORCUS";
    public static final String COM_SHOWALLMICE = "CA_SHOWALLMICE";
    public static final String COM_SHOW_WEANINGS = "CA_WEANINGS";
    public static final String COM_CREATE_CONTIG = "CA_CONTIG";
    public static final String COM_ADD_COMMENT = "CA_ADD_COMMENT";
    public static final String COM_TRANSFER = "CA_TRANSFER_TO_ROOM";
    public static final String COM_GROUP_TRANSFER = "CA_GROUP_TRANSFER";
    private static final String[] ACTION_BUTT_DEFS = new String[]{"CA_SHOWPOS", "CA_PRINTLABEL", "CA_CONTIG", "CA_WEANINGS", "CA_MOVETOORCUS", "CA_SHOWALLMICE", "CA_SHOW_TASKS", "CA_ADD_COMMENT"};
    private static final String[] ACTION_BUTT_DEFS_FISH = new String[]{"CA_SHOWPOS", "CA_PRINTLABEL", "CA_CONTIG", "CA_MOVETOORCUS", "CA_SHOWALLMICE", "CA_SHOW_TASKS", "CA_ADD_COMMENT"};
    private static final String[] ACTION_BUTT_DEFS_SERVICE_CT = new String[]{"CA_SHOWPOS", "CA_PRINTLABEL", "CA_WEANINGS", "CA_MOVETOORCUS", "CA_TRANSFER_TO_ROOM", "CA_GROUP_TRANSFER", "CA_SHOWALLMICE", "CA_SHOW_TASKS", "CA_ADD_COMMENT"};
    private static final String[] ACTION_BUTT_DEFS_SERVICE_CT_FISH = new String[]{"CA_SHOWPOS", "CA_PRINTLABEL", "CA_MOVETOORCUS", "CA_TRANSFER_TO_ROOM", "CA_GROUP_TRANSFER", "CA_SHOWALLMICE", "CA_SHOW_TASKS", "CA_ADD_COMMENT"};
    static /* synthetic */ Class class$0;

    public static void init() {
        String[] actions = CageAction.getCageActions();
        CageAction.addActionIfLallowed(COM_SHOW_POS, new CAShowPos(), actions);
        CageAction.addActionIfLallowed(COM_PRINT_LABEL, new CAPrintLabel(), actions);
        CageAction.addActionIfLallowed(COM_SHOW_TASKS, new CAShowTasks(), actions);
        CageAction.addActionIfLallowed(COM_MOVE_TO_ORCUS, new CAMoveToOrcus(), actions);
        CageAction.addActionIfLallowed(COM_SHOWALLMICE, new CAShowAllMice(), actions);
        CageAction.addActionIfLallowed(COM_SHOW_WEANINGS, new CAShowWeanings(), actions);
        CageAction.addActionIfLallowed(COM_CREATE_CONTIG, new CACreateContig(), actions);
        CageAction.addActionIfLallowed(COM_ADD_COMMENT, new CACommentAdd(), actions);
        CageAction.addActionIfLallowed(COM_TRANSFER, new CATransfer(), actions);
        CageAction.addActionIfLallowed(COM_GROUP_TRANSFER, new CAGroupTransfer(), actions);
    }

    private static void addActionIfLallowed(String action, InspectorAction ia, String[] allowedActions) {
        if (ArrayHelper.findStringInArray(action, allowedActions) != -1) {
            IAManager.register(action, ia);
        }
    }

    public static String[] getCageActions() {
        String[] actions = null;
        actions = MausoleumClient.isServiceCaretaker() ? (InstallationType.isMouse() ? ACTION_BUTT_DEFS_SERVICE_CT : ACTION_BUTT_DEFS_SERVICE_CT_FISH) : (InstallationType.isMouse() ? ACTION_BUTT_DEFS : ACTION_BUTT_DEFS_FISH);
        return actions;
    }

    public boolean availableForInspectorTables() {
        return true;
    }

    public boolean availableForPopup() {
        return true;
    }

    public String getTooltipBabel() {
        return null;
    }

    public Class getObjectClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.cage.Cage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Vector getMatchingMice(Vector cages) {
        Vector erg = new Vector();
        Iterator iter = cages.iterator();
        while (iter.hasNext()) {
            Cage c = (Cage)iter.next();
            c.addActualMice(erg);
        }
        return erg;
    }
}

