/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.documents;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.helper.FileHelper;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.documents.DocuButton;
import mausoleum.inspector.util.InspectorCommandSender;

public class AddDocuButton
extends DocuButton {
    private static final long serialVersionUID = 132334L;

    public static boolean addDocu(HashMap obsByGroup) {
        if (obsByGroup != null) {
            File file = FileHelper.selectFile(Inspector.getInspector(), Babel.get("SELECT_DOCUMENT"), false, null, null);
            if (file != null) {
                return AddDocuButton.addOneFile(file, obsByGroup);
            }
            Alert.showAlert(Babel.get("ALERT_DOC_NO_FILE_FOUND"), true);
        }
        return false;
    }

    private static boolean addOneFile(File file, HashMap obsByGroup) {
        byte[] data = FileManager.getBytesFromFile(file.getAbsolutePath());
        if (data != null) {
            Iterator iter = obsByGroup.keySet().iterator();
            while (iter.hasNext()) {
                String group = (String)iter.next();
                Vector obs = (Vector)obsByGroup.get(group);
                int otype = -1;
                StringBuffer oids = new StringBuffer();
                Iterator iterator = obs.iterator();
                while (iterator.hasNext()) {
                    Object ooo = iterator.next();
                    if (ooo instanceof IDObject) {
                        IDObject ido = (IDObject)ooo;
                        if (otype == -1) {
                            otype = ido.getTyp(-1);
                        } else {
                            oids.append("|");
                        }
                        oids.append(ido.getID());
                        continue;
                    }
                    if (!(ooo instanceof long[])) continue;
                    long[] arr = (long[])ooo;
                    if (otype == -1) {
                        otype = (int)arr[0];
                    } else {
                        oids.append("|");
                    }
                    oids.append(arr[1]);
                }
                StringBuffer msb = new StringBuffer();
                msb.append("ALLG_ADD_DOC").append(" ");
                msb.append(oids.toString()).append(" ");
                msb.append(otype).append(" ");
                msb.append(Base64Manager.encodeBase64(file.getName())).append(" ");
                msb.append(file.lastModified());
                boolean sres = InspectorCommandSender.executeCommand(msb.toString(), data, group);
                if (!sres) {
                    Alert.showAlert(Babel.get("ALERT_DOC_UPLOAD_CRASHED"), true);
                    continue;
                }
                return true;
            }
        } else {
            Alert.showAlert(Babel.get("ALERT_DOC_NO_FILE_FOUND"), true);
        }
        return false;
    }

    public AddDocuButton(String privilege) {
        super(Babel.get("IP_ADD_DOCU"), privilege);
    }

    public boolean checkAction(Vector idObjects, boolean withExecution) {
        boolean res = false;
        if (this.privCheck(idObjects)) {
            res = true;
            if (withExecution) {
                AddDocuButton.addDocu(IDObject.sortByGroup(idObjects));
            }
        }
        return res;
    }

    public boolean addMultipleDocs(Vector idObjects, Vector files) {
        boolean res = false;
        if (this.privCheck(idObjects)) {
            res = true;
            HashMap obsByGroup = IDObject.sortByGroup(idObjects);
            Iterator iterator = files.iterator();
            while (iterator.hasNext() && res) {
                File file = (File)iterator.next();
                res = AddDocuButton.addOneFile(file, obsByGroup);
            }
        }
        return res;
    }

    public boolean privCheck(Vector idObjects) {
        return Privileges.hasPrivilege(this.ivPrivilege) && idObjects != null && idObjects.size() == 1 && IDObject.nonEmptyAndAllActiveAndChangeable(idObjects);
    }
}

