/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.line;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import mausoleum.gui.MGButton;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.helper.ImageProvider;
import mausoleum.helper.MausoleumImageStore;
import mausoleum.helper.WindowUtils;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.Stress;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.ui.UIDef;
import mausoleum.util.SortablePoint;

public class KnubbelSelector
extends JComponent {
    private static final long serialVersionUID = 118561561L;
    private static final int ROW_HEIGHT = UIDef.getScaled(20);
    private static final int MAX_HEIGHT = UIDef.getScaled(800);
    private static final int MAX_WIDTH = UIDef.getScaled(900);
    private static final Image BULLET = ImageProvider.getBulletIcon(Color.green).getImage();
    private static final Image GRAY_BULLET = ImageProvider.getBulletIcon(Color.gray).getImage();
    private static final int IC_WIDTH = BULLET.getWidth(null);
    private static final int IC_HEIGHT = BULLET.getHeight(null);
    private final String ivTitel;
    private final Vector ivRowNames;
    private final Vector ivColNames;
    private final Dimension ivPrefSize = new Dimension();
    private final Vector ivSelPoints;
    private int ivRowheaderWidth;
    private int ivColheaderWidth;

    public static HashMap getStressLevelsForMice(Vector mice, int exitModus, boolean alsoDefineds, boolean alsoWantNotDefined, boolean useAllMice, HashMap target, boolean forLife) {
        HashMap stressByMouse = target != null ? target : new HashMap();
        stressByMouse.clear();
        if (TierSchutz.belastungNeeded() && (exitModus == -1 || TierSchutz.isInputPflichtigerTodesModus(exitModus))) {
            Vector belastungsMaeuse;
            Vector vector = belastungsMaeuse = useAllMice ? mice : TierSchutz.getMiceWithStressInputNeeded(mice, null);
            if (belastungsMaeuse != null && !belastungsMaeuse.isEmpty()) {
                int[] stresslevels = KnubbelSelector.getBelastungen(belastungsMaeuse, !forLife);
                if (stresslevels != null) {
                    int row = 0;
                    while (row < stresslevels.length) {
                        if (stresslevels[row] != 0 || alsoWantNotDefined) {
                            int prevLevel;
                            Mouse mouse = (Mouse)belastungsMaeuse.elementAt(row);
                            int n = prevLevel = forLife ? mouse.getMouseLifeStressLevel() : mouse.getMouseDeathStressLevel();
                            if (prevLevel != stresslevels[row]) {
                                stressByMouse.put(mouse, new Integer(stresslevels[row]));
                            }
                        }
                        ++row;
                    }
                } else {
                    return null;
                }
            }
        }
        return stressByMouse;
    }

    private static int[] getBelastungen(Vector mice, boolean imTod) {
        Vector<String> rowNames = new Vector<String>(mice.size());
        Vector<SortablePoint> selPoints = new Vector<SortablePoint>(mice.size());
        Iterator iterator = mice.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            rowNames.add(mouse.getIDStringForReports(false));
            int stressLevel = imTod ? mouse.getMouseDeathStressLevel() : mouse.getMouseLifeStressLevel();
            int x = ArrayHelper.findIndexInArray(stressLevel, Stress.STRESS_INTS);
            selPoints.add(new SortablePoint(x, selPoints.size()));
        }
        Vector<String> colNames = new Vector<String>(Stress.STRESS_BABELS.length);
        int i = 0;
        while (i < Stress.STRESS_BABELS.length) {
            colNames.add(Babel.get(Stress.STRESS_BABELS[i]));
            ++i;
        }
        KnubbelSelector sls = new KnubbelSelector("STRESS_LEVEL", colNames, rowNames, selPoints);
        KnubbelSelectorDialog sld = new KnubbelSelectorDialog(sls, "ENTER_STRESS_LEVELS");
        if (sld.ivWarOK) {
            int[] res = new int[mice.size()];
            int i2 = 0;
            while (i2 < res.length) {
                int col = sls.getSelectedCol(i2, -1);
                res[i2] = col == -1 ? 0 : Stress.STRESS_INTS[col];
                ++i2;
            }
            return res;
        }
        return null;
    }

    public KnubbelSelector(String titelBabel, Vector colNames, Vector rowNames, Vector selPoints) {
        this.setFont(FontManager.getTableFont(true, true, 1.0));
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.ivTitel = " " + Babel.get(titelBabel) + " ";
        this.ivRowNames = rowNames;
        this.ivSelPoints = selPoints;
        this.ivColNames = colNames;
        this.ivColheaderWidth = this.getMaxWidth(this.ivColNames, fm);
        this.ivRowheaderWidth = this.getMaxWidth(this.ivRowNames, fm);
        this.ivPrefSize.width = this.ivRowheaderWidth + this.ivColNames.size() * this.ivColheaderWidth + 2 * UIDef.RAND;
        this.ivPrefSize.height = (this.ivRowNames.size() + 1) * ROW_HEIGHT + 2 * UIDef.RAND;
        SortablePoint sp = new SortablePoint();
        sp.y = 0;
        while (sp.y < this.ivRowNames.size()) {
            boolean found = false;
            sp.x = 0;
            while (sp.x < this.ivColNames.size() && !found) {
                if (this.ivSelPoints.contains(sp)) {
                    found = true;
                }
                sp.x = sp.x + 1;
            }
            if (!found) {
                this.addSelection(new SortablePoint(0, sp.y));
            }
            sp.y = sp.y + 1;
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent arg0) {
                KnubbelSelector.this.handleClick(arg0.getPoint());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                KnubbelSelector.this.handleClick(e.getPoint());
            }
        });
    }

    private int getMaxWidth(Vector v, FontMetrics fm) {
        int sw = fm.stringWidth(" ");
        int res = fm.stringWidth(this.ivTitel);
        int i = 0;
        while (i < v.size()) {
            int w;
            String s = (String)v.elementAt(i);
            if (s.length() == 0) {
                s = Babel.get("STANDARD");
            }
            if ((w = fm.stringWidth(s) + 2 * sw) > res) {
                res = w;
            }
            ++i;
        }
        return res;
    }

    public Dimension getPreferredSize() {
        return this.ivPrefSize;
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int ascent = fm.getAscent() + 2;
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        int x = UIDef.RAND;
        int y = UIDef.RAND;
        int innerWidth = this.ivPrefSize.width - 2 * UIDef.RAND;
        int innerHeight = this.ivPrefSize.height - 2 * UIDef.RAND;
        if (this.ivRowNames.size() > 1) {
            int row = 1;
            while (row < this.ivRowNames.size()) {
                g.setColor(UIDef.GERADE_ROW_COL);
                g.fillRect(x, y + ROW_HEIGHT + row * ROW_HEIGHT, innerWidth, ROW_HEIGHT);
                row += 2;
            }
        }
        SortablePoint pp = new SortablePoint();
        g.setColor(Color.black);
        g.drawLine(x + this.ivRowheaderWidth, y, x + innerWidth, y);
        g.drawString(this.ivTitel, x, y + ascent);
        int row = -1;
        while (row < this.ivRowNames.size()) {
            int col;
            x = UIDef.RAND;
            if (row != -1) {
                String s = (String)this.ivRowNames.elementAt(row);
                if (s.length() == 0) {
                    s = Babel.get("STANDARD");
                }
                s = " " + s + " ";
                g.drawString(s, x, y + ascent);
            } else {
                g.drawLine(x, y + ROW_HEIGHT, x, y + innerHeight);
                x += this.ivRowheaderWidth;
                col = 0;
                while (col < this.ivColNames.size()) {
                    g.drawLine(x, y, x, y + innerHeight);
                    x += this.ivColheaderWidth;
                    ++col;
                }
                g.drawLine(x, y, x, y + innerHeight);
                x = UIDef.RAND;
                x += this.ivRowheaderWidth;
            }
            x = UIDef.RAND;
            x += this.ivRowheaderWidth;
            col = 0;
            while (col < this.ivColNames.size()) {
                if (row == -1) {
                    String s = (String)this.ivColNames.elementAt(col);
                    if (s.length() == 0) {
                        s = Babel.get("STANDARD");
                    }
                    s = " " + s + " ";
                    int xoff = (this.ivColheaderWidth - fm.stringWidth(s)) / 2;
                    g.drawString(s, x + xoff, y + ascent);
                } else {
                    pp.x = col;
                    pp.y = row;
                    if (this.ivSelPoints.contains(pp)) {
                        int xoff = (this.ivColheaderWidth - IC_WIDTH) / 2;
                        int yoff = (ROW_HEIGHT - IC_HEIGHT) / 2;
                        g.drawImage(col == 0 ? GRAY_BULLET : BULLET, x + xoff, y + yoff, null);
                    }
                }
                x += this.ivColheaderWidth;
                ++col;
            }
            x = UIDef.RAND;
            g.drawLine(x, y += ROW_HEIGHT, x + innerWidth, y);
            ++row;
        }
    }

    private void handleClick(Point p) {
        SortablePoint dataPoint = this.calcDataPoint(p);
        if (dataPoint != null && !this.ivSelPoints.contains(dataPoint)) {
            SortablePoint tp = new SortablePoint();
            tp.y = dataPoint.y;
            tp.x = 0;
            while (tp.x < this.ivColNames.size()) {
                this.ivSelPoints.removeElement(tp);
                tp.x = tp.x + 1;
            }
            this.addSelection(dataPoint);
            this.repaint();
        }
    }

    private void addSelection(SortablePoint sp) {
        this.ivSelPoints.add(sp);
    }

    public int getSelectedCol(int row, int defVal) {
        Iterator iterator = this.ivSelPoints.iterator();
        while (iterator.hasNext()) {
            SortablePoint sp = (SortablePoint)iterator.next();
            if (sp.y != row) continue;
            return sp.x;
        }
        return defVal;
    }

    private SortablePoint calcDataPoint(Point p) {
        if (p.x > UIDef.RAND + this.ivRowheaderWidth && p.y > UIDef.RAND + ROW_HEIGHT) {
            int x = (p.x - UIDef.RAND - this.ivRowheaderWidth) / this.ivColheaderWidth;
            int y = (p.y - UIDef.RAND - ROW_HEIGHT) / ROW_HEIGHT;
            if (x >= 0 && x < this.ivColNames.size() && y >= 0 && y < this.ivRowNames.size()) {
                return new SortablePoint(x, y);
            }
        }
        return null;
    }

    public static class KnubbelSelectorDialog
    extends JDialog {
        private static final long serialVersionUID = 12323421L;
        private final MGButton ivOkButton = MGButton.getRequesterButton(Babel.get("YES"));
        private final MGButton ivNoButton = MGButton.getRequesterButton(Babel.get("NO"));
        private final JScrollPane ivScrollpane;
        public boolean ivWarOK = false;

        public KnubbelSelectorDialog(KnubbelSelector sls, String dialogTitleBabel) {
            this.setModal(true);
            this.setTitle(Babel.get(dialogTitleBabel));
            this.setIconImage(MausoleumImageStore.getLogo());
            this.getContentPane().setLayout(new SimpleLayoutManager(this){
                final /* synthetic */ KnubbelSelectorDialog this$1;
                {
                    this.this$1 = knubbelSelectorDialog;
                }

                public void layoutContainer(Container parent) {
                    Dimension d = parent.getSize();
                    int oh = d.height - UIDef.BUT_HEIGHT;
                    KnubbelSelectorDialog.access$0(this.this$1).setBounds(0, 0, d.width, oh);
                    int lbw = d.width / 2;
                    int rbw = d.width - lbw;
                    KnubbelSelectorDialog.access$1(this.this$1).setBounds(0, oh, lbw, UIDef.BUT_HEIGHT);
                    KnubbelSelectorDialog.access$2(this.this$1).setBounds(lbw, oh, rbw, UIDef.BUT_HEIGHT);
                }
            });
            this.ivOkButton.addActionListener(new ActionListener(this){
                final /* synthetic */ KnubbelSelectorDialog this$1;
                {
                    this.this$1 = knubbelSelectorDialog;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.ivWarOK = true;
                    this.this$1.setVisible(false);
                }
            });
            this.getContentPane().add(this.ivOkButton);
            this.ivNoButton.addActionListener(new ActionListener(this){
                final /* synthetic */ KnubbelSelectorDialog this$1;
                {
                    this.this$1 = knubbelSelectorDialog;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.ivWarOK = false;
                    this.this$1.setVisible(false);
                }
            });
            this.getContentPane().add(this.ivNoButton);
            this.ivScrollpane = new JScrollPane(sls);
            this.getContentPane().add(this.ivScrollpane);
            int breite = this.ivScrollpane.getPreferredSize().width;
            breite = breite > MAX_WIDTH ? MAX_WIDTH : breite;
            int hoehe = this.ivScrollpane.getPreferredSize().height + UIDef.BUT_HEIGHT;
            hoehe = hoehe > MAX_HEIGHT ? MAX_HEIGHT : hoehe;
            WindowUtils.bringUpCenteredDialog(this, breite, hoehe, true);
        }

        static /* synthetic */ JScrollPane access$0(KnubbelSelectorDialog knubbelSelectorDialog) {
            return knubbelSelectorDialog.ivScrollpane;
        }

        static /* synthetic */ MGButton access$1(KnubbelSelectorDialog knubbelSelectorDialog) {
            return knubbelSelectorDialog.ivOkButton;
        }

        static /* synthetic */ MGButton access$2(KnubbelSelectorDialog knubbelSelectorDialog) {
            return knubbelSelectorDialog.ivNoButton;
        }
    }
}

