/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.line;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.line.LineAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.line.Line;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.AddAllelRequester;
import mausoleum.requester.pope.PopeAlert;

public class LAAllelsRemove
extends LineAction {
    public String getBabel() {
        return "REMOVEALLEL";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        Hashtable removableAlleles;
        Line line;
        boolean res = false;
        if (idObjects != null && idObjects.size() == 1 && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("LIN_REMOVE_ALLELES") && (line = LAAllelsRemove.getAliveSelectedLine(idObjects, false)) != null && line.mayAttributeBeChangedByCommand() && (removableAlleles = line.getRemovableAlleles()) != null) {
            if (withExecution) {
                AddAllelRequester aar = new AddAllelRequester((Frame)Inspector.getInspector(), Babel.get("REMOVEALLEL"), removableAlleles);
                aar.setVisible(true);
                if (aar.ivWarOK) {
                    long locusID = aar.getLocusID();
                    String allel = aar.getAllel();
                    if (locusID != -1L && allel != null && PopeAlert.getAnswer(PopeAlert.getPopeMeldung("POPE_LINE_REMOVE_ALELLES_MIT_PETZE"))) {
                        StringBuffer msb = new StringBuffer();
                        msb.append("LINREMOVEALLEL").append(" ");
                        msb.append(Long.toString(line.getID())).append(" ");
                        msb.append(Long.toString(locusID)).append(" ");
                        msb.append(Base64Manager.encodeBase64(allel));
                        InspectorCommandSender.executeCommand(msb.toString(), line.getGroup());
                        String text = "<html><body>User <b>" + UserManager.getNameOfUser() + "</b> removed allel " + allel + " from line " + line.getLink() + "!</body></html>";
                        PopeAlert.petze("Allel removed from line " + line.getName(), text, line.getGroup(), "PETZ_ALLELES_REMOVED");
                    }
                }
            }
            res = true;
        }
        return res;
    }
}

