/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.line;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.line.LineAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.line.Line;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.MausoleumClient;
import mausoleum.requester.SetOrderRequester;

public class LAOrderLoci
extends LineAction {
    public String getBabel() {
        return "ORDERLOCI";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        LocusAndAlleles[] arr;
        Line line;
        boolean res = false;
        if (idObjects != null && idObjects.size() == 1 && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) && Privileges.hasPrivilege("ORDER_LOCI") && (line = LAOrderLoci.getAliveSelectedLine(idObjects, false)) != null && line.mayAttributeBeChangedByCommand() && (arr = (LocusAndAlleles[])line.get("LIN_LOCIALLELES")) != null && arr.length >= 2) {
            if (withExecution) {
                try {
                    Object[] arr2 = new String[arr.length];
                    int i = 0;
                    while (i < arr.length) {
                        arr2[i] = arr[i].toGenotypeString(line.getGroup());
                        ++i;
                    }
                    int[] newOrder = SetOrderRequester.getNewOrder(Inspector.getInspector(), arr2, line.getBrowseName(), Babel.get("ORDERLOCI"));
                    if (newOrder != null) {
                        StringBuffer isb = new StringBuffer();
                        int i2 = 0;
                        while (i2 < newOrder.length) {
                            if (i2 != 0) {
                                isb.append(",");
                            }
                            isb.append(newOrder[i2]);
                            ++i2;
                        }
                        StringBuffer msb = new StringBuffer();
                        msb.append("LINCHLOCORDER").append(" ");
                        msb.append(Long.toString(line.getID())).append(" ");
                        msb.append(Base64Manager.encodeBase64(isb.toString()));
                        InspectorCommandSender.executeCommand(msb.toString(), line.getGroup());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            res = true;
        }
        return res;
    }
}

