/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.locus;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import java.util.Vector;
import mausoleum.helper.BrowserLauncher;
import mausoleum.inspector.actions.locus.LocusAction;
import mausoleum.locus.Locus;
import mausoleum.util.InstallationType;

public class LOAWeb
extends LocusAction {
    private static String DEFAULTENSEMLADDRESS = InstallationType.isFish() ? "http://www.ensembl.org/Danio_rerio/geneview?gene=_ID_" : "http://www.ensembl.org/Mus_musculus/geneview?gene=_ID_";
    private static String DEFAULTMGIADDRESS = InstallationType.isFish() ? "http://zfin.org/action/marker/view/ZDB-GENE-_ID_" : "http://www.informatics.jax.org/javawi2/servlet/WIFetch?page=searchTool&query=MGI%3A_ID_&selectedQuery=Genes+and+Markers";
    private static final String ENSEMBL_ADDRESS = FileManager.getStringContentFromServer(InstallationType.isFish() ? "data/ensemblFish.txt" : "data/ensembl.txt");
    private static final String MGI_ADDRESS = FileManager.getStringContentFromServer(InstallationType.isFish() ? "data/mgiFish.txt" : "data/mgi.txt");
    private final boolean ivIsEnsembl;

    public LOAWeb(boolean isEnsembl) {
        this.ivIsEnsembl = isEnsembl;
    }

    public String getBabel() {
        return this.ivIsEnsembl ? "SHOWENSEMBL" : "SHOWMGI";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        String locusID = LOAWeb.getLocusString(idObjects, this.ivIsEnsembl ? "LOC_ENSEMBL_NAME" : "LOC_MGI_NAME");
        if (locusID != null) {
            res = true;
            if (withExecution) {
                LOAWeb.openUrl(this.ivIsEnsembl, locusID);
            }
        }
        return res;
    }

    public static void openUrl(boolean isEnsembl, String locusID) {
        LOAWeb.openURL(isEnsembl ? ENSEMBL_ADDRESS : MGI_ADDRESS, isEnsembl ? DEFAULTMGIADDRESS : DEFAULTENSEMLADDRESS, locusID);
    }

    private static void openURL(String definedAddress, String defaultAddress, String id) {
        if (id != null) {
            String address = definedAddress;
            if (address == null) {
                address = defaultAddress;
            }
            if (address != null) {
                address = StringHelper.gSub(address.trim(), "_ID_", id);
                try {
                    BrowserLauncher.openURL(address);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static String getLocusString(Vector loci, String key) {
        String res;
        Locus locus = LOAWeb.getAliveSelectedLocus(loci);
        if (locus != null && (res = locus.getString(key)) != null && (res = res.trim()).length() != 0) {
            return res;
        }
        return null;
    }
}

