/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.Cursor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.genealogy.GenealogyFrame;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.MouseManager;
import mausoleum.requester.AllgChoiceRequester;

public class MAGenealogy
extends MouseAction {
    private static final String[] GEN_CHOICES = new String[]{" \u221e ", " 1 ", " 2 ", " 3 ", " 4 ", " 5 ", " 6 ", " 7 ", " 8 ", " 9 "};
    private static final int GEN_INFINITY = Integer.MAX_VALUE;
    private static final int[] GEN_RUNDEN = new int[]{Integer.MAX_VALUE, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private final boolean ivAncestors;
    static /* synthetic */ Class class$0;

    public MAGenealogy(boolean lookForAncestors) {
        this.ivAncestors = lookForAncestors;
    }

    public String getBabel() {
        return this.ivAncestors ? "ANCESTORS" : "PROGENIES";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        if (withExecution) {
            MAGenealogy.buildGenealogy(this.ivAncestors, idObjects);
            return true;
        }
        return MAGenealogy.genealogyPossible(this.ivAncestors, idObjects);
    }

    public static boolean genealogyPossible(boolean lookForAncestors, Vector selObjects) {
        if (!selObjects.isEmpty()) {
            Iterator iter = selObjects.iterator();
            while (iter.hasNext()) {
                Mouse mouse = (Mouse)iter.next();
                if (mouse == null || !(lookForAncestors ? mouse.getLong("MOS_FATHER") != 0L || mouse.getLong("MOS_MOTHER") != 0L : mouse.get("MOS_KID") != null)) continue;
                return true;
            }
        }
        return false;
    }

    public static void buildGenealogy(boolean lookForAncestors, Vector selObjects) {
        int generationen;
        if (!selObjects.isEmpty() && (generationen = AllgChoiceRequester.getIntAnswer(Inspector.getInspector(), Babel.get("SPECIFY_NUMBER_GENERATIONS"), GEN_CHOICES, GEN_RUNDEN, -1, 3)) != -1) {
            Inspector.getInspector().setCursor(Cursor.getPredefinedCursor(3));
            try {
                Vector v = new Vector(selObjects.size());
                v.addAll(selObjects);
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    Mouse mouse = (Mouse)iter.next();
                    HashMap hm = MouseManager.prepareGenealogy(mouse, lookForAncestors, generationen);
                    MAGenealogy.purifyRelations(hm);
                    String title = Babel.get(lookForAncestors ? "ANCESTORSOFMOUSE" : "PROGENIESOFMOUSE");
                    title = String.valueOf(title) + " " + mouse.getIDStringForReports(false);
                    if (generationen != Integer.MAX_VALUE) {
                        title = String.valueOf(title) + " [" + generationen + " " + Babel.get(generationen == 1 ? "GENERATION" : "GENERATIONS") + "]";
                    }
                    GenealogyFrame.showGenealogy(mouse.getID(), hm, title, mouse.getGroup());
                }
            }
            catch (Exception exxs) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.inspector.actions.mouse.MAGenealogy");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem showing Genealogy", exxs, clazz);
            }
            Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
        }
    }

    private static void purifyRelations(HashMap hm) {
        Long key;
        Vector<Long> toDelete = new Vector<Long>();
        HashMap<Long, long[]> toChange = new HashMap<Long, long[]>();
        Iterator<Object> iterator = hm.keySet().iterator();
        while (iterator.hasNext()) {
            key = (Long)iterator.next();
            long[] arr = (long[])hm.get(key);
            long[] nzArr = ArrayHelper.withoutZeros(arr);
            if (nzArr == null) {
                toDelete.add(key);
                continue;
            }
            if (nzArr == arr) continue;
            toChange.put(key, nzArr);
        }
        if (!toDelete.isEmpty()) {
            iterator = toDelete.iterator();
            while (iterator.hasNext()) {
                key = (Long)iterator.next();
                hm.remove(key);
            }
        }
        if (!toChange.isEmpty()) {
            iterator = toChange.keySet().iterator();
            while (iterator.hasNext()) {
                key = (Long)iterator.next();
                hm.put(key, toChange.get(key));
            }
        }
        toDelete.clear();
        toDelete = null;
        toChange.clear();
        toChange = null;
    }
}

