/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mausoleum.alert.Alert;
import mausoleum.dataimport.DataImporter;
import mausoleum.helper.FileHelper;
import mausoleum.helper.FontManager;
import mausoleum.helper.MFF;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.line.LineManager;
import mausoleum.main.MausoleumClient;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.requester.MoreTextRequester;
import mausoleum.requester.mouse.ImportMiceRequester;
import mausoleum.tables.LegacyObjectsFrame;

public class MAImport
extends MouseAction {
    private static final int IMPORT_MODE_EMAIL = 1;
    private static final int IMPORT_MODE_EXCEL = 2;
    private static final String[] IMPORT_CHOICES = new String[]{Babel.get("IMPORT_MICE_FROM_EMAIL"), Babel.get("IMPORT_OBJECTS_FROM_EXCEL")};
    private static final int[] IMPORT_MODES = new int[]{1, 2};

    public String getBabel() {
        return "IMPORT";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (MausoleumClient.isRegularOrTGService() && Privileges.hasPrivilege("IMPORT_MICE")) {
            res = true;
            if (withExecution) {
                Inspector.getInspector().setCursor(Cursor.getPredefinedCursor(3));
                try {
                    int mode = 1;
                    if (Privileges.hasPrivilege("IMPORT_MICE_FROM_LEGACY")) {
                        int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("SELECT_SEARCH"), IMPORT_CHOICES);
                        Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
                        if (ind != -1) {
                            mode = IMPORT_MODES[ind];
                        }
                    } else {
                        mode = 1;
                    }
                    if (mode == 2) {
                        MAImport.importObjectsFromExcel();
                    } else if (mode == 1) {
                        MAImport.importMiceFromEmail();
                    }
                }
                catch (Exception e) {
                    Log.error("Import crashed", e, this);
                }
                Inspector.getInspector().setCursor(Cursor.getDefaultCursor());
            }
        }
        return res;
    }

    private static void importObjectsFromExcel() {
        File f = FileHelper.selectFile(Inspector.getInspector(), Babel.get("SELECT_INPUT_FILE"), false, MFF.getFilter(2), null);
        if (f != null) {
            DataImporter di = new DataImporter(f, LineManager.getBreederLine(UserManager.getFirstGroup()));
            if (di.ivSuccess) {
                String group = UserManager.getFirstGroup();
                ObjectRequest[] resultReturn = new ObjectRequest[1];
                InspectorCommandSender.executeCommand("LEGACY_IMPORT", di.ivObjectMapsByType, group, resultReturn);
                if (resultReturn[0] != null && resultReturn[0].isFinished()) {
                    LegacyObjectsFrame.showLegacyObjects((HashMap)resultReturn[0].ivObject, group);
                } else {
                    Alert.showAlert(Babel.get("DATAIMPORT_IMPOSSIBLE"), true);
                }
            } else {
                JTextArea ta = new JTextArea(di.ivBruddel.toString());
                ta.setEditable(false);
                ta.setFont(FontManager.getFont("SSP11"));
                ta.setCaretPosition(0);
                JPanel pan = new JPanel(new LayoutManager(){
                    private Component ivComp;
                    private Dimension ivDim = new Dimension(500, 400);

                    public void addLayoutComponent(String arg0, Component arg1) {
                        this.ivComp = arg1;
                    }

                    public void layoutContainer(Container arg0) {
                        Dimension d = arg0.getSize();
                        this.ivComp.setBounds(0, 0, d.width, d.height);
                    }

                    public Dimension minimumLayoutSize(Container arg0) {
                        return this.ivDim;
                    }

                    public Dimension preferredLayoutSize(Container arg0) {
                        return this.ivDim;
                    }

                    public void removeLayoutComponent(Component arg0) {
                    }
                });
                pan.add("comp", new JScrollPane(ta));
                JOptionPane.showMessageDialog(null, pan, Babel.get("DATAIMPORT_IMPOSSIBLE"), 2);
            }
        }
    }

    private static void importMiceFromEmail() {
        if (MausoleumClient.isRegularOrTGService() && Privileges.hasPrivilege("CREATE_MICE")) {
            String cont;
            Date datum;
            ImportMiceRequester imr = new ImportMiceRequester((Frame)Inspector.getInspector(), null, MyDate.getMyDate(System.currentTimeMillis()));
            imr.setVisible(true);
            if (imr.ivWarOK && (datum = imr.getDate()) != null && (cont = MoreTextRequester.getText(Inspector.getInspector(), Babel.get("PASTEIMPORTSTRING"), 600, 400, FontManager.getFont("TT14"), false, null, true)) != null) {
                int ind1 = cont.indexOf("START_OF_EXTRACT");
                int ind2 = cont.indexOf("END_OF_EXTRACT");
                if (ind1 == -1 || ind2 == -1) {
                    Alert.showAlert(Babel.get("IMPORTSTRINGMALFORMED"), true);
                    return;
                }
                cont = cont.substring(ind1 + "START_OF_EXTRACT".length(), ind2);
                cont = StringHelper.gSub(cont, "\r", "");
                cont = StringHelper.gSub(cont, "\n", "");
                StringBuffer commandBuffer = new StringBuffer();
                commandBuffer.append("MAI_IMPORT");
                commandBuffer.append(" ").append(cont);
                commandBuffer.append(" ").append(datum.getTime());
                TrafficReport.appendTrafficInfoClientSide(null, datum.getTime(), "TRD_IMPORT", commandBuffer);
                if (MausoleumClient.isServiceCaretaker()) {
                    InspectorCommandSender.executeCommandAndGetAnswer(commandBuffer.toString(), imr.getGroup());
                } else {
                    InspectorCommandSender.executeCommandAndGetAnswer(commandBuffer.toString(), UserManager.getFirstGroup());
                }
            }
        }
    }
}

