/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mausoleum.alert.Alert;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.TextWrapComponent;
import mausoleum.helper.FontManager;
import mausoleum.helper.GenotypeHelper;
import mausoleum.helper.LitterHelper;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.Requester;
import mausoleum.requester.mouse.NewMiceRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.requester.std.MausoOptionPane;
import mausoleum.result.MResult;
import mausoleum.result.SpecResDetailsTable;
import mausoleum.result.embryotransfer.EmbryoTransfer;
import mausoleum.result.embryotransfer.MResEmbryoTransfer;
import mausoleum.ui.UIDef;
import mausoleum.util.InstallationType;

public class MALitter
extends MouseAction {
    public static int getWantedAnz(NewMiceRequester newMiceReq, int limit) {
        int anz = newMiceReq.getNumber();
        if (anz == 666) {
            boolean contReally = true;
            while (contReally) {
                anz = Requester.getInt(Inspector.getInspector(), Babel.get("SPECIFY_MICE_NUMBER"), 0, false, -1, false, null);
                contReally = anz == -1 ? false : (anz == 0 || anz > limit ? Alert.showAlert(Babel.get("INVALID_VALUE_INPUT"), false) : false);
            }
        }
        return anz;
    }

    public String getBabel() {
        return "LITTER";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        return InstallationType.isMouse() ? this.checkActionMouse(idObjects, withExecution, commonGroup, touchable) : this.checkActionFish(idObjects, withExecution, commonGroup, touchable);
    }

    private boolean checkActionMouse(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        Mouse selectedMouse;
        boolean res = false;
        if (touchable && idObjects.size() == 1 && Privileges.hasPrivilege("CREATE_MICE") && (selectedMouse = (Mouse)idObjects.elementAt(0)).getSex() == 2 && selectedMouse.isPossMatingPartner() && !selectedMouse.isRoomAccesibilityRestricted()) {
            if (withExecution) {
                Mouse weibchen = selectedMouse;
                String gruppe = weibchen.getGroup();
                if (weibchen.getActCage() == null) {
                    Alert.showAlert(Babel.get("NO_LITTER_WITHOUT CAGE"), true);
                    return false;
                }
                Mouse aktWeibchen = weibchen;
                NewMiceRequester newMiceReq = new NewMiceRequester((Frame)Inspector.getInspector(), null, MyDate.getMyDate(System.currentTimeMillis()), true);
                newMiceReq.setVisible(true);
                if (newMiceReq.ivWarOK) {
                    int anz = MALitter.getWantedAnz(newMiceReq, 50);
                    Mouse father = null;
                    long fatherid = 0L;
                    long pupLineID = -1L;
                    boolean[] mussPetzen = new boolean[1];
                    if (anz > 0 && anz <= 50) {
                        Date litterDate = newMiceReq.getDate();
                        MResult embryoTransferResult = null;
                        if (EmbryoTransfer.useEmbryoTransfer() && (embryoTransferResult = EmbryoTransfer.findMatchingEmbryoTransfer(aktWeibchen, MyDate.getTage(litterDate))) != null) {
                            SpecResDetailsTable detailsTable = new SpecResDetailsTable();
                            BorderPanel panel = new BorderPanel(new JScrollPane(detailsTable), Babel.get("HR_DETAILS"));
                            String rep = (String)embryoTransferResult.ivResult;
                            if (rep != null && rep.length() != 0) {
                                MResEmbryoTransfer embTr = new MResEmbryoTransfer(rep);
                                Object[] details = embTr.getTableRepresentation(gruppe, Babel.cvUserLangue);
                                detailsTable.setDetails(details);
                            }
                            panel.setPreferredSize(UIDef.getScaledDim(600, 250));
                            TextWrapComponent twc = new TextWrapComponent(Babel.get("ETR_LITTER_QUESTION"), FontManager.getFont("SSB16"), UIDef.getScaled(600), 2);
                            twc.setPreferredSize(new Dimension(UIDef.getScaled(600), twc.getNecessaryHeight()));
                            JPanel pan = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
                            pan.add("North", twc);
                            pan.add("Center", panel);
                            pan.setOpaque(false);
                            boolean etQuestionRes = MausoOptionPane.showOptionPane(Inspector.getInspector(), pan, MausoOptionPane.MODE_OK_AND_NO);
                            if (!etQuestionRes) {
                                embryoTransferResult = null;
                            }
                        }
                        StringBuffer msb = new StringBuffer();
                        if (embryoTransferResult != null) {
                            if (TierSchutz.makeLitterProcedure(aktWeibchen, father, anz, litterDate.getTime(), embryoTransferResult)) {
                                MResEmbryoTransfer embryoTransfer = new MResEmbryoTransfer((String)embryoTransferResult.ivResult);
                                if (embryoTransfer != null) {
                                    pupLineID = embryoTransfer.ivLineID;
                                }
                                msb.append(CommandManagerExecutive.getServiceRoomTag(aktWeibchen, ""));
                                msb.append("MFULIET");
                                msb.append(" ").append(aktWeibchen.getID());
                                msb.append(" ").append(anz);
                                msb.append(" ").append(litterDate.getTime());
                                msb.append(" ").append(Base64Manager.encodeBase64((String)embryoTransferResult.ivResult));
                            }
                        } else {
                            boolean cont = true;
                            mussPetzen[0] = false;
                            father = LitterHelper.findSuitableFatherForLittering(litterDate, aktWeibchen, mussPetzen);
                            if (father == null) {
                                cont = Alert.showAlert(Babel.get("NO_FATHER_FOUND"), false);
                            } else {
                                fatherid = father.getID();
                            }
                            if (cont) {
                                cont = PopeAlert.checkForLitterWithNoProperLineForOffspring(father, aktWeibchen);
                            }
                            if (cont && TierSchutz.makeLitterProcedure(aktWeibchen, father, anz, litterDate.getTime(), null)) {
                                pupLineID = LitterHelper.determineLineIDForOffspring(aktWeibchen, father, true, 0L);
                                msb.append(CommandManagerExecutive.getServiceRoomTag(aktWeibchen, ""));
                                msb.append("MFULI");
                                msb.append(" ").append(aktWeibchen.getID());
                                msb.append(" ").append(fatherid);
                                msb.append(" ").append(anz);
                                msb.append(" ").append(litterDate.getTime());
                                msb.append(" ").append(pupLineID);
                                msb.append(" ").append(MALitter.getOwnerIDString(newMiceReq.getOwnerMode(), aktWeibchen, father, "0", "MOS_OWNER"));
                                msb.append(" ").append(MALitter.getOwnerIDString(newMiceReq.getOwnerMode(), aktWeibchen, father, "0", "MOS_OWNERGROUPS"));
                                msb.append(" ").append(GenotypeHelper.getAutoGenotypeCommandString(pupLineID, father, aktWeibchen, "-"));
                            }
                        }
                        if (msb.length() != 0) {
                            Vector mouseIDs;
                            HashMap neueObjekte;
                            HashMap primerg;
                            HashMap newObjectsByGroup;
                            TrafficReport.appendTrafficInfoClientSide(null, litterDate.getTime(), "TRD_LITTER", msb);
                            ObjectRequest or = InspectorCommandSender.executeCommandAndGetAnswer(msb.toString(), gruppe);
                            if (mussPetzen[0]) {
                                String text = father != null ? "<html><body>User <b>" + UserManager.getNameOfUser() + "</b> created a litter from mother " + aktWeibchen.getLink() + " and this father " + father.getLink() + " which was <b>not</b> determined by Mausoleum!</body></html>" : "<html><body>User <b>" + UserManager.getNameOfUser() + "</b> created a litter from mother " + aktWeibchen.getLink() + " without father</body></html>";
                                PopeAlert.petze("Litter with dubious fatherhood", text, gruppe, "PETZ_LITTER_WITHOUT_CLEAR_FATHER");
                            }
                            if (TierSchutz.isLineEvaluationPossible() && (newObjectsByGroup = (HashMap)(primerg = (HashMap)or.ivObject).get("#sno")) != null && (neueObjekte = (HashMap)newObjectsByGroup.get(gruppe)) != null && (mouseIDs = (Vector)neueObjekte.get(new Integer(1))) != null && !mouseIDs.isEmpty()) {
                                TierSchutz.makeAfterLitterProcedure(gruppe, mouseIDs, litterDate.getTime(), pupLineID);
                            }
                        }
                    }
                }
            }
            res = true;
        }
        return res;
    }

    private boolean checkActionFish(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (touchable && idObjects.size() == 2 && commonGroup != null && Privileges.hasPrivilege("CREATE_MICE")) {
            Mouse mother = null;
            Mouse father = null;
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                if (!mouse.isPossMatingPartner() || mouse.isRoomAccesibilityRestricted()) continue;
                if (mouse.getSex() == 2) {
                    if (mother != null) {
                        return false;
                    }
                    mother = mouse;
                    continue;
                }
                if (mouse.getSex() != 1) continue;
                if (father != null) {
                    return false;
                }
                father = mouse;
            }
            if (mother != null && father != null) {
                if (withExecution) {
                    if (mother.getActCage() == null) {
                        Alert.showAlert(Babel.get("NO_LITTER_WITHOUT CAGE"), true);
                        return false;
                    }
                    NewMiceRequester newMiceReq = new NewMiceRequester((Frame)Inspector.getInspector(), null, MyDate.getMyDate(System.currentTimeMillis()), true);
                    newMiceReq.setVisible(true);
                    if (newMiceReq.ivWarOK) {
                        Date litterDate = newMiceReq.getDate();
                        long fatherid = 0L;
                        boolean cont = true;
                        fatherid = father.getID();
                        if (cont) {
                            long lineID = LitterHelper.determineLineIDForOffspring(mother, father, true, 0L);
                            int anz = MALitter.getWantedAnz(newMiceReq, 250);
                            if (anz > 0 && anz <= 250) {
                                StringBuffer msb = new StringBuffer();
                                msb.append(CommandManagerExecutive.getServiceRoomTag(mother, ""));
                                msb.append("MFULI");
                                msb.append(" ").append(mother.getID());
                                msb.append(" ").append(fatherid);
                                msb.append(" ").append(anz);
                                msb.append(" ").append(litterDate.getTime());
                                msb.append(" ").append(lineID);
                                msb.append(" ").append(MALitter.getOwnerIDString(newMiceReq.getOwnerMode(), mother, father, "0", "MOS_OWNER"));
                                msb.append(" ").append(MALitter.getOwnerIDString(newMiceReq.getOwnerMode(), mother, father, "0", "MOS_OWNERGROUPS"));
                                msb.append(" ").append(GenotypeHelper.getAutoGenotypeCommandString(lineID, father, mother, "-"));
                                InspectorCommandSender.executeCommand(msb.toString(), commonGroup);
                            }
                        }
                    }
                }
                res = true;
            }
        }
        return res;
    }

    private static String getOwnerIDString(int modus, Mouse mutter, Mouse vater, String defVal, String ownerTag) {
        if (modus != 2) {
            Vector<Object> sammler = new Vector<Object>();
            switch (modus) {
                case 1: {
                    if (!ownerTag.equals("MOS_OWNER")) break;
                    sammler.add(UserManager.getUser().get("IDO_ID"));
                    break;
                }
                case 3: {
                    MALitter.fillOwnerIDVec(vater, sammler, ownerTag);
                    break;
                }
                case 4: {
                    MALitter.fillOwnerIDVec(mutter, sammler, ownerTag);
                    break;
                }
                case 5: {
                    MALitter.fillOwnerIDVec(vater, sammler, ownerTag);
                    MALitter.fillOwnerIDVec(mutter, sammler, ownerTag);
                    break;
                }
            }
            return MALitter.getLongVecString(sammler, defVal);
        }
        return defVal;
    }

    private static String getLongVecString(Vector sammler, String defVal) {
        if (!sammler.isEmpty()) {
            StringBuffer msb = new StringBuffer();
            Iterator iter = sammler.iterator();
            while (iter.hasNext()) {
                Long l = (Long)iter.next();
                msb.append(l);
                if (!iter.hasNext()) continue;
                msb.append("|");
            }
            return msb.toString();
        }
        return defVal;
    }

    private static void fillOwnerIDVec(Mouse maus, Vector sammler, String ownerTag) {
        long[] oarr;
        if (maus != null && (oarr = (long[])maus.get(ownerTag)) != null) {
            int i = 0;
            while (i < oarr.length) {
                Long val = new Long(oarr[i]);
                if (!sammler.contains(val)) {
                    sammler.add(val);
                }
                ++i;
            }
        }
    }
}

