/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.tables.MausoleumTableFrame;

public class MAOwnerSetPrimary
extends MouseAction {
    private static final String KLAPPT = "KLAPPT";
    private final HashMap ivOwnCountByUserID = new HashMap();
    private final Vector ivAllPossibleUsers = new Vector();
    private final StringBuilder ivSB = new StringBuilder();

    public boolean availableForPopup() {
        return false;
    }

    public boolean availableForInspectorTables() {
        return false;
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (touchable && commonGroup != null && idObjects != null && !idObjects.isEmpty() && UserManager.isRealUser() && Privileges.hasPrivilege("CHANGE_OWNERSHIP") && !commonGroup.equals("tgservice")) {
            String com = this.fillCommand(idObjects, commonGroup, withExecution);
            boolean bl = res = com != null;
            if (withExecution) {
                InspectorCommandSender.executeCommand(com, commonGroup);
                MausoleumTableFrame.repaintAllTables(false);
            }
        }
        return res;
    }

    private synchronized String fillCommand(Vector idObjects, String commonGroup, boolean produceCommand) {
        String res = null;
        boolean hadMulti = false;
        this.ivOwnCountByUserID.clear();
        int i = 0;
        while (i < idObjects.size()) {
            Mouse m = (Mouse)idObjects.elementAt(i);
            long[] owners = (long[])m.get("MOS_OWNER");
            if (owners != null) {
                if (owners.length > 1) {
                    hadMulti = true;
                }
                int oi = 0;
                while (oi < owners.length) {
                    Long key = new Long(owners[oi]);
                    Integer val = (Integer)this.ivOwnCountByUserID.get(key);
                    if (val == null) {
                        val = new Integer(0);
                    }
                    val = new Integer(val + 1);
                    this.ivOwnCountByUserID.put(key, val);
                    ++oi;
                }
            }
            ++i;
        }
        if (hadMulti) {
            this.ivAllPossibleUsers.clear();
            Iterator iterator = this.ivOwnCountByUserID.keySet().iterator();
            while (iterator.hasNext()) {
                User usi;
                Long ownerID = (Long)iterator.next();
                Integer countInt = (Integer)this.ivOwnCountByUserID.get(ownerID);
                if (countInt.intValue() != idObjects.size() || (usi = UserManager.getUser(ownerID, commonGroup)) == null) continue;
                this.ivAllPossibleUsers.addElement(usi);
            }
            if (!this.ivAllPossibleUsers.isEmpty()) {
                if (produceCommand) {
                    String[] possibleValues = new String[this.ivAllPossibleUsers.size()];
                    int i2 = 0;
                    while (i2 < this.ivAllPossibleUsers.size()) {
                        User usi = (User)this.ivAllPossibleUsers.elementAt(i2);
                        possibleValues[i2] = usi.getString("USR_NAME");
                        ++i2;
                    }
                    String selVal = AllgChoiceRequester.getStringAnswer(Inspector.getInspector(), Babel.get("CHOOSE_USER"), possibleValues);
                    if (selVal != null) {
                        User newUser = null;
                        Iterator iterator2 = this.ivAllPossibleUsers.iterator();
                        while (iterator2.hasNext() && newUser == null) {
                            User user = (User)iterator2.next();
                            if (!selVal.equals(user.getString("USR_NAME", null))) continue;
                            newUser = user;
                        }
                        if (newUser != null) {
                            this.ivSB.setLength(0);
                            Iterator iter = idObjects.iterator();
                            while (iter.hasNext()) {
                                Mouse mausi = (Mouse)iter.next();
                                this.ivSB.append(CommandManagerExecutive.getServiceRoomTag(mausi, ""));
                                this.ivSB.append("MSETPRIMOWN").append(" ");
                                this.ivSB.append(Long.toString(mausi.getID())).append(" ");
                                this.ivSB.append(Long.toString(newUser.getID())).append("\n");
                            }
                            res = this.ivSB.toString().trim();
                        }
                    }
                } else {
                    res = KLAPPT;
                }
            }
        }
        return res;
    }

    public String getBabel() {
        return "SETPRIMARYUSER";
    }
}

