/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.requester.mouse.ShareMouseRequester;

public class MAOwnerShare
extends MouseAction {
    private final int ivObjectType;
    private final String ivCommand;
    private final StringBuilder ivSB = new StringBuilder();

    public MAOwnerShare(int objectType) {
        this.ivObjectType = objectType;
        this.ivCommand = this.ivObjectType == 6 ? "MADDOWN" : "MADDOWNGROUP";
    }

    public boolean availableForInspectorTables() {
        return false;
    }

    public boolean availableForPopup() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (idObjects != null && !idObjects.isEmpty() && UserManager.isRealUser() && Privileges.hasPrivilege("CHANGE_OWNERSHIP") && commonGroup != null && UserManager.getUser() != null && UserManager.getUser().getGroup().equals(commonGroup) && touchable && IDObjectGroupManager.ownerGruppenDaOderUninteressant(this.ivObjectType, commonGroup) && !commonGroup.equals("tgservice")) {
            long shareID;
            res = true;
            if (withExecution && (shareID = ShareMouseRequester.getShareID(Inspector.getInspector(), commonGroup, this.ivObjectType)) != -1L) {
                String com = null;
                StringBuilder stringBuilder = this.ivSB;
                synchronized (stringBuilder) {
                    this.ivSB.setLength(0);
                    Iterator iter = idObjects.iterator();
                    while (iter.hasNext()) {
                        Mouse maus = (Mouse)iter.next();
                        this.ivSB.append(CommandManagerExecutive.getServiceRoomTag(maus, ""));
                        this.ivSB.append(this.ivCommand).append(" ");
                        this.ivSB.append(Long.toString(maus.getID())).append(" ");
                        this.ivSB.append(Long.toString(UserManager.getIDOFUser())).append(" ");
                        this.ivSB.append(Long.toString(shareID)).append("\n");
                    }
                    com = this.ivSB.toString().trim();
                }
                InspectorCommandSender.executeCommand(com, commonGroup);
            }
        }
        return res;
    }

    public String getBabel() {
        return this.ivObjectType == 6 ? "SHAREWITHUSER" : "SHAREWITHGROUP";
    }
}

