/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.mouse;

import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.awt.Frame;
import java.util.Date;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.mouse.MouseAction;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.objectstore.CommandManagerMouse;
import mausoleum.reports.TrafficReport;
import mausoleum.requester.mouse.MouseTransferRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.task.standards.StandardTask;
import mausoleum.visit.Visit;

public class MATransfer
extends MouseAction {
    public String getBabel() {
        return "TRANSFER";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (touchable && !idObjects.isEmpty() && Privileges.hasPrivilege("MOVE_MICE") && commonGroup != null && !Mouse.areMiceRoomAccesibilityRestricted(idObjects)) {
            if (withExecution) {
                MyDate minimumDate = null;
                Vector lastVisits = Mouse.getLastVisits(idObjects);
                if (!lastVisits.isEmpty()) {
                    minimumDate = MyDate.getMyDate(Visit.findLatestStartDate(lastVisits).getTime());
                }
                MouseTransferRequester mtr = new MouseTransferRequester((Frame)Inspector.getInspector(), minimumDate, MyDate.getMyDate(System.currentTimeMillis()), commonGroup);
                mtr.setVisible(true);
                long cageID = mtr.getTransferCageID();
                if (cageID != -1L) {
                    Vector paarungsSammler;
                    Cage target = null;
                    if (cageID != 0L) {
                        target = (Cage)ObjectStore.getClientObject(2, cageID, commonGroup);
                    }
                    if (!PopeAlert.makeCompleteMatingCheck(target, idObjects, paarungsSammler = new Vector())) {
                        return false;
                    }
                    Vector changingMice = new Vector();
                    if (PopeAlert.checkForCageGomorrha(cageID, idObjects, commonGroup) && PopeAlert.checkForEartag100Collision(cageID, idObjects, commonGroup) && PopeAlert.checkForRoomSecurity(idObjects, null, CageManager.getCage(new Long(cageID), commonGroup), null, null, changingMice)) {
                        Date transferDate = mtr.getDate();
                        if (cageID == 0L) {
                            cageID = Cage.getNewCageID(transferDate, commonGroup);
                        }
                        if (cageID == 0L) {
                            Alert.showAlert(Babel.get("COULDNOTCREATECAGE"), true);
                        } else {
                            MATransfer.transferThem(idObjects, cageID, transferDate, paarungsSammler, commonGroup, changingMice, null, null);
                        }
                    }
                }
            }
            res = true;
        }
        return res;
    }

    public static void transferThem(Vector idObjects, long cageID, Date transferDate, Vector paarungsSammler, String commonGroup, Vector changingMice, Vector miceForExtraTaskFinish, String extraTaskFinish) {
        long millis = transferDate.getTime();
        int actionDate = (int)(millis / 86400000L);
        StringBuffer msb = new StringBuffer();
        TaskExtended.addExactPoolingTaskFinish(idObjects, cageID, msb, actionDate);
        TrafficReport.appendTrafficInfoClientSide(idObjects, millis, "TRD_TRANSFER", msb);
        int i = 0;
        while (i < idObjects.size()) {
            Mouse mouse = (Mouse)idObjects.elementAt(i);
            TaskExtended.addTaskFinishsToComBuff(mouse, mouse.getTaskKey(), "TASK_AC_TRANSFER", 0L, msb, actionDate);
            if (msb.length() != 0) {
                msb.append("\n");
            }
            CommandManagerMouse.appendTransferCommand(mouse, cageID, millis, msb, false);
            ++i;
        }
        StandardTask.checkForToAndFromMating(idObjects, paarungsSammler, msb, actionDate);
        TaskExtended.getRoomTransferTaskCommand(changingMice, msb, actionDate);
        if (miceForExtraTaskFinish != null) {
            TaskExtended.addTaskFinishsToMiceComBuff(miceForExtraTaskFinish, extraTaskFinish, msb, actionDate);
        }
        InspectorCommandSender.executeCommand(msb.toString(), commonGroup);
    }
}

