/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.rack;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.rack.RackAction;
import mausoleum.inspector.actions.usergroup.UsergroupAction;
import mausoleum.rack.Rack;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.usergroup.UserGroup;
import mausoleum.usergroup.UsergroupManager;

public class RABar
extends RackAction {
    public String getBabel() {
        return "GIVE_RACK_TO_GROUP";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = false;
        if (idObjects != null && idObjects.size() == 1 && Privileges.hasPrivilege("GIVE_RACK_TO_GROUP")) {
            res = true;
            if (withExecution) {
                String[] groupsArr;
                Rack rack = (Rack)idObjects.firstElement();
                TreeSet<String> remainingGroupNames = new TreeSet<String>();
                Vector v = UsergroupManager.cvInstance.getActualObjectVectorAllGroups();
                if (v != null) {
                    Iterator iter = v.iterator();
                    while (iter.hasNext()) {
                        UserGroup ug = (UserGroup)iter.next();
                        remainingGroupNames.add(ug.getName());
                    }
                }
                if ((groupsArr = (String[])rack.get("IDO_UGROUPS")) != null) {
                    int i = 0;
                    while (i < groupsArr.length) {
                        if (remainingGroupNames.contains(groupsArr[i])) {
                            remainingGroupNames.remove(groupsArr[i]);
                        }
                        ++i;
                    }
                }
                if (remainingGroupNames.isEmpty()) {
                    Alert.showAlert(Babel.get("NO_MORE_POSSIBLE_GROUPS"), true);
                } else {
                    String selectedGroup = null;
                    String[] arr = new String[remainingGroupNames.size()];
                    int pos = 0;
                    Iterator iter = remainingGroupNames.iterator();
                    while (iter.hasNext()) {
                        arr[pos++] = (String)iter.next();
                    }
                    selectedGroup = arr.length == 1 ? arr[0] : AllgChoiceRequester.getStringAnswer(Inspector.getInspector(), Babel.get("SELECT_GROUP"), arr);
                    if (selectedGroup != null) {
                        String com = "ALLG_ATTACH_TO_SERVICE " + rack.getID() + " " + Base64Manager.encodeBase64(selectedGroup) + " " + 3;
                        RequestManager.sendCommandRequestAndGetAnswer(com, UserManager.getFirstGroup());
                        UsergroupAction.invalidateRackStatus(selectedGroup);
                    }
                }
            }
        }
        return res;
    }
}

