/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.room;

import de.hannse.netobjects.user.UserManager;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.IAManager;
import mausoleum.inspector.actions.InspectorAction;
import mausoleum.inspector.actions.room.ROARemoveEmptyCages;
import mausoleum.inspector.actions.room.ROASetBuilding;
import mausoleum.inspector.actions.room.ROAUseAll;
import mausoleum.inspector.actions.room.ROAUseThis;
import mausoleum.main.MausoleumClient;
import mausoleum.room.Room;
import mausoleum.room.RoomManager;
import mausoleum.room.RoomStatusListener;

public abstract class RoomAction
implements InspectorAction {
    public static final String COM_USE_ALL = "ROA_USE_ALL";
    public static final String COM_SET_BUILDING = "ROA_SET_BUILDING";
    public static final String COM_USE_THIS = "ROA_USE_THIS";
    public static final String COM_REMOVE_EMPTY_CAGES = "ROA_REMOVE_EMPTY_CAGES";
    public static long cvRoomID = 0L;
    public static String cvRoomName = null;
    public static String cvRoomStatus = "[all rooms]";
    public static Vector cvListeners = new Vector();
    static /* synthetic */ Class class$0;

    public static void init() {
        if (MausoleumClient.isRegularOrTGService()) {
            IAManager.register(COM_USE_ALL, new ROAUseAll());
            IAManager.register(COM_USE_THIS, new ROAUseThis());
        }
        if (MausoleumClient.isHeadOfService()) {
            IAManager.register(COM_SET_BUILDING, new ROASetBuilding());
            IAManager.register(COM_REMOVE_EMPTY_CAGES, new ROARemoveEmptyCages());
        }
    }

    public static void addListener(RoomStatusListener rl) {
        if (cvListeners.indexOf(rl) == -1) {
            cvListeners.addElement(rl);
        }
    }

    public static void removeListener(RoomStatusListener rl) {
        if (cvListeners.indexOf(rl) != -1) {
            cvListeners.removeElement(rl);
        }
    }

    public Class getObjectClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.room.Room");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean availableForInspectorTables() {
        return false;
    }

    public boolean availableForPopup() {
        return true;
    }

    public static void roomStatusChanged() {
        if (MausoleumClient.isRegularOrTGService()) {
            if (cvRoomID == 0L) {
                cvRoomName = null;
            } else {
                Room rr = RoomManager.getRoom(cvRoomID, UserManager.getFirstGroup());
                if (rr != null) {
                    cvRoomStatus = "[room: " + rr.getString("ROM_NAME") + "]";
                    cvRoomName = rr.getString("ROM_NAME");
                } else {
                    cvRoomID = 0L;
                    cvRoomName = null;
                    cvRoomStatus = "[all rooms]";
                }
            }
            Inspector.setAppropriateTitle();
            int i = 0;
            while (i < cvListeners.size()) {
                RoomStatusListener rsl = (RoomStatusListener)cvListeners.elementAt(i);
                try {
                    rsl.roomStatusChanged();
                }
                catch (Exception e) {
                    System.out.println("Exception while informing RoomStatusListener " + rsl + " " + e);
                }
                ++i;
            }
        }
    }

    public String getTooltipBabel() {
        return null;
    }
}

