/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.task;

import java.awt.Frame;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.task.TaskAction;
import mausoleum.requester.calendar.CalendarRequester;
import mausoleum.requester.calendar.TaskEditStartEndRequester;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.task.DisplayTask;

public class TAChangeDate
extends TaskAction {
    private static final String COM = "TASK_COM_CHANGE_DATE";

    public String getBabel() {
        return COM;
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res = TAChangeDate.isAllowed(COM, idObjects, true, true);
        if (res && idObjects != null && !idObjects.isEmpty()) {
            DisplayTask dt = (DisplayTask)idObjects.elementAt(0);
            int dateTyp = dt.getDateTyp();
            Iterator iterator = idObjects.iterator();
            while (res && iterator.hasNext()) {
                dt = (DisplayTask)iterator.next();
                if (dt.getDateTyp() != dateTyp) {
                    res = false;
                }
                if (!dt.ivTask.isPeriodTask() || dt.ivTask.ivKnipser == null || dt.ivTask.ivKnipser.length == 0) continue;
                res = false;
            }
            if (res && withExecution) {
                if (dateTyp == 1) {
                    String commentToAdd;
                    Date newDate = CalendarRequester.getDate((Frame)Inspector.getInspector(), new Date(), null);
                    if (newDate != null && PopeAlert.checkTaskDateForHoliday((int)(newDate.getTime() / 86400000L)) && (commentToAdd = this.getActionComment()) != null) {
                        TAChangeDate.setStatus(COM, idObjects, -1, commentToAdd, newDate, Integer.MIN_VALUE, Integer.MIN_VALUE, -1, Integer.MIN_VALUE, Integer.MIN_VALUE, null);
                    }
                } else if (dateTyp == 2) {
                    String commentToAdd;
                    dt = (DisplayTask)idObjects.elementAt(0);
                    int startTag = dt.ivTask.ivDatum;
                    int endTag = dt.ivTask.ivPeriodEnd;
                    int frequency = dt.ivTask.ivPeriodFrequency;
                    Iterator iterator2 = idObjects.iterator();
                    while (res && iterator2.hasNext()) {
                        dt = (DisplayTask)iterator2.next();
                        if (startTag != Integer.MIN_VALUE && dt.ivTask.ivDatum != startTag) {
                            startTag = Integer.MIN_VALUE;
                        }
                        if (endTag != Integer.MIN_VALUE && dt.ivTask.ivPeriodEnd != endTag) {
                            endTag = Integer.MIN_VALUE;
                        }
                        if (frequency == -1 || dt.ivTask.ivPeriodFrequency == frequency) continue;
                        frequency = -1;
                    }
                    int[] daten = TaskEditStartEndRequester.getStartEndAndFrequency(startTag, endTag, frequency);
                    if (daten != null && (commentToAdd = this.getActionComment()) != null) {
                        TAChangeDate.setStatus(COM, idObjects, -1, commentToAdd, null, daten[0], daten[1], daten[2], Integer.MIN_VALUE, Integer.MIN_VALUE, null);
                    }
                }
            }
        }
        return res;
    }
}

