/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.task;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.actions.task.TaskAction;
import mausoleum.mail.Mail;
import mausoleum.mouse.Mouse;
import mausoleum.requester.MoreTextRequester;
import mausoleum.task.DisplayTask;

public class TAReject
extends TaskAction {
    private static final String COM = "TASK_COM_REJECT";

    public String getBabel() {
        return COM;
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        String commentToAdd;
        boolean res = TAReject.isAllowed(COM, idObjects, true, true);
        if (res && withExecution && (commentToAdd = MoreTextRequester.getText(Inspector.getInspector(), Babel.get("EXPLAIN_REASON"), true)) != null) {
            String myIdentifier = UserManager.getUserWithoutDisguise().getIdentifierString();
            HashMap<String, Vector<String>> mailContsByIssuerIdentifier = new HashMap<String, Vector<String>>();
            HashMap obsByGroup = IDObject.sortByGroup(idObjects);
            if (obsByGroup != null) {
                Iterator iter = obsByGroup.keySet().iterator();
                while (iter.hasNext()) {
                    String group = (String)iter.next();
                    Vector obs = (Vector)obsByGroup.get(group);
                    Iterator iterator = obs.iterator();
                    while (iterator.hasNext()) {
                        IDObject iob;
                        String issuerID;
                        DisplayTask tcc = (DisplayTask)iterator.next();
                        if (tcc.ivTask.ivIssuerID <= 0L || tcc.ivTask.ivIssuerGroup == null || (issuerID = IDObject.getIdentifierString(tcc.ivTask.ivIssuerGroup, 6, tcc.ivTask.ivIssuerID)).equals(myIdentifier) || (iob = ObjectStore.getClientObject(tcc.ivTask.ivObjectType, tcc.ivTask.ivObjectID, group)) == null) continue;
                        StringBuilder msb = new StringBuilder();
                        if (iob instanceof Mouse) {
                            msb.append("Mouse ");
                        } else if (iob instanceof Cage) {
                            msb.append("Cage ");
                        } else {
                            msb.append("Object ");
                        }
                        msb.append(iob.getLink()).append(" Task: ").append(tcc.ivTask.getDescription(group, false));
                        Vector<String> v = (Vector<String>)mailContsByIssuerIdentifier.get(issuerID);
                        if (v == null) {
                            v = new Vector<String>();
                            mailContsByIssuerIdentifier.put(issuerID, v);
                        }
                        v.add(msb.toString());
                    }
                }
            }
            TAReject.setStatus(COM, idObjects, 4, commentToAdd, null, Integer.MIN_VALUE, Integer.MIN_VALUE, -1, Integer.MIN_VALUE, Integer.MIN_VALUE, null);
            if (!mailContsByIssuerIdentifier.isEmpty()) {
                Iterator iterator = mailContsByIssuerIdentifier.keySet().iterator();
                while (iterator.hasNext()) {
                    String sid = (String)iterator.next();
                    IDObject.IDObjectIdentifier issuerIDentifier = new IDObject.IDObjectIdentifier(sid);
                    User issuer = (User)ObjectStore.getClientObject(issuerIDentifier);
                    if (issuer == null) continue;
                    String lang = issuer.getString("USR_LANGUAGE", "en");
                    Vector lines = (Vector)mailContsByIssuerIdentifier.get(sid);
                    String topic = Babel.get("PETZ_TASK_REJECTED", lang);
                    StringBuilder csb = new StringBuilder();
                    csb.append("<html><body>");
                    csb.append(StringHelper.gSub(Babel.get("PETZ_TASK_REJECTED_LONG", lang), "_USER_", "<b>" + UserManager.getNameOfUser() + "</b>"));
                    csb.append("\n<hr>\n<ul>");
                    Iterator iterator2 = lines.iterator();
                    while (iterator2.hasNext()) {
                        String line = (String)iterator2.next();
                        csb.append("<li>").append(line).append("\n");
                    }
                    csb.append("</ul>\n<hr>\n");
                    csb.append(Babel.get("COMMENT", lang)).append(": ");
                    csb.append(commentToAdd);
                    csb.append("</body></html>");
                    Mail brief = Mail.getSystemMail();
                    brief.set("MAI_RECEIVER", issuer.get("USR_NAME"));
                    brief.set("MAI_RGROUP", issuerIDentifier.ivGroup);
                    brief.set("MAI_RECEIVER_ID", issuer.getLongID());
                    brief.set("MAI_SUBJECT", topic);
                    brief.set("MAI_TEXT", csb.toString());
                    brief.versendeDich(issuerIDentifier.ivGroup);
                }
            }
        }
        return res;
    }
}

