/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.actions.usergroup;

import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.inspector.actions.usergroup.BasicObjectMerker;
import mausoleum.inspector.actions.usergroup.UsergroupAction;
import mausoleum.usergroup.UserGroup;

public class UGAGeneralImport
extends UsergroupAction {
    public final Integer ivType;

    public UGAGeneralImport(Integer type) {
        this.ivType = type;
    }

    public String getBabel() {
        return "IMPORT_TO_SERVICE";
    }

    public boolean checkAction(Vector idObjects, boolean withExecution, String commonGroup, boolean touchable) {
        boolean res;
        Object[] primaerMerker = UsergroupAction.getSelectedMerkers(this.ivType);
        Vector<BasicObjectMerker> merkers = new Vector<BasicObjectMerker>();
        if (primaerMerker != null) {
            int i = 0;
            while (i < primaerMerker.length) {
                BasicObjectMerker bom = (BasicObjectMerker)primaerMerker[i];
                if (bom.ivServiceID == -1L && bom.ivServiceImportable) {
                    merkers.add(bom);
                }
                ++i;
            }
        }
        boolean bl = res = idObjects != null && idObjects.size() == 1 && !merkers.isEmpty();
        if (res && withExecution) {
            String question;
            UserGroup ug = (UserGroup)idObjects.firstElement();
            String string = question = merkers.size() == 1 ? "REALLY_IMPORT_OBJECT" : "REALLY_IMPORT_OBJECTS";
            if (Alert.showAlert(Babel.get(question), false)) {
                StringBuilder msb = new StringBuilder();
                Iterator iterator = merkers.iterator();
                while (iterator.hasNext()) {
                    msb.setLength(0);
                    BasicObjectMerker bom = (BasicObjectMerker)iterator.next();
                    msb.append("ALLG_IMPORT_TO_SERVICE").append(" ");
                    msb.append(Base64Manager.encodeBase64(ug.ivName)).append(" ");
                    msb.append(this.ivType).append(" ");
                    msb.append(bom.ivIDInGroup);
                    ObjectRequest mor = RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), UserManager.getFirstGroup());
                    res &= mor != null && mor.isFinished();
                }
            }
        }
        return res;
    }
}

