/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.util.Babel;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.inspector.DormantPanel;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.mouse.Mouse;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.TableFrameCage;
import mausoleum.tables.models.MTCage;
import mausoleum.tables.models.MTCageMikro;
import mausoleum.ui.UIDef;

public class CagePane
extends RequesterPane
implements IPTabPanel {
    private static final long serialVersionUID = 1234L;
    private MGButton ivConvertCageTableButton = null;
    private MausoleumTable ivCageTable = null;
    protected String ivConvCageTableTitle = null;

    public CagePane(String convCageTableTitle, MTCage cageTableModel) {
        super((LayoutManager)new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND), "inspectorBack");
        this.setOpaque(false);
        if (cageTableModel == null) {
            cageTableModel = new MTCageMikro();
        }
        this.ivCageTable = new MausoleumTable(cageTableModel, true);
        this.ivConvCageTableTitle = convCageTableTitle;
        this.add("Center", this.ivCageTable);
        this.ivConvertCageTableButton = new MGButton(Babel.get("CONVTOCAGEDISPLAY"));
        this.ivConvertCageTableButton.setFont(FontManager.getFont("SSB12"));
        this.ivConvertCageTableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                DormantPanel.actionDone();
                TableFrameCage.showCageTable(new MTCage(((CagePane)CagePane.this).ivCageTable.ivModel.ivObjects), CagePane.this.ivConvCageTableTitle, Babel.get("CAGE_COLLECTION"));
            }
        });
        this.add("South", this.ivConvertCageTableButton);
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        Vector cages = new Vector();
        if (mice != null) {
            HashSet<Cage> hs = new HashSet<Cage>();
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                Cage c;
                Mouse mouse = (Mouse)iter.next();
                if (!mouse.isAliveAndVisible() || (c = mouse.getActCage()) == null) continue;
                hs.add(c);
            }
            cages.addAll(hs);
        }
        this.ivCageTable.ivModel.setTable(cages);
        this.ivConvertCageTableButton.setEnabled(!cages.isEmpty());
    }
}

