/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.WindowUtils;
import mausoleum.inspector.DocumentsTable;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.actions.documents.AddDocuButton;
import mausoleum.inspector.actions.documents.DocuButton;
import mausoleum.inspector.actions.documents.RemoveDocuButton;
import mausoleum.inspector.actions.documents.ShowDocuButton;
import mausoleum.inspector.panels.DocPaneAdaptListener;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.ui.UIDef;

public class DocumentsPane
extends RequesterPane
implements ListSelectionListener,
IPTabPanel {
    private static final long serialVersionUID = 1L;
    private static final Vector NIX_ADAPT = new Vector();
    public final DocumentsTable ivDocumentsTable = new DocumentsTable();
    private AddDocuButton ivAddDocuButton = null;
    private DocuButton ivRemoveDocuButton = null;
    private DocuButton ivShowDocuButton = null;
    private DocuButton ivOpenDocuButton = null;
    private DocPaneAdaptListener ivAdaptListener = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void interpretDocString(String doc1, String group, HashMap hs) {
        if (doc1 != null) {
            Vector docv = StringHelper.splitStringByAny(doc1, "|");
            Iterator iterator2 = docv.iterator();
            while (iterator2.hasNext()) {
                String doc2 = (String)iterator2.next();
                if (doc2.length() == 0) continue;
                hs.put(Base64Manager.getDecodedString(doc2), group);
            }
        }
    }

    public DocumentsPane(String addPrivilege, String removePrivilege, String showPrivilege) {
        super((LayoutManager)new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND), "inspectorBack");
        this.ivDocumentsTable.setOpaque(false);
        this.ivDocumentsTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane jsp = new JScrollPane(this.ivDocumentsTable);
        this.ivDocumentsTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && DocumentsPane.this.ivOpenDocuButton != null && DocumentsPane.this.ivOpenDocuButton.isEnabled()) {
                    DocumentsPane.this.ivOpenDocuButton.checkAction(null, true);
                }
            }
        });
        this.ivDocumentsTable.setDragEnabled(true);
        this.ivDocumentsTable.setFillsViewportHeight(true);
        this.ivDocumentsTable.setTransferHandler(new TransferHandler(){
            private static final long serialVersionUID = 1234234L;

            public boolean canImport(TransferHandler.TransferSupport support) {
                return DocumentsPane.this.ivAddDocuButton.isEnabled() && support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            public boolean importData(TransferHandler.TransferSupport support) {
                return DocumentsPane.this.regularDragImport(support);
            }
        });
        this.add("Center", jsp);
        JPanel subPan = new JPanel(new GridLayout(1, 4, UIDef.INNER_RAND, UIDef.INNER_RAND));
        subPan.setOpaque(false);
        this.ivAddDocuButton = new AddDocuButton(addPrivilege);
        this.ivRemoveDocuButton = new RemoveDocuButton(removePrivilege);
        this.ivShowDocuButton = new ShowDocuButton(showPrivilege, false);
        this.ivOpenDocuButton = new ShowDocuButton(showPrivilege, true);
        subPan.add(this.ivAddDocuButton);
        subPan.add(this.ivRemoveDocuButton);
        subPan.add(this.ivShowDocuButton);
        subPan.add(this.ivOpenDocuButton);
        this.add("South", subPan);
    }

    public void setAdaptListener(DocPaneAdaptListener listener) {
        this.ivAdaptListener = listener;
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        if (this.ivDocumentsTable != null) {
            Vector useIDObjects = idObjects;
            if (this.ivAdaptListener != null && !this.ivAdaptListener.showDocs(idObjects)) {
                useIDObjects = NIX_ADAPT;
            }
            HashMap documentInfoHashMap = new HashMap();
            if (!useIDObjects.isEmpty()) {
                Iterator iterator = useIDObjects.iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    if (!(object instanceof IDObject)) continue;
                    IDObject ido = (IDObject)object;
                    String group = ido.isSharedWithOtherGroups() ? "service" : ido.getGroup();
                    DocumentsPane.interpretDocString(ido.getString("IDO_DOK", null), group, documentInfoHashMap);
                }
            }
            this.ivDocumentsTable.setData(documentInfoHashMap);
            this.ivAddDocuButton.checkEnabled(useIDObjects);
            this.ivRemoveDocuButton.checkEnabled(useIDObjects);
            this.ivShowDocuButton.checkEnabled(useIDObjects);
            this.ivOpenDocuButton.checkEnabled(useIDObjects);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            InspectorPanel ip;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("mausoleum.inspector.InspectorPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((ip = (InspectorPanel)WindowUtils.getParent(this, clazz)) != null) {
                Vector useIDObjects = ip.ivSelObjects;
                if (this.ivAdaptListener != null && !this.ivAdaptListener.showDocs(ip.ivSelObjects)) {
                    useIDObjects = NIX_ADAPT;
                }
                this.ivAddDocuButton.checkEnabled(useIDObjects);
                this.ivRemoveDocuButton.checkEnabled(useIDObjects);
                this.ivShowDocuButton.checkEnabled(useIDObjects);
                this.ivOpenDocuButton.checkEnabled(useIDObjects);
            }
        }
    }

    private boolean regularDragImport(TransferHandler.TransferSupport support) {
        block10: {
            Transferable t = support.getTransferable();
            if (t != null) {
                try {
                    InspectorPanel ip;
                    List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                    Vector realFiles = new Vector();
                    FileManager.addRealFiles(files, realFiles);
                    if (realFiles == null || realFiles.isEmpty()) break block10;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("mausoleum.inspector.InspectorPanel");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((ip = (InspectorPanel)WindowUtils.getParent(this, clazz)) != null) {
                        Vector selIDObjects = ip.ivSelObjects;
                        return this.ivAddDocuButton.addMultipleDocs(selIDObjects, realFiles);
                    }
                }
                catch (Exception e) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("mausoleum.inspector.panels.DocumentsPane");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem while importing from Drag and Drop", e, clazz);
                }
            }
        }
        return false;
    }
}

