/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.main.MausoleumClient;
import mausoleum.rack.Rack;
import mausoleum.requester.pope.PopeAlert;
import mausoleum.ui.UIDef;
import mausoleum.ui.table.SortableTable;
import mausoleum.usergroup.UserGroup;
import mausoleum.usergroup.UsergroupManager;

public class GrantedGroupsPane
extends RequesterPane
implements IPTabPanel {
    private static final long serialVersionUID = 1234345L;
    private GrantedGroupsTable ivGrantedGroupsTable = new GrantedGroupsTable();
    private JScrollPane ivScrollPane = new JScrollPane(this.ivGrantedGroupsTable);
    private MGButton ivAttachButton = new MGButton(Babel.get("GENERAL_BAR"));
    private MGButton ivDetachButton = new MGButton(Babel.get("GENERAL_DISBAR"));
    private MGButton ivCheckLociButton = null;
    private long ivObjectID = 0L;
    private String[] ivGrantedGroups = null;
    private long[] ivGrantedGOIDs = null;
    private final int ivObjectTyp;
    private final ActionListener ivActionlistener;
    private StringBuilder ivAdjustLociSB = null;
    static /* synthetic */ Class class$0;

    public GrantedGroupsPane(int objectTyp, ActionListener al) {
        super(null, "inspectorBack");
        this.ivObjectTyp = objectTyp;
        this.add(this.ivScrollPane);
        this.ivActionlistener = al;
        this.ivAttachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int[] selRows = GrantedGroupsPane.this.ivGrantedGroupsTable.getSelectedRows();
                if (selRows != null) {
                    boolean res;
                    Vector<String> modGroups = new Vector<String>(selRows.length);
                    StringBuilder msb = new StringBuilder();
                    int i = 0;
                    while (i < selRows.length) {
                        String group = (String)((GrantedGroupsPane)GrantedGroupsPane.this).ivGrantedGroupsTable.ivObjects.elementAt(selRows[i]);
                        int ind = ArrayHelper.findStringInArray(group, GrantedGroupsPane.this.ivGrantedGroups);
                        if (ind == -1) {
                            if (msb.length() != 0) {
                                msb.append("\n");
                            }
                            msb.append("ALLG_ATTACH_TO_SERVICE").append(" ");
                            msb.append(GrantedGroupsPane.this.ivObjectID).append(" ");
                            msb.append(Base64Manager.encodeBase64(group)).append(" ");
                            msb.append(GrantedGroupsPane.this.ivObjectTyp);
                            modGroups.add(group);
                        }
                        ++i;
                    }
                    if (msb.length() != 0 && (res = InspectorCommandSender.executeCommand(msb.toString(), "service")) && GrantedGroupsPane.this.ivActionlistener != null) {
                        Iterator iterator = modGroups.iterator();
                        while (iterator.hasNext()) {
                            GrantedGroupsPane.this.ivActionlistener.actionPerformed(new ActionEvent(GrantedGroupsPane.this.ivAttachButton, 1, "ATTACHED " + (String)iterator.next()));
                        }
                    }
                }
            }
        });
        this.add(this.ivAttachButton);
        this.ivDetachButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int[] selRows = GrantedGroupsPane.this.ivGrantedGroupsTable.getSelectedRows();
                if (selRows != null) {
                    boolean res;
                    TreeSet<String> usedGroups = new TreeSet<String>(StringHelper.CASE_INSENSITIVE_COMPARER);
                    StringBuilder msb = new StringBuilder();
                    int i = 0;
                    while (i < selRows.length) {
                        String group = (String)((GrantedGroupsPane)GrantedGroupsPane.this).ivGrantedGroupsTable.ivObjects.elementAt(selRows[i]);
                        int ind = ArrayHelper.findStringInArray(group, GrantedGroupsPane.this.ivGrantedGroups);
                        if (ind != -1) {
                            usedGroups.add(group);
                            if (msb.length() != 0) {
                                msb.append("\n");
                            }
                            msb.append("ALLG_DETACH_FROM_SERVICE").append(" ");
                            msb.append(GrantedGroupsPane.this.ivObjectID).append(" ");
                            msb.append(Base64Manager.encodeBase64(group)).append(" ");
                            msb.append(GrantedGroupsPane.this.ivGrantedGOIDs[ind]).append(" ");
                            msb.append(GrantedGroupsPane.this.ivObjectTyp);
                        }
                        ++i;
                    }
                    if (msb.length() != 0 && (res = InspectorCommandSender.executeCommand(msb.toString(), "service")) && GrantedGroupsPane.this.ivActionlistener != null) {
                        Rack rack;
                        if (GrantedGroupsPane.this.ivObjectTyp == 3 && !usedGroups.isEmpty() && (rack = (Rack)ObjectStore.getClientObject(GrantedGroupsPane.this.ivObjectTyp, GrantedGroupsPane.this.ivObjectID, "service")) != null) {
                            StringBuilder hhsb = new StringBuilder();
                            Iterator iterator = usedGroups.iterator();
                            while (iterator.hasNext()) {
                                String group = (String)iterator.next();
                                if (hhsb.length() != 0) {
                                    hhsb.append(", ");
                                }
                                hhsb.append("<b>").append(group).append("</b>");
                            }
                            String plural = usedGroups.size() > 1 ? "s " : " ";
                            String petzText = "<html><body>User <b>" + UserManager.getNameOfUser() + "</b> made the Rack (\"" + rack.getName() + "\") inaccessible for group" + plural + hhsb.toString() + "</body></html>";
                            PopeAlert.petze("Service rack made inaccessible for regular group" + plural, petzText, "service", "PETZ_NEW_RACK_IN_NORMAL_GROUP");
                        }
                        Iterator iterator = usedGroups.iterator();
                        while (iterator.hasNext()) {
                            GrantedGroupsPane.this.ivActionlistener.actionPerformed(new ActionEvent(GrantedGroupsPane.this.ivAttachButton, 1, "ATTACHED " + (String)iterator.next()));
                        }
                    }
                    usedGroups.clear();
                    Object var3_3 = null;
                }
            }
        });
        this.add(this.ivDetachButton);
        if (this.ivObjectTyp == 7) {
            this.ivCheckLociButton = new MGButton(Babel.get("CHECK_LOCI"));
            this.ivCheckLociButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    if (GrantedGroupsPane.this.ivAdjustLociSB != null && GrantedGroupsPane.this.ivAdjustLociSB.length() != 0) {
                        boolean res = InspectorCommandSender.executeCommand(GrantedGroupsPane.this.ivAdjustLociSB.toString(), "service");
                        GrantedGroupsPane.this.ivAdjustLociSB.setLength(0);
                        if (res && GrantedGroupsPane.this.ivActionlistener != null) {
                            GrantedGroupsPane.this.ivActionlistener.actionPerformed(new ActionEvent(GrantedGroupsPane.this.ivCheckLociButton, 1, "ATTACHED"));
                        }
                        GrantedGroupsPane.this.checkButtons();
                    }
                }
            });
            this.add(this.ivCheckLociButton);
        }
        this.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container arg0) {
                Dimension d = arg0.getSize();
                int rand = UIDef.INNER_RAND;
                int bh = UIDef.BUT_HEIGHT;
                int w = d.width - 2 * rand;
                int h = d.height - 2 * rand - (bh + rand);
                if (GrantedGroupsPane.this.ivCheckLociButton != null) {
                    h -= bh + rand;
                }
                int x = rand;
                int y = rand;
                GrantedGroupsPane.this.ivScrollPane.setBounds(rand, rand, w, h);
                int lbw = (w - rand) / 2;
                int rbw = w - rand - lbw;
                GrantedGroupsPane.this.ivAttachButton.setBounds(x, y += h + rand, lbw, bh);
                GrantedGroupsPane.this.ivDetachButton.setBounds(x + rand + lbw, y, rbw, bh);
                y += bh + rand;
                if (GrantedGroupsPane.this.ivCheckLociButton != null) {
                    GrantedGroupsPane.this.ivCheckLociButton.setBounds(x, y, w, bh);
                }
            }
        });
        this.ivGrantedGroupsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent arg0) {
                GrantedGroupsPane.this.checkButtons();
            }
        });
        this.adapt(null, null, null);
    }

    public void adapt(Vector selObjects, Vector mice, Vector changeSensitives) {
        if (this.ivAdjustLociSB != null) {
            this.ivAdjustLociSB.setLength(0);
        }
        if (selObjects == null || selObjects.isEmpty() || selObjects.size() != 1 || !MausoleumClient.isHeadOfService() && !IDObject.commonGroup(selObjects).equals("service")) {
            this.ivGrantedGroupsTable.adapt(null);
            this.ivGrantedGroupsTable.clearSelection();
            this.ivGrantedGroupsTable.setEnabled(false);
            this.ivGrantedGroupsTable.setOpaque(false);
            this.ivScrollPane.setOpaque(false);
            this.ivObjectID = 0L;
            this.ivGrantedGroups = null;
            this.ivGrantedGOIDs = null;
        } else {
            IDObject ido = (IDObject)selObjects.firstElement();
            this.ivObjectID = ido.getID();
            this.ivGrantedGroups = (String[])ido.get("IDO_UGROUPS");
            this.ivGrantedGOIDs = (long[])ido.get("IDO_UGROUPIDS");
            this.ivGrantedGroupsTable.adapt(ido);
            this.ivGrantedGroupsTable.setEnabled(true);
            this.ivGrantedGroupsTable.setOpaque(true);
            this.ivScrollPane.setOpaque(true);
        }
        this.checkButtons();
    }

    private void checkButtons() {
        if (this.ivAttachButton != null || this.ivDetachButton != null || this.ivCheckLociButton != null) {
            int[] selRows;
            HashSet selectedGroups = null;
            boolean attachEnabled = false;
            boolean detachEnabled = false;
            if (this.ivGrantedGroupsTable.isEnabled() && (selRows = this.ivGrantedGroupsTable.getSelectedRows()) != null && selRows.length != 0) {
                selectedGroups = new HashSet();
                int i = 0;
                while (i < selRows.length) {
                    selectedGroups.add(this.ivGrantedGroupsTable.ivObjects.elementAt(selRows[i]));
                    ++i;
                }
                Iterator iterator = selectedGroups.iterator();
                while (iterator.hasNext()) {
                    String group = (String)iterator.next();
                    if (this.ivGrantedGroupsTable.ivGrantedGroupnames.contains(group)) {
                        detachEnabled = true;
                        continue;
                    }
                    attachEnabled = true;
                }
            }
            if (detachEnabled && this.ivObjectTyp == 14 && this.isLocusUsedInLineForOneOfTheGroups(selectedGroups)) {
                detachEnabled = false;
            }
            if (this.ivAttachButton != null) {
                this.ivAttachButton.setEnabled(attachEnabled);
            }
            if (this.ivDetachButton != null) {
                this.ivDetachButton.setEnabled(detachEnabled);
            }
            if (this.ivCheckLociButton != null) {
                this.prepareAdjustCommand();
                this.ivCheckLociButton.setEnabled(this.ivAdjustLociSB != null && this.ivAdjustLociSB.length() != 0);
            }
        }
    }

    private boolean isLocusUsedInLineForOneOfTheGroups(HashSet selectedGroups) {
        Vector lines = ObjectStore.getActualObjects(7, "service");
        if (lines != null && !lines.isEmpty()) {
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                Line line = (Line)iterator.next();
                LocusAndAlleles[] lal = (LocusAndAlleles[])line.get("LIN_LOCIALLELES");
                if (lal == null) continue;
                int i = 0;
                while (i < lal.length) {
                    String[] grantedGroups;
                    if (lal[i].ivLocusID == this.ivObjectID && (grantedGroups = (String[])line.get("IDO_UGROUPS")) != null && grantedGroups.length != 0) {
                        int j = 0;
                        while (j < grantedGroups.length) {
                            if (selectedGroups.contains(grantedGroups[j])) {
                                return true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private void prepareAdjustCommand() {
        if (MausoleumClient.isHeadOfService() && this.ivObjectTyp == 7 && this.ivObjectID > 0L && this.ivGrantedGroupsTable.isEnabled() && !this.ivGrantedGroupsTable.ivGrantedGroupnames.isEmpty()) {
            LocusAndAlleles[] lal;
            if (this.ivAdjustLociSB == null) {
                this.ivAdjustLociSB = new StringBuilder();
            }
            this.ivAdjustLociSB.setLength(0);
            Line line = (Line)ObjectStore.getClientObject(7, this.ivObjectID, "service");
            if (line != null && (lal = (LocusAndAlleles[])line.get("LIN_LOCIALLELES")) != null) {
                int i = 0;
                while (i < lal.length) {
                    Locus locus = (Locus)ObjectStore.getClientObject(14, lal[i].ivLocusID, "service");
                    if (locus != null) {
                        Object[] grantedGroupsOfLocus = (String[])locus.get("IDO_UGROUPS");
                        Iterator iterator = this.ivGrantedGroupsTable.ivGrantedGroupnames.iterator();
                        while (iterator.hasNext()) {
                            String grantedGroup = (String)iterator.next();
                            if (grantedGroupsOfLocus != null && ArrayHelper.contained(grantedGroup, grantedGroupsOfLocus)) continue;
                            if (this.ivAdjustLociSB.length() != 0) {
                                this.ivAdjustLociSB.append("\n");
                            }
                            this.ivAdjustLociSB.append("ALLG_ATTACH_TO_SERVICE").append(" ");
                            this.ivAdjustLociSB.append(lal[i].ivLocusID).append(" ");
                            this.ivAdjustLociSB.append(Base64Manager.encodeBase64(grantedGroup)).append(" ");
                            this.ivAdjustLociSB.append(14);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    class GrantedGroupsTable
    extends SortableTable
    implements TableCellRenderer {
        private static final long serialVersionUID = 123423L;
        private MGButton ivHeaderButton = MGButton.getInspectorActionButton("", "");
        private JLabel ivListLabel = new JLabel("QqyA");
        private final HashSet ivGrantedGroupnames = new HashSet();

        public GrantedGroupsTable() {
            Vector<String> groupNames = new Vector<String>();
            if (UsergroupManager.cvInstance != null) {
                Vector v = UsergroupManager.cvInstance.getActualObjectVectorAllGroups();
                if (v != null) {
                    Iterator iter = v.iterator();
                    while (iter.hasNext()) {
                        UserGroup ug = (UserGroup)iter.next();
                        groupNames.add(ug.getName());
                    }
                }
                Collections.sort(groupNames, StringHelper.CASE_INSENSITIVE_COMPARER);
            }
            this.setObjects(groupNames);
            this.getColumnModel().getColumn(0).setPreferredWidth(100);
            this.getColumnModel().getColumn(1).setPreferredWidth(30);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setDefaultRenderer(clazz, this);
            this.getSelectionModel().setSelectionMode(2);
            this.setColumnSelectionAllowed(false);
            this.getTableHeader().setDefaultRenderer(new TableCellRenderer(this){
                final /* synthetic */ GrantedGroupsTable this$1;
                {
                    this.this$1 = grantedGroupsTable;
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    GrantedGroupsTable.access$0(this.this$1).setLabel(" " + this.this$1.getColumnName(column) + " ");
                    return GrantedGroupsTable.access$0(this.this$1);
                }
            });
            this.ivListLabel.setBackground(UIDef.SELECTED_BACKGROUND);
            this.ivListLabel.setIcon(null);
            this.setRowHeight(this.ivListLabel.getPreferredSize().height);
        }

        public void adapt(IDObject io) {
            String[] ivGroups;
            this.ivGrantedGroupnames.clear();
            if (io != null && (ivGroups = (String[])io.get("IDO_UGROUPS")) != null) {
                int i = 0;
                while (i < ivGroups.length) {
                    this.ivGrantedGroupnames.add(ivGroups[i]);
                    ++i;
                }
            }
            this.repaint();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Babel.get("GROUP");
                }
                case 1: {
                    return Babel.get("GENERAL_ACCESS");
                }
            }
            return "";
        }

        public int getRowCount() {
            if (this.ivObjects != null) {
                return this.ivObjects.size();
            }
            return 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && this.ivObjects != null && rowIndex < this.ivObjects.size()) {
                String groupName = (String)this.ivObjects.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return groupName;
                    }
                    case 1: {
                        return this.ivGrantedGroupnames.contains(groupName) ? "X" : "";
                    }
                }
            }
            return "";
        }

        public Vector fillSortablesVector(int col) {
            return null;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.ivListLabel.setHorizontalAlignment(column == 1 ? 4 : 2);
            this.ivListLabel.setText(" " + value + " ");
            this.ivListLabel.setOpaque(isSelected);
            return UIDef.highlightLabelIf(this.ivListLabel, this.ivGrantedGroupnames.contains(this.ivObjects.elementAt(row)), false);
        }

        static /* synthetic */ MGButton access$0(GrantedGroupsTable grantedGroupsTable) {
            return grantedGroupsTable.ivHeaderButton;
        }
    }
}

