/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.util.InspectorCommandSender;
import mausoleum.mouse.Mouse;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTCohortInMousInspector;
import mausoleum.ui.UIDef;

public class MouseCohortPanel
extends RequesterPane
implements LayoutManager,
ActionListener,
ObjectConsumer,
IPTabPanel {
    private static final long serialVersionUID = 6987705981716935926L;
    private static final int RAND = UIDef.getScaled(6);
    private static final int BUT_HEIGHT = UIDef.getScaled(20);
    private MGButton ivAddButton = MGButton.getInspectorActionButton(Babel.get("ADD_TO_COHORT"), "ADD_TO_COHORT");
    private MGButton ivDelButton = MGButton.getInspectorActionButton(Babel.get("REMOVE_COHORT"), "REMOVE_COHORT");
    private final Vector ivMaeuse = new Vector();
    private MausoleumTable ivCohortsTable = new MausoleumTable(new MTCohortInMousInspector(), true);

    public MouseCohortPanel() {
        super(null, "inspectorBack");
        this.setLayout(this);
        this.ivCohortsTable.ivModel.addSelectionListener(new MausoleumTableSelectionListener(){

            public void selectionChanged(MausoleumTableModel mt) {
                MouseCohortPanel.this.checkRemBut();
            }
        });
        this.add(this.ivCohortsTable.ivScrollPane);
        this.add(this.ivAddButton);
        this.add(this.ivDelButton);
        this.ivAddButton.addActionListener(this);
        this.ivDelButton.addActionListener(this);
        this.ivAddButton.setEnabled(false);
        this.ivDelButton.setEnabled(false);
        ObjectStoreClient.addConsumer((ObjectConsumer)this, 1);
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        String group;
        this.ivMaeuse.clear();
        if (idObjects != null) {
            this.ivMaeuse.addAll(idObjects);
        }
        HashSet<IDObjectGroup> cohHS = new HashSet<IDObjectGroup>();
        Iterator iter = this.ivMaeuse.iterator();
        while (iter.hasNext()) {
            long[] cohIDs;
            Mouse mouse = (Mouse)iter.next();
            group = mouse.getGroup();
            if (group == null || (cohIDs = (long[])mouse.get("MOS_COHORTS")) == null) continue;
            int i = 0;
            while (i < cohIDs.length) {
                IDObjectGroup iog = (IDObjectGroup)IDObjectGroupManager.cvInstance.getObject(new Long(cohIDs[i]), group);
                if (iog != null) {
                    cohHS.add(iog);
                }
                ++i;
            }
        }
        Vector<IDObjectGroup> cohorts = new Vector<IDObjectGroup>();
        cohorts.addAll(cohHS);
        this.ivCohortsTable.ivModel.setTable(cohorts);
        boolean addEnabled = false;
        if (Privileges.hasPrivilege("MCOH_CH_MICE") && (group = IDObject.commonGroup(this.ivMaeuse)) != null && IDObjectGroupManager.cvInstance.hasActiveObjects(group, 2)) {
            addEnabled = true;
            Iterator iter2 = this.ivMaeuse.iterator();
            while (iter2.hasNext()) {
                Mouse mouse = (Mouse)iter2.next();
                if (mouse.isTouchable()) continue;
                addEnabled = false;
            }
        }
        this.ivAddButton.setEnabled(addEnabled &= IDObject.commonGroup(this.ivMaeuse) != null);
        this.checkRemBut();
    }

    private void checkRemBut() {
        boolean delEnabled = false;
        Vector v = this.ivCohortsTable.ivModel.getSelectedObjects();
        if (v != null && !v.isEmpty()) {
            delEnabled = Privileges.hasPrivilege("MCOH_CH_MICE");
        }
        this.ivDelButton.setEnabled(delEnabled);
    }

    public void actionPerformed(ActionEvent e) {
        String group;
        String comm = e.getActionCommand();
        if (comm.equals("ADD_TO_COHORT")) {
            Vector cohorts;
            String group2;
            if (this.ivMaeuse != null && !this.ivMaeuse.isEmpty() && (group2 = IDObject.commonGroup(this.ivMaeuse)) != null && !(cohorts = IDObjectGroupManager.cvInstance.getActiveObjects(group2, 2)).isEmpty()) {
                IDObjectGroup iog;
                Vector<String> namen = new Vector<String>(cohorts.size());
                Iterator iter = cohorts.iterator();
                while (iter.hasNext()) {
                    iog = (IDObjectGroup)iter.next();
                    namen.add(iog.getName());
                }
                int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("SELECT_COHORT"), namen);
                if (ind != -1) {
                    iog = (IDObjectGroup)cohorts.elementAt(ind);
                    long cohortID = iog.getID();
                    StringBuffer msb = new StringBuffer();
                    Iterator iter2 = this.ivMaeuse.iterator();
                    while (iter2.hasNext()) {
                        Mouse mouse = (Mouse)iter2.next();
                        if (!mouse.isAliveAndVisible() || !mouse.isTouchable()) continue;
                        boolean isInCohort = false;
                        long[] cohIDs = (long[])mouse.get("MOS_COHORTS");
                        if (cohIDs != null) {
                            int i = 0;
                            while (i < cohIDs.length) {
                                if (cohortID == cohIDs[i]) {
                                    isInCohort = true;
                                }
                                ++i;
                            }
                        }
                        if (isInCohort) continue;
                        msb.append("IOGADDID").append(" ");
                        msb.append(cohortID).append(" ");
                        msb.append(1).append(" ");
                        msb.append(mouse.getID()).append("\n");
                    }
                    if (msb.length() != 0) {
                        InspectorCommandSender.executeCommand(msb.toString().toString(), group2);
                    }
                }
            }
        } else if (comm.equals("REMOVE_COHORT") && this.ivMaeuse != null && !this.ivMaeuse.isEmpty() && (group = IDObject.commonGroup(this.ivMaeuse)) != null) {
            Vector v = this.ivCohortsTable.getSelectedObjects();
            StringBuffer msb = new StringBuffer();
            Iterator cohIter = v.iterator();
            while (cohIter.hasNext()) {
                IDObjectGroup iog = (IDObjectGroup)cohIter.next();
                long cohortID = iog.getID();
                Iterator iter = this.ivMaeuse.iterator();
                while (iter.hasNext()) {
                    Mouse mouse = (Mouse)iter.next();
                    if (!mouse.isAliveAndVisible() || !mouse.isTouchable()) continue;
                    boolean isInCohort = false;
                    long[] cohIDs = (long[])mouse.get("MOS_COHORTS");
                    if (cohIDs != null) {
                        int i = 0;
                        while (i < cohIDs.length) {
                            if (cohortID == cohIDs[i]) {
                                isInCohort = true;
                            }
                            ++i;
                        }
                    }
                    if (!isInCohort) continue;
                    msb.append("IOGREMID").append(" ");
                    msb.append(cohortID).append(" ");
                    msb.append(1).append(" ");
                    msb.append(mouse.getID()).append("\n");
                }
            }
            if (msb.length() != 0) {
                InspectorCommandSender.executeCommand(msb.toString().toString(), group);
            }
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(300, 500);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(150, 300);
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int innerheight = d.height - 2 * RAND;
        int innerwidth = d.width - 2 * RAND;
        int oheight = innerheight - BUT_HEIGHT - RAND;
        int y = RAND;
        this.ivCohortsTable.ivScrollPane.setBounds(RAND, y, innerwidth, oheight);
        int anzButs = 2;
        int lbw = (innerwidth - (anzButs - 1) * RAND) / anzButs;
        int rbw = innerwidth - (anzButs - 1) * (RAND + lbw);
        int x = RAND;
        this.ivDelButton.setBounds(x, y += oheight + RAND, lbw, BUT_HEIGHT);
        this.ivAddButton.setBounds(x += lbw + RAND, y, rbw, BUT_HEIGHT);
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        Mouse maus;
        if (objectTyp == 1 && this.ivMaeuse != null && this.ivMaeuse.size() == 1 && (maus = (Mouse)this.ivMaeuse.elementAt(0)).getGroup() == group && objectIDs.contains(maus.get("IDO_ID"))) {
            this.ivMaeuse.clear();
            this.adapt(this.ivMaeuse, null, null);
        }
    }

    public void handleNewObjects(Vector idObjects) {
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            this.handleNewObject((IDObject)iterator.next());
        }
    }

    public void handleNewObject(IDObject obj) {
        boolean cfr_ignored_0 = obj instanceof IDObjectGroup;
    }
}

