/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.panels.MouseInspSpecResultPanel;
import mausoleum.mouse.Mouse;
import mausoleum.result.MResult;
import mausoleum.result.SpecialResult;
import mausoleum.result.healthreport.MResHealthCECAD;
import mausoleum.tables.models.MTSpecResHealthReportInMouseInspector;

public class MouseInspHealthReportPanel
extends MouseInspSpecResultPanel {
    private static final long serialVersionUID = 112323435L;

    public static int getDateOfLastHealthReport(Mouse maus) {
        int date = Integer.MIN_VALUE;
        Vector v2 = (Vector)maus.get("MOS_MRESULTS");
        if (v2 != null) {
            Iterator iterator = v2.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.getExperimentID() != -42L) continue;
                if (date == Integer.MIN_VALUE) {
                    date = mres.ivDate;
                    continue;
                }
                if (mres.ivDate <= date) continue;
                date = mres.ivDate;
            }
        }
        return date;
    }

    public static String getTooltipForLastHealthReport(Mouse maus) {
        MResult lastRes = null;
        int date = Integer.MIN_VALUE;
        Vector v2 = (Vector)maus.get("MOS_MRESULTS");
        if (v2 != null) {
            Iterator iterator = v2.iterator();
            while (iterator.hasNext()) {
                MResult mres = (MResult)iterator.next();
                if (mres.ivExpID != -42L) continue;
                if (date == Integer.MIN_VALUE) {
                    date = mres.ivDate;
                    lastRes = mres;
                    continue;
                }
                if (mres.ivDate <= date) continue;
                date = mres.ivDate;
                lastRes = mres;
            }
        }
        return lastRes != null ? MouseInspHealthReportPanel.getTooltip(lastRes, MResHealthCECAD.INSTANCE, maus.getGroup()) : null;
    }

    public MouseInspHealthReportPanel() {
        super(new long[]{-42L}, "ADD_HEALTH_REPORT", "DELETE_HEALTHREPORT", new MTSpecResHealthReportInMouseInspector());
    }

    public SpecialResult getSpecialResultInstanceForAddRequester() {
        return MResHealthCECAD.INSTANCE;
    }

    public SpecialResult getSpecialResultInstanceForAddRequester(long expID, int resType) {
        return this.getSpecialResultInstanceForAddRequester();
    }
}

