/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.MGButton;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.HTMLHelper;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.mouse.Mouse;
import mausoleum.requester.CopyRequester;
import mausoleum.requester.result.SpecialResultRequester;
import mausoleum.result.MResult;
import mausoleum.result.MResultWrapper;
import mausoleum.result.SpecResDetailsTable;
import mausoleum.result.SpecialResult;
import mausoleum.result.SpecialResultHelper;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTResult;
import mausoleum.ui.UIDef;

public abstract class MouseInspSpecResultPanel
extends RequesterPane
implements LayoutManager,
ActionListener,
MausoleumTableSelectionListener,
ObjectConsumer,
IPTabPanel {
    public static final String KEY_COL_BABEL = "TSG_ISSUE";
    public static final String VAL_COL_BABEL = "TSG_OBSERVATION";
    private static final long serialVersionUID = 6987705981716935926L;
    private static final int BUT_HEIGHT = UIDef.getScaled(20);
    private static final int TABLE_HEIGHT = UIDef.getScaled(110);
    protected SpecResDetailsTable ivDetailsTable = new SpecResDetailsTable();
    protected BorderPanel ivBorderPanel = new BorderPanel(new JScrollPane(this.ivDetailsTable), Babel.get("HR_DETAILS"));
    private MGButton ivAddButton = null;
    private MGButton ivDelButton = null;
    private MGButton ivEditButton = null;
    protected MGButton ivCopyButton = MGButton.getInspectorActionButton(Babel.get("COPY"), "COPYTABLE");
    private final Vector ivButtons = new Vector();
    protected Vector ivVisibleResults = null;
    protected Vector ivMaeuse = null;
    protected final MausoleumTable ivResultTable;
    protected final long[] ivAcceptedResultTypes;
    protected final String ivAddPrivilege;
    protected final String ivDelPrivilege;
    protected final String ivEditPrivilege;
    static /* synthetic */ Class class$0;

    protected static String getTooltip(MResult mres, SpecialResult specRes, String group) {
        if (specRes != null) {
            Object[] arr = SpecialResultHelper.getTableRepresentation(mres.ivResult.toString(), null, specRes, group, Babel.cvUserLangue, true, false);
            return MouseInspSpecResultPanel.getTooltip(arr);
        }
        return null;
    }

    protected static String getTooltip(Object[] arr) {
        String tooltip = null;
        if (arr != null) {
            StringBuilder msb = new StringBuilder("<HTML><body marginwidth=\"5\" marginheight=\"5\">");
            StringBuilder vsb = new StringBuilder();
            msb.append("<table>\n");
            int i = 0;
            while (i < arr.length) {
                msb.append("<tr>\n");
                String s = HTMLHelper.getTDLine("_CONT_", true, null, 0, 0, true);
                msb.append(s.replace("_CONT_", StringHelper.breakIntoHTMLLines((String)arr[i], 70, vsb)));
                String val = (String)arr[i + 1];
                if (val != null && val.length() > 500) {
                    val = String.valueOf(val.substring(0, 497)) + "...";
                }
                msb.append(s.replace("_CONT_", StringHelper.breakIntoHTMLLines(val, 70, vsb)));
                msb.append("</tr>\n");
                i += 2;
            }
            msb.append("</table>\n");
            msb.append("</body>");
            tooltip = msb.toString();
        }
        return tooltip;
    }

    public static void addSpecialResult(SpecialResult specRes, Vector mice) {
        if (specRes != null && mice != null && !mice.isEmpty()) {
            SpecialResultRequester arr = new SpecialResultRequester(Inspector.getInspector(), specRes, Mouse.getBirthDayMinimumDate(mice), mice, specRes.getTitelBabel(), Integer.MIN_VALUE, specRes.getPresetValues(mice), specRes.getPresetValuesForEachMouse(mice), specRes.wantsPerformerEditable(), null, null, null, null);
            if (arr.ivWarOK && arr.ivWarOK && arr.ivCommands != null) {
                RequestManager.sendCommandRequestAndGetAnswer(arr.ivCommands, arr.ivGroups, arr.ivExtraObjects);
                Inspector.refreshInspector();
            }
        }
    }

    public MouseInspSpecResultPanel(long[] acceptedResultTypes, String addPrivilege, String delPrivilege, MausoleumTableModel mtm) {
        this(acceptedResultTypes, addPrivilege, delPrivilege, null, mtm);
    }

    public MouseInspSpecResultPanel(long[] acceptedResultTypes, String addPrivilege, String delPrivilege, String editPrivilege, MausoleumTableModel mtm) {
        super(null, "inspectorBack");
        this.ivResultTable = new MausoleumTable(mtm, false);
        this.ivAddPrivilege = addPrivilege;
        this.ivDelPrivilege = delPrivilege;
        this.ivEditPrivilege = editPrivilege;
        this.ivAcceptedResultTypes = acceptedResultTypes;
        this.setLayout(this);
        this.ivResultTable.setIsSubdisplay();
        this.ivResultTable.ivJTable.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent e) {
                MouseInspSpecResultPanel.this.manageTooltip(e);
            }
        });
        this.ivResultTable.ivInspectorWillReact = false;
        this.ivResultTable.ivModel.addSelectionListener(this);
        this.add(this.ivResultTable);
        this.add(this.ivBorderPanel);
        this.ivButtons.clear();
        if (Privileges.hasPrivilege(this.ivAddPrivilege) || Privileges.hasPrivilege(this.ivDelPrivilege)) {
            this.ivAddButton = MGButton.getInspectorActionButton(Babel.get("HR_ADD"), "ADDRES");
            this.ivAddButton.addActionListener(this);
            this.ivAddButton.setEnabled(false);
            this.ivButtons.add(this.ivAddButton);
            this.add(this.ivAddButton);
            this.ivDelButton = MGButton.getInspectorActionButton(Babel.get("HR_REMOVE"), "DELRES");
            this.ivDelButton.addActionListener(this);
            this.ivDelButton.setEnabled(false);
            this.ivButtons.add(this.ivDelButton);
            this.add(this.ivDelButton);
        }
        if (this.ivEditPrivilege != null && Privileges.hasPrivilege(this.ivEditPrivilege)) {
            this.ivEditButton = MGButton.getInspectorActionButton(Babel.get("HR_EDIT"), "EDITRES");
            this.ivEditButton.addActionListener(this);
            this.ivEditButton.setEnabled(false);
            this.ivButtons.add(this.ivEditButton);
            this.add(this.ivEditButton);
        }
        this.ivCopyButton.addActionListener(this);
        this.ivCopyButton.setEnabled(false);
        this.ivButtons.add(this.ivCopyButton);
        this.add(this.ivCopyButton);
    }

    public abstract SpecialResult getSpecialResultInstanceForAddRequester();

    public abstract SpecialResult getSpecialResultInstanceForAddRequester(long var1, int var3);

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        this.ivMaeuse = idObjects;
        this.ivDetailsTable.ivLongStringRowNumbers.clear();
        this.ivDetailsTable.setDetails(null);
        this.ivVisibleResults = new Vector();
        boolean addEnabled = false;
        int latestDate = Integer.MIN_VALUE;
        MResultWrapper latestWrapper = null;
        if (idObjects != null && !idObjects.isEmpty()) {
            addEnabled = Privileges.hasPrivilege(this.ivAddPrivilege) && !Mouse.areMiceRoomAccesibilityRestricted(idObjects);
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                Mouse maus = (Mouse)iter.next();
                Vector v2 = (Vector)maus.get("MOS_MRESULTS");
                if (v2 == null) continue;
                Iterator iterator = v2.iterator();
                while (iterator.hasNext()) {
                    MResult mres = (MResult)iterator.next();
                    if (ArrayHelper.findLongInArray(mres.getExperimentID(), this.ivAcceptedResultTypes) == -1) continue;
                    MResultWrapper mrw = new MResultWrapper(maus, mres);
                    if (idObjects.size() == 1 && (latestDate == Integer.MIN_VALUE || mres.ivDate > latestDate)) {
                        latestDate = mres.ivDate;
                        latestWrapper = mrw;
                    }
                    this.ivVisibleResults.add(mrw);
                }
            }
        }
        this.ivResultTable.ivModel.setTable(this.ivVisibleResults);
        this.ivResultTable.ivModel.sortDefault();
        if (latestWrapper != null) {
            this.ivResultTable.ivModel.selectElement(latestWrapper);
        }
        if (this.ivAddButton != null) {
            addEnabled = this.isAddReallyAllowed(addEnabled, idObjects);
            this.ivAddButton.setEnabled(addEnabled);
        }
        this.ivCopyButton.setEnabled(!this.ivVisibleResults.isEmpty());
        this.selectionChanged(this.ivResultTable.ivModel);
    }

    public void manageTooltip(MouseEvent e) {
        String tooltip = null;
        int row = this.ivResultTable.ivJTable.rowAtPoint(e.getPoint());
        if (row != -1 && row < this.ivResultTable.ivModel.ivObjects.size()) {
            MResultWrapper wrapper = (MResultWrapper)this.ivResultTable.ivModel.ivObjects.elementAt(row);
            tooltip = MouseInspSpecResultPanel.getTooltip(wrapper.ivMresult, this.getSpecialResultInstanceForAddRequester(wrapper.ivMresult.ivExpID, wrapper.ivMresult.ivResTyp), wrapper.ivGroup);
        }
        this.ivResultTable.ivJTable.setToolTipText(tooltip);
    }

    public boolean isAddReallyAllowed(boolean addEnabledSoFar, Vector mice) {
        return addEnabledSoFar;
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("ADDRES")) {
            SpecialResult specRes;
            if (this.ivMaeuse != null && !this.ivMaeuse.isEmpty() && (specRes = this.getSpecialResultInstanceForAddRequester()) != null) {
                MouseInspSpecResultPanel.addSpecialResult(specRes, this.ivMaeuse);
            }
        } else if (comm.equals("DELRES")) {
            Vector selres = this.ivResultTable.getSelectedObjects();
            if (selres != null && !selres.isEmpty()) {
                StringBuffer msb = new StringBuffer();
                int i = 0;
                while (i < selres.size()) {
                    MResultWrapper resultWrapper = (MResultWrapper)selres.elementAt(i);
                    msb.setLength(0);
                    msb.append(CommandManagerExecutive.getServiceRoomTag(ObjectStore.getClientObject(1, resultWrapper.ivMouseID, resultWrapper.ivGroup), ""));
                    msb.append("MRES_REMOVE");
                    msb.append(" ");
                    msb.append(resultWrapper.ivMouseID);
                    msb.append(" ");
                    msb.append(resultWrapper.ivMresult.ivPseudoID);
                    RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), resultWrapper.ivGroup);
                    ++i;
                }
                Inspector.refreshInspector();
            }
        } else if (comm.equals("COPYTABLE")) {
            MTResult hrModel = (MTResult)this.ivResultTable.ivJTable.getModel();
            int anzColPT = hrModel.getColumnCount();
            Vector<String> colNames = new Vector<String>();
            int i = 0;
            while (i < anzColPT) {
                colNames.add(hrModel.getColumnName(i));
                ++i;
            }
            colNames.add(Babel.get(KEY_COL_BABEL));
            colNames.add(Babel.get(VAL_COL_BABEL));
            MausoleumTableLabel label = new MausoleumTableLabel();
            int selPrimRow = this.ivResultTable.ivJTable.getSelectedRow();
            Vector lines = new Vector();
            Vector<Integer> selLines = new Vector<Integer>();
            int primRow = 0;
            while (primRow < this.ivVisibleResults.size()) {
                boolean selected = selPrimRow == primRow;
                Vector<Object> line = new Vector<Object>(anzColPT + 2);
                if (selected) {
                    selLines.add(new Integer(lines.size()));
                }
                lines.add(line);
                MResultWrapper wrapper = (MResultWrapper)this.ivVisibleResults.elementAt(primRow);
                int col = 0;
                while (col < anzColPT) {
                    hrModel.writeTheCodedElement(label, wrapper, hrModel.getDefinedColumnName(col), false);
                    line.add(label.getText());
                    ++col;
                }
                Object[] results = this.getTableDetails(wrapper);
                if (results == null || results.length == 0) {
                    line.add("");
                    line.add("");
                } else {
                    int sline = 0;
                    while (sline < results.length) {
                        if (sline != 0) {
                            line = new Vector(anzColPT + 2);
                            int col2 = 0;
                            while (col2 < anzColPT) {
                                line.add("");
                                ++col2;
                            }
                            if (selected) {
                                selLines.add(new Integer(lines.size()));
                            }
                            lines.add(line);
                        }
                        line.add(results[sline]);
                        line.add(results[sline + 1]);
                        sline += 2;
                    }
                }
                ++primRow;
            }
            int[] selRows = null;
            if (!selLines.isEmpty()) {
                selRows = new int[selLines.size()];
                int i2 = 0;
                while (i2 < selRows.length) {
                    selRows[i2] = (Integer)selLines.elementAt(i2);
                    ++i2;
                }
            }
            HRCopyModel model = new HRCopyModel(colNames, lines);
            new CopyRequester((Frame)Inspector.getInspector(), model, model, selRows).setVisible(true);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(UIDef.getScaled(300), UIDef.getScaled(500));
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(UIDef.getScaled(150), UIDef.getScaled(300));
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int innerheight = d.height - 2 * UIDef.RAND;
        int innerwidth = d.width - 2 * UIDef.RAND;
        int uheight = innerheight - TABLE_HEIGHT - BUT_HEIGHT - 2 * UIDef.RAND;
        int y = UIDef.RAND;
        this.ivResultTable.setBounds(UIDef.RAND, y, innerwidth, TABLE_HEIGHT);
        this.ivBorderPanel.setBounds(UIDef.RAND, y += TABLE_HEIGHT + UIDef.RAND, innerwidth, uheight);
        UIDef.distributeButtons(this.ivButtons, UIDef.RAND, y += uheight + UIDef.RAND, BUT_HEIGHT, d.width - 2 * UIDef.RAND);
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        Mouse maus;
        if (objectTyp == 1 && this.ivMaeuse != null && this.ivMaeuse.size() == 1 && (maus = (Mouse)this.ivMaeuse.elementAt(0)).getGroup() == group && objectIDs.contains(maus.get("IDO_ID"))) {
            this.ivMaeuse.clear();
            this.adapt(this.ivMaeuse, null, null);
        }
    }

    public void handleNewObjects(Vector idObjects) {
    }

    public void handleNewObject(IDObject obj) {
    }

    public void selectionChanged(MausoleumTableModel mt) {
        boolean delEnabled = false;
        boolean editEnabled = false;
        this.ivDetailsTable.ivLongStringRowNumbers.clear();
        Vector v = this.ivResultTable.getSelectedObjects();
        if (v.size() != 1) {
            this.ivDetailsTable.setDetails(null);
        } else {
            MResultWrapper wrapper = (MResultWrapper)v.firstElement();
            this.ivDetailsTable.setDetails(this.getTableDetails(wrapper));
            delEnabled = Privileges.hasPrivilege(this.ivDelPrivilege);
            boolean bl = editEnabled = this.ivEditPrivilege != null && Privileges.hasPrivilege(this.ivEditPrivilege);
        }
        if (this.ivDelButton != null) {
            this.ivDelButton.setEnabled(delEnabled);
        }
        if (this.ivEditButton != null) {
            this.ivEditButton.setEnabled(editEnabled);
        }
    }

    public Object[] getTableDetails(MResultWrapper wrapper) {
        return SpecialResultHelper.getTableRepresentation((String)wrapper.ivMresult.ivResult, this.ivDetailsTable.ivLongStringRowNumbers, this.getSpecialResultInstanceForAddRequester(wrapper.ivMresult.ivExpID, wrapper.ivMresult.ivResTyp), wrapper.ivGroup, Babel.cvUserLangue, true, false);
    }

    public static class HRCopyModel
    implements TableModel,
    TableCellRenderer {
        private final Vector ivColNames;
        private final int ivColCount;
        private final Vector ivLines;
        private JLabel ivLabel = new JLabel();

        public HRCopyModel(Vector colNames, Vector lines) {
            this.ivColNames = colNames;
            this.ivColCount = colNames.size();
            this.ivLines = lines;
        }

        public Component getTableCellRendererComponent(JTable arg0, Object arg1, boolean arg2, boolean arg3, int arg4, int arg5) {
            this.ivLabel.setText(arg1.toString());
            return this.ivLabel;
        }

        public void addTableModelListener(TableModelListener arg0) {
        }

        public Class getColumnClass(int arg0) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }

        public int getColumnCount() {
            return this.ivColCount;
        }

        public String getColumnName(int arg0) {
            return (String)this.ivColNames.elementAt(arg0);
        }

        public int getRowCount() {
            return this.ivLines.size();
        }

        public Object getValueAt(int row, int col) {
            String res = "";
            if (row >= 0 && row < this.ivLines.size()) {
                Vector line = (Vector)this.ivLines.elementAt(row);
                if (col >= 0 && col < line.size()) {
                    res = (String)line.elementAt(col);
                }
            }
            return res;
        }

        public boolean isCellEditable(int arg0, int arg1) {
            return false;
        }

        public void removeTableModelListener(TableModelListener arg0) {
        }

        public void setValueAt(Object arg0, int arg1, int arg2) {
        }
    }
}

