/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mausoleum.experiment.Experiment;
import mausoleum.experiment.ExperimentManager;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.ImageComponent;
import mausoleum.gui.MGButton;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.mouse.Mouse;
import mausoleum.requester.CopyRequester;
import mausoleum.requester.result.AddResultRequester;
import mausoleum.result.GPSCoordinates;
import mausoleum.result.MResult;
import mausoleum.result.MResultWrapper;
import mausoleum.result.ResultObjectImage;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTResultInMouseInspector;
import mausoleum.ui.MausoleumTextAreaUI;
import mausoleum.ui.UIDef;
import mausoleum.windows.ImageLoaderWindow;

public class MouseResultPanel
extends RequesterPane
implements LayoutManager,
ActionListener,
MausoleumTableSelectionListener,
ObjectConsumer,
IPTabPanel {
    private static final long serialVersionUID = 6987705981716935926L;
    private static final int TABLE_HEIGHT = UIDef.getScaled(120);
    private SingleResultPanel ivSingleResultPanel = new SingleResultPanel();
    private BorderPanel ivBorderPanel = new BorderPanel(this.ivSingleResultPanel, Babel.get("RESULTDETAILS"));
    private MGButton ivAddButton = MGButton.getInspectorActionButton(Babel.get("ADDRESULT"), "ADDRES");
    private MGButton ivDelButton = MGButton.getInspectorActionButton(Babel.get("DELRESULT"), "DELRES");
    private MGButton ivCopyButton = MGButton.getInspectorActionButton(Babel.get("COPY"), "COPYTABLE");
    private Vector ivVisibleResults = null;
    private Vector ivMaeuse = null;
    private MTResultInMouseInspector ivTableModel = new MTResultInMouseInspector();
    private MausoleumTable ivResultTable = new MausoleumTable(this.ivTableModel, false);

    public static void addRes(Vector mice, long fixExperimentID) {
        if (mice != null && !mice.isEmpty()) {
            AddResultRequester arr = new AddResultRequester((Frame)Inspector.getInspector(), Mouse.getBirthDayMinimumDate(mice), mice, fixExperimentID);
            arr.setVisible(true);
            if (arr.ivWarOK && arr.ivCommands != null) {
                RequestManager.sendCommandRequestAndGetAnswer(arr.ivCommands, arr.ivGroups, arr.ivExtraObjects);
                Inspector.refreshInspector();
            }
        }
    }

    public MouseResultPanel() {
        super(null, "inspectorBack");
        this.setLayout(this);
        this.ivResultTable.setIsSubdisplay();
        this.ivResultTable.ivInspectorWillReact = false;
        this.ivResultTable.ivModel.addSelectionListener(this);
        this.add(this.ivResultTable);
        this.add(this.ivBorderPanel);
        this.add(this.ivAddButton);
        this.add(this.ivDelButton);
        this.add(this.ivCopyButton);
        this.ivAddButton.addActionListener(this);
        this.ivDelButton.addActionListener(this);
        this.ivCopyButton.addActionListener(this);
        this.ivAddButton.setEnabled(false);
        this.ivDelButton.setEnabled(false);
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        this.ivMaeuse = idObjects;
        this.ivSingleResultPanel.clear();
        this.ivVisibleResults = new Vector();
        boolean addEnabled = false;
        int latestDate = Integer.MIN_VALUE;
        MResultWrapper latestWrapper = null;
        if (idObjects != null && !idObjects.isEmpty()) {
            if (Privileges.hasPrivilege("ADD_RESULTS")) {
                String group = IDObject.commonGroup(idObjects);
                if (group != null && ExperimentManager.cvInstance.hasActualObjects(group)) {
                    addEnabled = true;
                }
                if (!addEnabled && ExperimentManager.cvInstance.hasActualObjects("service")) {
                    addEnabled = true;
                }
            }
            Iterator iter = idObjects.iterator();
            while (iter.hasNext()) {
                Mouse maus = (Mouse)iter.next();
                Vector v2 = (Vector)maus.get("MOS_MRESULTS");
                if (v2 == null) continue;
                Iterator iterator = v2.iterator();
                while (iterator.hasNext()) {
                    MResult mres = (MResult)iterator.next();
                    if (!MResult.isRegularResult(mres)) continue;
                    MResultWrapper mrw = new MResultWrapper(maus, mres);
                    if (idObjects.size() == 1 && (latestDate == Integer.MIN_VALUE || mres.ivDate > latestDate)) {
                        latestDate = mres.ivDate;
                        latestWrapper = mrw;
                    }
                    this.ivVisibleResults.add(mrw);
                }
            }
        }
        this.ivResultTable.ivModel.setTable(this.ivVisibleResults);
        this.ivResultTable.ivModel.sortDefault();
        if (latestWrapper != null) {
            this.ivResultTable.ivModel.selectElement(latestWrapper);
        }
        this.ivAddButton.setEnabled(addEnabled);
        this.selectionChanged(this.ivResultTable.ivModel);
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("ADDRES")) {
            MouseResultPanel.addRes(this.ivMaeuse, -1L);
        } else if (comm.equals("DELRES")) {
            Vector selres = this.ivResultTable.getSelectedObjects();
            if (selres != null && !selres.isEmpty()) {
                StringBuffer msb = new StringBuffer();
                int i = 0;
                while (i < selres.size()) {
                    MResultWrapper r = (MResultWrapper)selres.elementAt(i);
                    if (i != 0) {
                        msb.append("\n");
                    }
                    msb.append(CommandManagerExecutive.getServiceRoomTag(ObjectStore.getClientObject(1, r.ivMouseID, r.ivGroup), ""));
                    msb.append("MRES_REMOVE");
                    msb.append(" ");
                    msb.append(r.ivMouseID);
                    msb.append(" ");
                    msb.append(r.ivMresult.ivPseudoID);
                    ++i;
                }
                RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), UserManager.getFirstGroup());
                Inspector.refreshInspector();
            }
        } else if (comm.equals("COPYTABLE")) {
            new CopyRequester((Frame)Inspector.getInspector(), this.ivTableModel, this.ivTableModel, this.ivTableModel.getSelectRowsAsArray()).setVisible(true);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(300, 500);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(150, 300);
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int innerheight = d.height - 2 * UIDef.INNER_RAND;
        int innerwidth = d.width - 2 * UIDef.INNER_RAND;
        int uheight = innerheight - TABLE_HEIGHT - UIDef.BUT_HEIGHT - 2 * UIDef.INNER_RAND;
        int y = UIDef.INNER_RAND;
        this.ivResultTable.setBounds(UIDef.INNER_RAND, y, innerwidth, TABLE_HEIGHT);
        this.ivBorderPanel.setBounds(UIDef.INNER_RAND, y += TABLE_HEIGHT + UIDef.INNER_RAND, innerwidth, uheight);
        int rlwidth = (d.width - 4 * UIDef.INNER_RAND) / 3;
        int x = UIDef.INNER_RAND;
        this.ivDelButton.setBounds(x, y += uheight + UIDef.INNER_RAND, rlwidth, UIDef.BUT_HEIGHT);
        this.ivAddButton.setBounds(x += rlwidth + UIDef.INNER_RAND, y, rlwidth, UIDef.BUT_HEIGHT);
        this.ivCopyButton.setBounds(x += rlwidth + UIDef.INNER_RAND, y, rlwidth, UIDef.BUT_HEIGHT);
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        Mouse maus;
        if (objectTyp == 1 && this.ivMaeuse != null && this.ivMaeuse.size() == 1 && (maus = (Mouse)this.ivMaeuse.elementAt(0)).getGroup() == group && objectIDs.contains(maus.get("IDO_ID"))) {
            this.ivMaeuse.clear();
            this.adapt(this.ivMaeuse, null, null);
        }
    }

    public void handleNewObjects(Vector idObjects) {
    }

    public void handleNewObject(IDObject obj) {
    }

    public void selectionChanged(MausoleumTableModel mt) {
        boolean delEnabled = false;
        Vector v = this.ivResultTable.getSelectedObjects();
        if (v.size() != 1) {
            this.ivSingleResultPanel.adaptToResult(null);
        } else {
            this.ivSingleResultPanel.adaptToResult((MResultWrapper)v.elementAt(0));
            delEnabled = Privileges.hasPrivilege("DELETE_RESULTS");
        }
        this.ivDelButton.setEnabled(delEnabled);
    }

    class SingleResultPanel
    extends JPanel {
        private static final long serialVersionUID = 5059129708388511262L;
        private static final int MARGIN = 6;
        private JLabel ivResultLabel = new JLabel();
        private JTextArea ivResultTextArea = new JTextArea();
        private JScrollPane ivScrollPane = new JScrollPane(this.ivResultTextArea);
        private JTextArea ivImageTextArea = new JTextArea();
        private JScrollPane ivImageScrollPane = new JScrollPane(this.ivImageTextArea);
        private ImageComponent ivImageComponent = new ImageComponent();
        private JPanel ivImageContainer = new JPanel();
        private JLabel ivGPSLabel = new JLabel();
        private MGButton ivShowGPSButton = new MGButton(Babel.get("SHOWLOCATIONONMAP"));
        private JPanel ivGPSContainer = new JPanel(new BorderLayout(0, 4));
        private Component ivVisibleComponent = null;
        private MResultWrapper ivActResultWrapper = null;

        public SingleResultPanel() {
            this.setLayout(new SimpleLayoutManager(this){
                final /* synthetic */ SingleResultPanel this$1;
                {
                    this.this$1 = singleResultPanel;
                }

                public void layoutContainer(Container parent) {
                    Dimension d = parent.getSize();
                    SingleResultPanel.access$0(this.this$1).setBounds(0, 0, d.width, d.height);
                    SingleResultPanel.access$1(this.this$1).setBounds(0, 0, d.width, d.height);
                    SingleResultPanel.access$2(this.this$1).setBounds(0, 0, d.width, d.height);
                    SingleResultPanel.access$3(this.this$1).setBounds(0, 0, d.width, d.height);
                    int icwh = 76;
                    SingleResultPanel.access$4(this.this$1).setBounds(0, 0, icwh, icwh);
                    SingleResultPanel.access$5(this.this$1).setBounds(icwh + 6, 0, d.width - icwh - 6, icwh);
                }
            });
            this.setOpaque(false);
            this.ivResultLabel.setOpaque(false);
            this.ivResultLabel.setForeground(Color.black);
            this.ivResultLabel.setFont(FontManager.getFont("SSB16"));
            this.ivResultLabel.setHorizontalAlignment(0);
            this.ivResultTextArea.setEnabled(false);
            this.ivResultTextArea.setEditable(false);
            this.ivResultTextArea.setFont(FontManager.getFont("SSB12"));
            this.ivResultTextArea.setDisabledTextColor(Color.black);
            this.ivResultTextArea.setMargin(new Insets(4, 4, 4, 4));
            this.ivResultTextArea.setLineWrap(true);
            this.ivResultTextArea.setWrapStyleWord(true);
            if (this.ivResultTextArea.getUI() instanceof MausoleumTextAreaUI) {
                ((MausoleumTextAreaUI)this.ivResultTextArea.getUI()).setImageKey("inspectorBack");
            }
            this.ivImageTextArea.setEnabled(false);
            this.ivImageTextArea.setEditable(false);
            this.ivImageTextArea.setFont(FontManager.getFont("SSB12"));
            this.ivImageTextArea.setDisabledTextColor(Color.black);
            this.ivImageTextArea.setMargin(new Insets(4, 4, 4, 4));
            this.ivImageTextArea.setLineWrap(true);
            this.ivImageTextArea.setWrapStyleWord(true);
            if (this.ivImageTextArea.getUI() instanceof MausoleumTextAreaUI) {
                ((MausoleumTextAreaUI)this.ivImageTextArea.getUI()).setImageKey("inspectorBack");
            }
            this.ivImageContainer.setLayout(null);
            this.ivImageContainer.setOpaque(false);
            this.ivImageContainer.add(this.ivImageScrollPane);
            this.ivImageComponent.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ SingleResultPanel this$1;
                {
                    this.this$1 = singleResultPanel;
                }

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && SingleResultPanel.access$6(this.this$1) != null && SingleResultPanel.access$6((SingleResultPanel)this.this$1).ivMresult.ivResTyp == 6) {
                        new ImageLoaderWindow(SingleResultPanel.access$6(this.this$1));
                    }
                }
            });
            this.ivImageContainer.add(this.ivImageComponent);
            this.ivGPSLabel.setOpaque(false);
            this.ivGPSLabel.setForeground(Color.black);
            this.ivGPSLabel.setFont(FontManager.getFont("SSB16"));
            this.ivGPSLabel.setHorizontalAlignment(0);
            this.ivGPSContainer.add("Center", this.ivGPSLabel);
            this.ivShowGPSButton.addActionListener(new ActionListener(this){
                final /* synthetic */ SingleResultPanel this$1;
                {
                    this.this$1 = singleResultPanel;
                }

                public void actionPerformed(ActionEvent e) {
                    Object ooo;
                    if (SingleResultPanel.access$6(this.this$1) != null && (ooo = SingleResultPanel.access$6((SingleResultPanel)this.this$1).ivMresult.ivResult) instanceof GPSCoordinates) {
                        GPSCoordinates gpsCoor = (GPSCoordinates)ooo;
                        gpsCoor.showMap();
                    }
                }
            });
            this.ivGPSContainer.add("South", this.ivShowGPSButton);
            this.ivGPSContainer.setOpaque(false);
        }

        public void clear() {
            this.ivResultLabel.setText("");
            this.ivResultLabel.setIcon(null);
            this.ivResultTextArea.setText("");
            this.setVisibleComponent(null);
        }

        public void adaptToResult(MResultWrapper res) {
            this.ivActResultWrapper = res;
            if (this.ivActResultWrapper == null) {
                this.clear();
                return;
            }
            Experiment exp = this.ivActResultWrapper.getExperiment();
            if (this.ivActResultWrapper.ivMresult.ivResult == null) {
                this.setVisibleComponent(null);
                return;
            }
            switch (exp.getInt("EXP_TYPE")) {
                case 1: {
                    Boolean b = (Boolean)this.ivActResultWrapper.ivMresult.ivResult;
                    if (b.booleanValue()) {
                        this.ivResultLabel.setText(Babel.get("TRUE"));
                    } else {
                        this.ivResultLabel.setText(Babel.get("FALSE"));
                    }
                    this.ivResultLabel.setIcon(null);
                    this.setVisibleComponent(this.ivResultLabel);
                    break;
                }
                case 2: {
                    Integer inti = (Integer)this.ivActResultWrapper.ivMresult.ivResult;
                    if (exp.getString("EXP_UNIT") != null) {
                        this.ivResultLabel.setText(String.valueOf(Integer.toString(inti)) + " " + exp.getString("EXP_UNIT"));
                    } else {
                        this.ivResultLabel.setText(Integer.toString(inti));
                    }
                    this.ivResultLabel.setIcon(null);
                    this.setVisibleComponent(this.ivResultLabel);
                    break;
                }
                case 3: {
                    Double doubli = (Double)this.ivActResultWrapper.ivMresult.ivResult;
                    if (exp.getString("EXP_UNIT") != null) {
                        this.ivResultLabel.setText(String.valueOf(Double.toString(doubli)) + " " + exp.getString("EXP_UNIT"));
                    } else {
                        this.ivResultLabel.setText(Double.toString(doubli));
                    }
                    this.ivResultLabel.setIcon(null);
                    this.setVisibleComponent(this.ivResultLabel);
                    break;
                }
                case 4: {
                    this.ivResultLabel.setText((String)this.ivActResultWrapper.ivMresult.ivResult);
                    this.ivResultLabel.setIcon(null);
                    this.setVisibleComponent(this.ivResultLabel);
                    break;
                }
                case 5: {
                    this.ivResultTextArea.setText((String)this.ivActResultWrapper.ivMresult.ivResult);
                    this.ivResultTextArea.setCaretPosition(0);
                    this.ivResultLabel.setText("");
                    this.ivResultLabel.setIcon(null);
                    this.setVisibleComponent(this.ivScrollPane);
                    break;
                }
                case 6: {
                    ResultObjectImage roi = (ResultObjectImage)this.ivActResultWrapper.ivMresult.ivResult;
                    this.ivImageTextArea.setText(Base64Manager.getDecodedString(roi.ivComment));
                    this.ivImageTextArea.setCaretPosition(0);
                    if (roi.ivImage == null) {
                        roi.ivImage = this.createImage(new MemoryImageSource(roi.ivThumbDim.width, roi.ivThumbDim.height, roi.ivThumbData, 0, roi.ivThumbDim.width));
                    }
                    this.ivImageComponent.setImage(roi.ivImage);
                    this.setVisibleComponent(this.ivImageContainer);
                    break;
                }
                case 7: {
                    GPSCoordinates gpsCoor = (GPSCoordinates)this.ivActResultWrapper.ivMresult.ivResult;
                    this.ivGPSLabel.setText(gpsCoor.getTableString());
                    this.ivGPSLabel.setIcon(null);
                    this.setVisibleComponent(this.ivGPSContainer);
                    break;
                }
                case 8: {
                    this.ivResultLabel.setText("");
                    this.ivResultLabel.setIcon(null);
                    this.setVisibleComponent(this.ivResultLabel);
                }
            }
        }

        private void setVisibleComponent(Component c) {
            if (this.ivVisibleComponent != c) {
                if (this.ivVisibleComponent != null) {
                    this.remove(this.ivVisibleComponent);
                }
                this.ivVisibleComponent = c;
                if (this.ivVisibleComponent != null) {
                    this.add(this.ivVisibleComponent);
                }
                this.validate();
                this.repaint();
            }
        }

        static /* synthetic */ JLabel access$0(SingleResultPanel singleResultPanel) {
            return singleResultPanel.ivResultLabel;
        }

        static /* synthetic */ JScrollPane access$1(SingleResultPanel singleResultPanel) {
            return singleResultPanel.ivScrollPane;
        }

        static /* synthetic */ JPanel access$2(SingleResultPanel singleResultPanel) {
            return singleResultPanel.ivImageContainer;
        }

        static /* synthetic */ JPanel access$3(SingleResultPanel singleResultPanel) {
            return singleResultPanel.ivGPSContainer;
        }

        static /* synthetic */ ImageComponent access$4(SingleResultPanel singleResultPanel) {
            return singleResultPanel.ivImageComponent;
        }

        static /* synthetic */ JScrollPane access$5(SingleResultPanel singleResultPanel) {
            return singleResultPanel.ivImageScrollPane;
        }

        static /* synthetic */ MResultWrapper access$6(SingleResultPanel singleResultPanel) {
            return singleResultPanel.ivActResultWrapper;
        }
    }
}

