/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import mausoleum.cage.colors.ColorMode;
import mausoleum.gui.MusterColor;
import mausoleum.helper.FontManager;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.idobjectgroup.IDObjectGroupManager;
import mausoleum.mouse.Mouse;
import mausoleum.ui.UIDef;
import mausoleum.usergroup.UserGroup;

public class OwnerListRenderer
implements ListCellRenderer,
ObjectConsumer {
    private static final int CELL_HEIGHT = UIDef.getScaled(20);
    private static final Color[] COLORS = new Color[]{UIDef.GREEN_COLOR, UIDef.YELLOW_COLOR, UIDef.PINK_COLOR, UIDef.BLUE_COLOR, UIDef.PURPLE_COLOR, UIDef.GRAY_COLOR};
    private static String[] BABELS = new String[]{"OWNER_TT_ALL_DIR", "OWNER_TT_ALL_DIR_AND_INDIR", "OWNER_TT_ALL_INDIR", "OWNER_TT_NOT_ALL_DIR", "OWNER_TT_NOT_ALL_DIR_AND_INDIR", "OWNER_TT_NOT_ALL_INDIR"};
    private static final HashMap OWNER_MERKER_BY_GROUP = new HashMap();
    private JList ivList = null;
    private final Vector ivListData = new Vector();
    private final OwnerTafel ivOwnerTafel = new OwnerTafel();

    public OwnerListRenderer(JList list) {
        this.ivList = list;
        StringBuffer msb = new StringBuffer("<HTML><body marginwidth=\"5\" marginheight=\"5\">");
        msb.append(ColorMode.createHTML(COLORS, BABELS, true, 0));
        msb.append("</body>");
        this.ivList.setToolTipText(msb.toString());
        this.ivList.setFixedCellHeight(CELL_HEIGHT);
    }

    public void setToNonApplicable() {
        this.adaptToMouseVector(null);
    }

    public void adaptToMouseVector(Vector v) {
        String commonGroup;
        this.ivListData.clear();
        if (v != null && !v.isEmpty() && (commonGroup = IDObject.commonGroup(v)) != null) {
            OwnerMerker om;
            HashMap[] hm = this.getMerker(commonGroup, v.size());
            HashMap userMerker = hm[0];
            HashMap userGroupmerker = hm[1];
            Iterator<Object> iter = v.iterator();
            while (iter.hasNext()) {
                OwnerMerker om2;
                Mouse mausi = (Mouse)iter.next();
                long[] owners = (long[])mausi.get("MOS_OWNER");
                long[] ownerGroups = (long[])mausi.get("MOS_OWNERGROUPS");
                if (owners == null && ownerGroups == null) {
                    Iterator iterator = userMerker.values().iterator();
                    while (iterator.hasNext()) {
                        om2 = (OwnerMerker)iterator.next();
                        ++om2.ivIndirect;
                    }
                    continue;
                }
                if (owners != null) {
                    int j = 0;
                    while (j < owners.length) {
                        om2 = (OwnerMerker)userMerker.get(new Long(owners[j]));
                        if (om2 != null) {
                            ++om2.ivDirect;
                            if (j == 0) {
                                ++om2.ivPrimaer;
                            }
                        }
                        ++j;
                    }
                }
                if (ownerGroups == null) continue;
                int j = 0;
                while (j < ownerGroups.length) {
                    om2 = (OwnerMerker)userGroupmerker.get(new Long(ownerGroups[j]));
                    if (om2 != null) {
                        ++om2.ivDirect;
                    }
                    ++j;
                }
            }
            iter = userMerker.values().iterator();
            while (iter.hasNext()) {
                om = (OwnerMerker)iter.next();
                if (om.ivDirect + om.ivIndirect == 0) continue;
                this.ivListData.addElement(om);
            }
            iter = userGroupmerker.values().iterator();
            while (iter.hasNext()) {
                om = (OwnerMerker)iter.next();
                if (om.ivDirect == 0) continue;
                this.ivListData.addElement(om);
            }
            Collections.sort(this.ivListData);
        }
        this.ivList.setListData(this.ivListData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap[] getMerker(String group, int potential) {
        HashMap hashMap = OWNER_MERKER_BY_GROUP;
        synchronized (hashMap) {
            HashMap[] merker = (HashMap[])OWNER_MERKER_BY_GROUP.get(group);
            if (merker == null) {
                merker = new HashMap[]{new HashMap(), new HashMap()};
                HashMap userMerker = merker[0];
                Vector w = UserManager.getActualObjects(group);
                Iterator iter = w.iterator();
                while (iter.hasNext()) {
                    User usi = (User)iter.next();
                    if (!usi.isAliveAndVisible() || !Privileges.hasPrivilege(usi, "CAN_OWN")) continue;
                    userMerker.put(usi.get("IDO_ID"), new OwnerMerker(usi.getName(), potential, (Color)usi.get("USR_COLOR")));
                }
                HashMap userGroupmerker = merker[1];
                w = IDObjectGroupManager.getActualObjectsOfType(group, 1);
                Iterator iter2 = w.iterator();
                while (iter2.hasNext()) {
                    IDObjectGroup iog = (IDObjectGroup)iter2.next();
                    if (!iog.isAliveAndVisible()) continue;
                    userGroupmerker.put(iog.get("IDO_ID"), new OwnerMerker("[" + iog.getName() + "]", potential, (Color)iog.get("IOG_COL")));
                }
            } else {
                int i = 0;
                while (i < merker.length) {
                    Iterator iter = merker[i].values().iterator();
                    while (iter.hasNext()) {
                        OwnerMerker om = (OwnerMerker)iter.next();
                        om.clear(potential);
                    }
                    ++i;
                }
            }
            return merker;
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        OwnerMerker om = (OwnerMerker)value;
        if (om.ivPrimaer != 0) {
            this.ivOwnerTafel.setText(" " + om.ivName + " * ");
        } else {
            this.ivOwnerTafel.setText(" " + om.ivName + " ");
        }
        this.ivOwnerTafel.setBackground(om.getColor());
        this.ivOwnerTafel.ivFcolor = om.ivColor;
        return this.ivOwnerTafel;
    }

    public void handleNewObjects(Vector idObjects) {
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            this.handleNewObject((IDObject)iterator.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewObject(IDObject obj) {
        if (obj instanceof User || obj instanceof UserGroup) {
            HashMap hashMap = OWNER_MERKER_BY_GROUP;
            synchronized (hashMap) {
                OWNER_MERKER_BY_GROUP.remove(obj.getGroup());
            }
        }
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
    }

    private static class OwnerMerker
    implements Comparable {
        public final String ivName;
        public final Color ivColor;
        public int ivPrimaer = 0;
        public int ivDirect = 0;
        public int ivIndirect = 0;
        public final int ivPotential;

        public OwnerMerker(String name, int potential, Color col) {
            this.ivName = name;
            this.ivPotential = potential;
            this.ivColor = col == null ? UIDef.OBJECT_DEFAULT_COLOR : col;
        }

        public void clear(int potential) {
            this.ivPrimaer = 0;
            this.ivDirect = 0;
            this.ivIndirect = 0;
        }

        public Color getColor() {
            int status = COLORS.length - 1;
            if (this.ivDirect == this.ivPotential) {
                status = 0;
            } else if (this.ivIndirect == this.ivPotential) {
                status = 2;
            } else if (this.ivDirect + this.ivIndirect == this.ivPotential) {
                status = 1;
            } else if (this.ivDirect != 0 && this.ivIndirect == 0) {
                status = 3;
            } else if (this.ivDirect != 0 && this.ivIndirect != 0) {
                status = 4;
            } else if (this.ivDirect == 0 && this.ivIndirect != 0) {
                status = 5;
            }
            return COLORS[status];
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof OwnerMerker) {
                OwnerMerker om = (OwnerMerker)arg0;
                if (this.ivPrimaer < om.ivPrimaer) {
                    return 1;
                }
                if (this.ivPrimaer > om.ivPrimaer) {
                    return -1;
                }
                if (this.ivDirect < om.ivDirect) {
                    return 1;
                }
                if (this.ivDirect > om.ivDirect) {
                    return -1;
                }
                if (this.ivIndirect < om.ivIndirect) {
                    return 1;
                }
                if (this.ivIndirect > om.ivIndirect) {
                    return -1;
                }
                return this.ivName.compareToIgnoreCase(om.ivName);
            }
            return 0;
        }
    }

    private static class OwnerTafel
    extends JLabel {
        private static final long serialVersionUID = 143843863L;
        public Color ivFcolor = null;

        private OwnerTafel() {
            this.setFont(FontManager.getFont("SSB12"));
            this.setOpaque(true);
            this.setBorder(new BevelBorder(0));
        }

        public void paint(Graphics g) {
            Dimension d = this.getSize();
            Color bg = this.getBackground();
            if (bg != null) {
                g.setColor(bg);
                g.fillRect(0, 0, d.width, d.height);
            }
            int fh = d.height - 2;
            if (this.ivFcolor != null) {
                int o = 4;
                int wh = d.height - 2 * o;
                if (this.ivFcolor instanceof MusterColor) {
                    MusterColor mc = (MusterColor)this.ivFcolor;
                    mc.fill(o, o, wh, wh, g);
                } else {
                    g.setColor(this.ivFcolor);
                    g.fillRect(o, o, wh, wh);
                }
                g.setColor(Color.black);
                g.drawLine(o, o, o, o + wh - 1);
                g.drawLine(o, o, o + wh - 1, o);
                g.setColor(Color.white);
                g.drawLine(o + wh - 1, o + wh - 1, o, o + wh - 1);
                g.drawLine(o + wh - 1, o + wh - 1, o + wh - 1, o);
            }
            int x = 2 + fh + 2;
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics(f);
            fm.getMaxAscent();
            int ma = fm.getMaxAscent();
            int md = fm.getMaxDescent();
            int gesh = ma + md;
            int obka = (d.height - gesh) / 2;
            int y = obka + ma - 1;
            g.setColor(this.getForeground());
            g.drawString(this.getText(), x, y);
            super.paintBorder(g);
        }
    }
}

