/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.SimpleLayoutManager;
import mausoleum.inspector.InspectorActionButton;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.panels.OwnerListRenderer;
import mausoleum.main.MausoleumClient;
import mausoleum.ui.UIDef;

public class OwnerPanel
extends RequesterPane
implements IPTabPanel {
    private static final long serialVersionUID = 0x112333L;
    private static final int OWNER_BUT_MAX_HEIGHT = UIDef.BUT_HEIGHT;
    private static final int OWNER_BUT_INTER_RAND = UIDef.INNER_RAND;
    private final Vector ivButtons = new Vector();
    private OwnerListRenderer ivOwnerRenderer = null;

    public OwnerPanel(HashMap actionButtons) {
        super((LayoutManager)new GridLayout(1, 2, UIDef.getScaled(4), UIDef.getScaled(4)), "inspectorBack");
        this.setOpaque(false);
        JList tjl = new JList();
        this.ivOwnerRenderer = new OwnerListRenderer(tjl);
        tjl.setCellRenderer(this.ivOwnerRenderer);
        JScrollPane tjsp = new JScrollPane(tjl);
        tjsp.getViewport().setOpaque(true);
        tjl.setOpaque(false);
        this.add(tjsp);
        JPanel mpr = new JPanel();
        mpr.setOpaque(false);
        this.add(mpr);
        if (MausoleumClient.isRegular()) {
            this.addButton("MA_OWNER_ME", actionButtons, mpr);
            this.addButton("MA_OWNER_ALL", actionButtons, mpr);
            this.addButton("MA_OWNER_SHARE_USER", actionButtons, mpr);
            this.addButton("MA_OWNER_SHARE_OWNERGROUP", actionButtons, mpr);
            this.addButton("MA_OWNER_REMOVE", actionButtons, mpr);
        }
        if (MausoleumClient.isRegular() || MausoleumClient.isServiceCaretaker()) {
            this.addButton("MA_OWNER_SET_USER", actionButtons, mpr);
            this.addButton("MA_OWNER_SET_OWNERGROUP", actionButtons, mpr);
            this.addButton("MA_OWNER_SET_PRIMARY", actionButtons, mpr);
        }
        mpr.setLayout(new SimpleLayoutManager(){

            public void layoutContainer(Container parent) {
                Dimension d = parent.getSize();
                int x = 0;
                int y = 0;
                int anzrows = OwnerPanel.this.ivButtons.size();
                int onlybut = parent.getSize().height - (anzrows - 1) * OWNER_BUT_INTER_RAND;
                int nbh = OWNER_BUT_MAX_HEIGHT;
                int lbh = OWNER_BUT_MAX_HEIGHT;
                if (onlybut < anzrows * OWNER_BUT_MAX_HEIGHT) {
                    nbh = onlybut / anzrows;
                    lbh = onlybut - (anzrows - 1) * nbh;
                }
                Iterator iterator = OwnerPanel.this.ivButtons.iterator();
                while (iterator.hasNext()) {
                    JComponent but = (JComponent)iterator.next();
                    if (iterator.hasNext()) {
                        but.setBounds(x, y, d.width, nbh);
                        y += nbh + OWNER_BUT_INTER_RAND;
                        continue;
                    }
                    but.setBounds(x, y, d.width, lbh);
                }
            }
        });
    }

    private void addButton(String command, HashMap actionButtons, JPanel mpr) {
        this.ivButtons.add(InspectorActionButton.createButton(command, actionButtons, mpr));
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        this.ivOwnerRenderer.adaptToMouseVector(idObjects);
    }
}

