/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.panels;

import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.table.TableCellRenderer;
import mausoleum.gui.BorderPanel;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MGButton;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.gui.RequesterPane;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.panels.IPTabPanel;
import mausoleum.inspector.panels.MouseInspSpecResultPanel;
import mausoleum.rack.Rack;
import mausoleum.requester.CopyRequester;
import mausoleum.requester.result.RackHealthReportGeneralsRequester;
import mausoleum.requester.result.RackHealthReportRacksRequester;
import mausoleum.result.SpecResDetailsTable;
import mausoleum.result.rackhealthreport.RResHealthReport;
import mausoleum.result.rackhealthreport.RResWrapper;
import mausoleum.tables.MausoleumTable;
import mausoleum.tables.MausoleumTableModel;
import mausoleum.tables.MausoleumTableSelectionListener;
import mausoleum.tables.models.MTRackHealthReport;
import mausoleum.ui.UIDef;

public class RackInspHealthResultPanel
extends RequesterPane
implements LayoutManager,
ActionListener,
MausoleumTableSelectionListener,
ObjectConsumer,
IPTabPanel {
    public static final String KEY_COL_BABEL = "TSG_ISSUE";
    public static final String VAL_COL_BABEL = "TSG_OBSERVATION";
    private static final long serialVersionUID = 6987705981716935926L;
    private static final int BUT_HEIGHT = UIDef.getScaled(20);
    private static final int TABLE_HEIGHT = UIDef.getScaled(110);
    private static final String ADD_PRIVILEGE = "RCK_ADD_HEALTH_REPORT";
    private static final String DEL_PRIVILEGE = "RCK_DELETE_HEALTHREPORT";
    private static final String EDIT_PRIVILEGE = "RCK_EDIT_HEALTHREPORT";
    private RHDetailsTable ivDetailsTable = new RHDetailsTable();
    private JTextPane ivDetailsPane = new JTextPane();
    private JScrollPane ivDetailsScrollPane = new JScrollPane(this.ivDetailsPane);
    protected BorderPanel ivBorderPanel = null;
    private MGButton ivAddButton = null;
    private MGButton ivDelButton = null;
    protected MGButton ivCopyButton = MGButton.getInspectorActionButton(Babel.get("COPY"), "COPYTABLE");
    protected MGButton ivEditButton = null;
    private final Vector ivVisibleResults = new Vector();
    private Vector ivRacks = null;
    private final MausoleumTable ivResultTable = new MausoleumTable(new MTRackHealthReport(), false);
    static /* synthetic */ Class class$0;

    public static void addSpecialResult(Vector racks) {
        if (racks != null && !racks.isEmpty()) {
            RackHealthReportGeneralsRequester req = new RackHealthReportGeneralsRequester(Inspector.getInspector());
            if (req.ivWarOK) {
                RackHealthReportGeneralsRequester.GeneralMicroorganismResult gmr = req.ivResult;
                RackHealthReportRacksRequester req2 = new RackHealthReportRacksRequester(Inspector.getInspector(), gmr, racks, null, false);
                if (req2.ivWarOK) {
                    RackInspHealthResultPanel.addTheResults(req2, gmr);
                    RResHealthReport.init();
                    Inspector.refreshInspector();
                }
            }
        }
    }

    private static void addTheResults(RackHealthReportRacksRequester req2, RackHealthReportGeneralsRequester.GeneralMicroorganismResult gmr) {
        HashMap initStringsByRack = new HashMap();
        req2.fillInitStrings(initStringsByRack, gmr);
        StringBuilder msb = new StringBuilder();
        Iterator iterator = initStringsByRack.keySet().iterator();
        while (iterator.hasNext()) {
            Rack rack = (Rack)iterator.next();
            msb.append("RADDRES").append(" ");
            msb.append(rack.getID()).append(" ");
            msb.append(initStringsByRack.get(rack));
            if (!iterator.hasNext()) continue;
            msb.append("\n");
        }
        RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), "service");
    }

    public RackInspHealthResultPanel() {
        super(null, "inspectorBack");
        this.setLayout(this);
        this.ivResultTable.setIsSubdisplay();
        this.ivResultTable.ivInspectorWillReact = false;
        this.ivResultTable.ivModel.addSelectionListener(this);
        this.add(this.ivResultTable);
        this.ivDetailsPane.setForeground(Color.black);
        this.ivDetailsPane.setBackground(Color.white);
        this.ivDetailsPane.setFont(FontManager.getFont("SSB12"));
        this.ivDetailsPane.setEditable(false);
        this.ivDetailsPane.setDisabledTextColor(Color.black);
        this.ivDetailsScrollPane.setPreferredSize(new Dimension(100, UIDef.getScaled(40)));
        JPanel pan = new JPanel(new BorderLayout(UIDef.INNER_RAND, UIDef.INNER_RAND));
        pan.setOpaque(false);
        pan.add("Center", new JScrollPane(this.ivDetailsTable));
        pan.add("South", this.ivDetailsScrollPane);
        this.ivBorderPanel = new BorderPanel(pan, Babel.get("HR_DETAILS"));
        this.add(this.ivBorderPanel);
        if (Privileges.hasPrivilege(ADD_PRIVILEGE)) {
            this.ivAddButton = MGButton.getInspectorActionButton(Babel.get("HR_ADD"), "ADDRES");
            this.ivAddButton.addActionListener(this);
            this.ivAddButton.setEnabled(false);
            this.add(this.ivAddButton);
        }
        if (Privileges.hasPrivilege(EDIT_PRIVILEGE)) {
            this.ivEditButton = MGButton.getInspectorActionButton(Babel.get("HR_EDIT"), "EDITRES");
            this.ivEditButton.addActionListener(this);
            this.ivEditButton.setEnabled(false);
            this.add(this.ivEditButton);
        }
        if (Privileges.hasPrivilege(DEL_PRIVILEGE)) {
            this.ivDelButton = MGButton.getInspectorActionButton(Babel.get("HR_REMOVE"), "DELRES");
            this.ivDelButton.addActionListener(this);
            this.ivDelButton.setEnabled(false);
            this.add(this.ivDelButton);
        }
        this.ivCopyButton.addActionListener(this);
        this.ivCopyButton.setEnabled(false);
        this.add(this.ivCopyButton);
    }

    public void adapt(Vector idObjects, Vector mice, Vector changeSensitives) {
        this.ivRacks = idObjects;
        this.ivDetailsTable.ivLongStringRowNumbers.clear();
        this.ivDetailsTable.setDetails(null);
        this.ivDetailsPane.setText("");
        this.ivVisibleResults.clear();
        boolean addEnabled = false;
        RResWrapper latestWrapper = null;
        if (idObjects != null && !idObjects.isEmpty()) {
            addEnabled = Privileges.hasPrivilege(ADD_PRIVILEGE);
            RResHealthReport.addHealthReportWrappers(idObjects, this.ivVisibleResults);
            int latesDate = Integer.MIN_VALUE;
            Iterator iterator = this.ivVisibleResults.iterator();
            while (iterator.hasNext()) {
                RResWrapper wrp = (RResWrapper)iterator.next();
                if (wrp.ivHealthReport.ivDate <= latesDate) continue;
                latesDate = wrp.ivHealthReport.ivDate;
                latestWrapper = wrp;
            }
        }
        this.ivResultTable.ivModel.setTable(this.ivVisibleResults);
        this.ivResultTable.ivModel.sortDefault();
        if (latestWrapper != null) {
            this.ivResultTable.ivModel.selectElement(latestWrapper);
        }
        if (this.ivAddButton != null) {
            addEnabled = this.isAddReallyAllowed(addEnabled, idObjects);
            this.ivAddButton.setEnabled(addEnabled);
        }
        this.ivCopyButton.setEnabled(!this.ivVisibleResults.isEmpty());
        this.selectionChanged(this.ivResultTable.ivModel);
    }

    public boolean isAddReallyAllowed(boolean addEnabledSoFar, Vector racks) {
        return addEnabledSoFar;
    }

    public void actionPerformed(ActionEvent e) {
        String comm = e.getActionCommand();
        if (comm.equals("ADDRES")) {
            if (this.ivRacks != null && !this.ivRacks.isEmpty()) {
                RackInspHealthResultPanel.addSpecialResult(this.ivRacks);
                this.adapt(this.ivRacks, null, null);
            }
        } else if (comm.equals("EDITRES")) {
            Vector selres = this.ivResultTable.getSelectedObjects();
            if (selres != null && selres.size() == 1) {
                RResWrapper resultWrapper = (RResWrapper)selres.firstElement();
                Rack rack = (Rack)ObjectStore.getObjectDeadOrAlive(3, resultWrapper.ivRackID, resultWrapper.ivGroup, null, false);
                if (rack != null) {
                    Vector<Rack> v = new Vector<Rack>();
                    v.add(rack);
                    RackHealthReportGeneralsRequester.GeneralMicroorganismResult gmr = new RackHealthReportGeneralsRequester.GeneralMicroorganismResult(resultWrapper);
                    RackHealthReportRacksRequester req2 = new RackHealthReportRacksRequester(Inspector.getInspector(), gmr, v, resultWrapper, true);
                    if (req2.ivWarOK) {
                        StringBuilder msb = new StringBuilder();
                        this.deleteSingleReport(resultWrapper, msb);
                        RackInspHealthResultPanel.addTheResults(req2, req2.getChangedResult(gmr));
                        RResHealthReport.init();
                        Inspector.refreshInspector();
                        this.adapt(this.ivRacks, null, null);
                    }
                }
            }
        } else if (comm.equals("DELRES")) {
            Vector selres = this.ivResultTable.getSelectedObjects();
            if (selres != null && !selres.isEmpty()) {
                StringBuilder msb = new StringBuilder();
                int i = 0;
                while (i < selres.size()) {
                    RResWrapper resultWrapper = (RResWrapper)selres.elementAt(i);
                    this.deleteSingleReport(resultWrapper, msb);
                    ++i;
                }
                RResHealthReport.init();
                Inspector.refreshInspector();
                this.adapt(this.ivRacks, null, null);
            }
        } else if (comm.equals("COPYTABLE")) {
            MTRackHealthReport hrModel = (MTRackHealthReport)this.ivResultTable.ivJTable.getModel();
            int anzColPT = hrModel.getColumnCount();
            Vector<String> colNames = new Vector<String>();
            int i = 0;
            while (i < anzColPT) {
                colNames.add(hrModel.getColumnName(i));
                ++i;
            }
            colNames.add(Babel.get(KEY_COL_BABEL));
            colNames.add(Babel.get(VAL_COL_BABEL));
            MausoleumTableLabel label = new MausoleumTableLabel();
            int selPrimRow = this.ivResultTable.ivJTable.getSelectedRow();
            Vector lines = new Vector();
            Vector<Integer> selLines = new Vector<Integer>();
            int primRow = 0;
            while (primRow < this.ivVisibleResults.size()) {
                boolean selected = selPrimRow == primRow;
                Vector<Object> line = new Vector<Object>(anzColPT + 2);
                if (selected) {
                    selLines.add(new Integer(lines.size()));
                }
                lines.add(line);
                RResWrapper wrapper = (RResWrapper)this.ivVisibleResults.elementAt(primRow);
                int col = 0;
                while (col < anzColPT) {
                    hrModel.writeTheCodedElement(label, wrapper, hrModel.getDefinedColumnName(col), false);
                    line.add(label.getText());
                    ++col;
                }
                int[] itemsPerLine = new int[1];
                Object[] results = this.getTableDetails(wrapper, itemsPerLine);
                if (results == null || results.length == 0) {
                    line.add("");
                    line.add("");
                } else {
                    int sline = 0;
                    while (sline < results.length) {
                        if (sline != 0) {
                            line = new Vector(anzColPT + 2);
                            int col2 = 0;
                            while (col2 < anzColPT) {
                                line.add("");
                                ++col2;
                            }
                            if (selected) {
                                selLines.add(new Integer(lines.size()));
                            }
                            lines.add(line);
                        }
                        line.add(results[sline]);
                        line.add(results[sline + 1]);
                        sline += itemsPerLine[0];
                    }
                }
                ++primRow;
            }
            int[] selRows = null;
            if (!selLines.isEmpty()) {
                selRows = new int[selLines.size()];
                int i2 = 0;
                while (i2 < selRows.length) {
                    selRows[i2] = (Integer)selLines.elementAt(i2);
                    ++i2;
                }
            }
            MouseInspSpecResultPanel.HRCopyModel model = new MouseInspSpecResultPanel.HRCopyModel(colNames, lines);
            new CopyRequester((Frame)Inspector.getInspector(), model, model, selRows).setVisible(true);
        }
    }

    private void deleteSingleReport(RResWrapper resultWrapper, StringBuilder msb) {
        msb.setLength(0);
        msb.append(CommandManagerExecutive.getServiceRoomTag(ObjectStore.getClientObject(3, resultWrapper.ivRackID, resultWrapper.ivGroup), ""));
        msb.append("RDELRES");
        msb.append(" ");
        msb.append(resultWrapper.ivRackID);
        msb.append(" ");
        msb.append(resultWrapper.ivHealthReport.ivPseudoID);
        RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), resultWrapper.ivGroup);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension(UIDef.getScaled(300), UIDef.getScaled(500));
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(UIDef.getScaled(150), UIDef.getScaled(300));
    }

    public void layoutContainer(Container parent) {
        Dimension d = parent.getSize();
        int innerheight = d.height - 2 * UIDef.RAND;
        int innerwidth = d.width - 2 * UIDef.RAND;
        int uheight = innerheight - TABLE_HEIGHT - BUT_HEIGHT - 2 * UIDef.RAND;
        int y = UIDef.RAND;
        this.ivResultTable.setBounds(UIDef.RAND, y, innerwidth, TABLE_HEIGHT);
        this.ivBorderPanel.setBounds(UIDef.RAND, y += TABLE_HEIGHT + UIDef.RAND, innerwidth, uheight);
        y += uheight + UIDef.RAND;
        int anzbuts = 1;
        if (this.ivAddButton != null) {
            ++anzbuts;
        }
        if (this.ivEditButton != null) {
            ++anzbuts;
        }
        if (this.ivDelButton != null) {
            ++anzbuts;
        }
        if (anzbuts == 1) {
            this.ivCopyButton.setBounds(UIDef.RAND, y, d.width - 2 * UIDef.RAND, BUT_HEIGHT);
        } else {
            int iw = d.width - 2 * UIDef.RAND;
            int lw = (iw - (anzbuts - 1) * UIDef.INNER_RAND) / anzbuts;
            int rw = iw - (anzbuts - 1) * UIDef.INNER_RAND - (anzbuts - 1) * lw;
            int x = UIDef.RAND;
            if (this.ivAddButton != null) {
                this.ivAddButton.setBounds(x, y, lw, BUT_HEIGHT);
                x += lw + UIDef.INNER_RAND;
            }
            if (this.ivEditButton != null) {
                this.ivEditButton.setBounds(x, y, lw, BUT_HEIGHT);
                x += lw + UIDef.INNER_RAND;
            }
            if (this.ivDelButton != null) {
                this.ivDelButton.setBounds(x, y, lw, BUT_HEIGHT);
                x += lw + UIDef.INNER_RAND;
            }
            this.ivCopyButton.setBounds(x, y, rw, BUT_HEIGHT);
        }
    }

    public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
    }

    public void handleNewObjects(Vector idObjects) {
    }

    public void handleNewObject(IDObject obj) {
    }

    public void selectionChanged(MausoleumTableModel mt) {
        boolean delEnabled = false;
        boolean editEnabled = false;
        this.ivDetailsTable.ivLongStringRowNumbers.clear();
        Vector v = this.ivResultTable.getSelectedObjects();
        if (v.size() != 1) {
            this.ivDetailsTable.setDetails(null);
            this.ivDetailsPane.setText("");
        } else {
            RResWrapper wrapper = (RResWrapper)v.firstElement();
            this.ivDetailsTable.setDetails(this.getTableDetails((RResWrapper)v.firstElement(), null));
            delEnabled = Privileges.hasPrivilege(DEL_PRIVILEGE);
            editEnabled = Privileges.hasPrivilege(EDIT_PRIVILEGE);
            this.ivDetailsPane.setText(wrapper.ivHealthReport.ivDetails);
            this.ivDetailsPane.setCaretPosition(0);
        }
        if (this.ivDelButton != null) {
            this.ivDelButton.setEnabled(delEnabled);
        }
        if (this.ivEditButton != null) {
            this.ivEditButton.setEnabled(editEnabled);
        }
    }

    public Object[] getTableDetails(RResWrapper wrapper, int[] itemsPerLine) {
        return wrapper.ivHealthReport.getTableRepresentation(wrapper.ivGroup, Babel.cvUserLangue, itemsPerLine);
    }

    public static class RHDetailsTable
    extends SpecResDetailsTable {
        private static final long serialVersionUID = 1324234234L;

        public RHDetailsTable() {
            this.getColumnModel().getColumn(0).setPreferredWidth(250);
            this.getColumnModel().getColumn(1).setPreferredWidth(50);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setDefaultRenderer(clazz, new TableCellRenderer(this){
                final /* synthetic */ RHDetailsTable this$1;
                {
                    this.this$1 = rHDetailsTable;
                }

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    this.this$1.ivLocusLabel.setText(" " + value + " ");
                    return UIDef.highlightLabelIf(this.this$1.ivLocusLabel, "1".equals(RHDetailsTable.access$0(this.this$1)[row * 3 + 2]), true, FontManager.getFont("SSP11"), FontManager.getFont("SSB11"), Color.black, Color.white, null, ColorManager.getColorFromString("firebrick"));
                }
            });
        }

        public String getColumnName(int col) {
            return col == 0 ? Babel.get("ARHR_FS_MICORORGANISM") : Babel.get("ARHR_POSITIVE_SH");
        }

        public int objectsPerRow() {
            return 3;
        }

        static /* synthetic */ Object[] access$0(RHDetailsTable rHDetailsTable) {
            return rHDetailsTable.ivDetails;
        }
    }
}

