/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.requester.AllgChoiceRequester;

public class CSAutoGenotype
extends CSAllg {
    private static final String[] CHOICES = new String[]{"ENABLED", "DISABLED"};
    private boolean ivValue = true;
    private boolean ivRememberValue = true;

    public CSAutoGenotype(InspectorPanel ip) {
        super(ip, Babel.get("AUTO_GENOTYPE"));
    }

    public String getValue() {
        if (this.ivValue) {
            return "1";
        }
        return "0";
    }

    public void actionPerformed(ActionEvent e) {
        int ind;
        InspectorPanel ip = this.getMatchingPanel();
        if (ip != null && ip.hasSelection() && (ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("AUTO_GENOTYPE"), Babel.get(CHOICES))) != -1) {
            switch (ind) {
                case 0: {
                    this.ivStatus = -3;
                    this.ivValue = true;
                    break;
                }
                case 1: {
                    this.ivStatus = -3;
                    this.ivValue = false;
                    break;
                }
            }
            this.setTextAccordingly();
            this.changed(this.ivValue ^ this.ivRememberValue);
        }
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.isEmpty() || this.istEinAutosomalerLocusDabei(v)) {
            this.setToNonApplicable();
        } else {
            this.getCommonAutoGenotype(v);
            this.setTextAccordingly();
            this.ivRememberValue = this.ivValue;
            this.changed(false);
        }
    }

    private boolean istEinAutosomalerLocusDabei(Vector v) {
        if (v != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Locus locus;
                Object o = iter.next();
                if (!(o instanceof Locus) || (locus = (Locus)o).isAutosomal()) continue;
                return true;
            }
        }
        return false;
    }

    public String getValueLabel() {
        return this.ivValue ? Babel.get("ENABLED") : Babel.get("DISABLED");
    }

    private void getCommonAutoGenotype(Vector v) {
        if (v == null || v.isEmpty()) {
            this.ivStatus = -1;
            this.ivValue = false;
        } else {
            boolean compVal = CSAutoGenotype.getAutoGenotype((IDObject)v.elementAt(0), true);
            this.ivStatus = -3;
            this.ivValue = compVal;
            if (v.size() > 1) {
                int i = 1;
                while (i < v.size()) {
                    boolean nv = CSAutoGenotype.getAutoGenotype((IDObject)v.elementAt(i), true);
                    if (compVal != nv) {
                        this.ivStatus = -2;
                        return;
                    }
                    ++i;
                }
            }
        }
    }

    private static boolean getAutoGenotype(IDObject ido, boolean defVal) {
        if (ido instanceof Line) {
            Line m = (Line)ido;
            return m.getBoolean("LIN_AUTOGTOK", defVal);
        }
        if (ido instanceof Locus) {
            Locus m = (Locus)ido;
            return m.getBoolean("LOC_AUTOGTOK", defVal);
        }
        return defVal;
    }
}

