/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JLabel;
import mausoleum.gui.MFLabel;
import mausoleum.gui.MausoleumTableLabel;
import mausoleum.helper.FontManager;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.InspectorPanelMouse;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.inspector.sensitives.CSLabelLieferant;
import mausoleum.line.Line;
import mausoleum.mouse.Mouse;
import mausoleum.requester.mouse.SelectGenotypeRequester;

public class CSGenotype
extends CSAllg
implements CSLabelLieferant {
    private static final Vector WT_MULTI = new Vector();
    private static final Vector NIX_MULTI = new Vector();
    private String ivValue;
    public final MausoleumTableLabel ivLabel = new MausoleumTableLabel();

    public CSGenotype(InspectorPanel ip) {
        super(ip, Babel.get("GENOTYPE"));
        WT_MULTI.add(new MFLabel("wt", FontManager.getFont("SSB12")));
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public String getValue() {
        return this.ivValue;
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.isEmpty()) {
            this.setToNonApplicable();
        } else {
            long lineid = Mouse.getCommonMouseRefID(v, "MOS_LINEID", -1L, -2L);
            if (lineid == -1L || lineid == -2L) {
                this.setToNonApplicable();
            } else {
                boolean active = false;
                if (this.areAllMiceBreeder(v)) {
                    this.ivValue = "wt";
                    this.ivStatus = -3;
                    this.setLabel(this.ivValue);
                    this.ivLabel.setMultiFontStrings(WT_MULTI);
                } else {
                    this.getCommonMouseGenotype(v);
                    this.setTextAccordingly();
                    if (Mouse.areMiceTouchable(v)) {
                        active = Privileges.hasPrivilege("MOS_CH_GENOTYPE");
                    } else if (Mouse.areMiceTouchableInclDeads(v)) {
                        active = this.areAllGenotypesUnset(v) ? Privileges.hasPrivilege("MOS_SET_GENOTYPE_OF_DEAD_ANIMALS") : Privileges.hasPrivilege("MOS_CH_GENOTYPE_OF_DEAD_ANIMALS");
                    }
                }
                this.setState(active);
                this.changed(false);
            }
        }
    }

    public void setToNonApplicable() {
        if (this.ivLabel != null) {
            this.ivLabel.setMultiFontStrings(NIX_MULTI);
        }
        super.setToNonApplicable();
    }

    public String getValueLabel() {
        return this.ivValue;
    }

    private boolean areAllMiceBreeder(Vector v) {
        int i = 0;
        while (i < v.size()) {
            Mouse mausi = (Mouse)v.elementAt(i);
            Line line = mausi.getLine();
            if (line == null || !line.isBreeder()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean areAllGenotypesUnset(Vector v) {
        int i = 0;
        while (i < v.size()) {
            Mouse mausi = (Mouse)v.elementAt(i);
            if (mausi.get("MOS_LOCUSGENOTYPES") != null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void getCommonMouseGenotype(Vector v) {
        this.ivValue = null;
        this.ivStatus = -1;
        if (v == null || v.isEmpty()) {
            return;
        }
        boolean first = true;
        int i = 0;
        while (i < v.size()) {
            Mouse mausi = (Mouse)v.elementAt(i);
            if (first) {
                this.ivValue = mausi.getGenotype();
                first = false;
            } else if (this.ivValue == null) {
                if (mausi.getGenotype() != null) {
                    this.ivStatus = -2;
                    this.ivValue = null;
                    return;
                }
            } else {
                if (mausi.get("MOS_LOCUSGENOTYPES") == null || mausi.getGenotype().equals("?")) {
                    this.ivStatus = -2;
                    this.ivValue = null;
                    return;
                }
                if (!mausi.getGenotype().equals(this.ivValue)) {
                    this.ivStatus = -2;
                    this.ivValue = null;
                    return;
                }
            }
            ++i;
        }
        if (this.ivValue != null) {
            this.ivStatus = -3;
            this.ivLabel.setMultiFontStrings(((Mouse)v.firstElement()).getMultiFontGenotype(FontManager.getGenotypeArray(false, FontManager.getFont("SSB12"), false, 1.0), false));
        }
    }

    public JLabel getExtraLabel() {
        if (this.ivStatus == -3) {
            return this.ivLabel;
        }
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        InspectorPanel ip = this.getMatchingPanel();
        if (ip != null) {
            InspectorPanelMouse ipm = (InspectorPanelMouse)ip;
            long lid = ipm.getLineValue();
            if (lid == 0L) {
                this.setToNonApplicable();
                return;
            }
            SelectGenotypeRequester.setGenotype(ip.ivSelObjects, ip);
            if (ip != null) {
                this.adaptToVector(ip.ivSelObjects);
            }
        }
    }
}

