/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.license.License;
import mausoleum.requester.AllgChoiceRequester;

public class CSLicenseSubtype
extends CSAllg {
    private final String[] ivSel;
    private int ivValue;
    private int ivRememberValue;

    public CSLicenseSubtype(InspectorPanel ip) {
        super(ip, Babel.get("LIC_LICENSE_SUBTYPE"));
        this.ivRememberValue = this.ivValue = 0;
        this.ivSel = new String[License.LIC_SUBTYPE_SELECTION_BABELS.length];
        int i = 0;
        while (i < this.ivSel.length) {
            this.ivSel[i] = Babel.get(License.LIC_SUBTYPE_SELECTION_BABELS[i]);
            ++i;
        }
    }

    public String getValue() {
        return Integer.toString(this.ivValue);
    }

    public void actionPerformed(ActionEvent e) {
        int ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("LIC_SELECT_SUBTYPE"), this.ivSel);
        if (ind != -1) {
            this.ivValue = License.LIC_SUBTYPES_SELECTION[ind];
            this.ivStatus = -3;
            this.setTextAccordingly();
            this.changed(this.ivValue != this.ivRememberValue);
        }
    }

    public boolean isChangeableByContent(License license) {
        return license.isMouseLicense();
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.size() != 1) {
            this.setToNonApplicable();
        } else {
            License license = (License)v.firstElement();
            if (license.isLineLicense()) {
                this.ivStatus = -3;
                this.ivValue = 1;
                this.setToPassive();
            } else {
                this.ivValue = license.getInt("LIC_LIC_SUBTYPE", 0);
                if (this.ivValue == 0) {
                    this.ivStatus = -1;
                    this.setState(Privileges.hasPrivilege("LIC_SET_SUBTYPE"));
                } else {
                    this.ivStatus = -3;
                    this.setState(Privileges.hasPrivilege("LIC_CHANGE_SUBTYPE"));
                }
            }
            this.ivRememberValue = this.ivValue;
            this.setTextAccordingly();
        }
    }

    public String getValueLabel() {
        return StringHelper.getStringForInt(this.ivValue, License.LIC_SUBTYPES, License.LIC_SUBTYPE_BABELS, true, "");
    }
}

