/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.Vector;
import mausoleum.alert.Alert;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.line.Line;
import mausoleum.mouse.Mouse;
import mausoleum.requester.Requester;
import mausoleum.strain.Strain;
import mausoleum.util.Standards;

public class CSMatLim
extends CSAllg {
    public static final int NULL_VALUE = -2;
    public static final int DELETE_VALUE = -1;
    private int ivValue = -2;
    private int ivRememberValue = -2;

    public static int getNewMatLimit(int aktVal, int defVal) {
        return Requester.getInt(Inspector.getInspector(), String.valueOf(Babel.get("SPECIFYMATLIM")) + " [" + Standards.cvMaturityMinValue + " - " + Standards.cvMaturityMaxValue + "]", aktVal, aktVal > 0, defVal, true, null);
    }

    public CSMatLim(InspectorPanel ip) {
        super(ip, Babel.get("MATLIM"));
    }

    public int getValue() {
        return this.ivValue;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void actionPerformed(ActionEvent e) {
        int returnVal;
        InspectorPanel ip = this.getMatchingPanel();
        if (ip != null && ip.hasSelection() && (returnVal = CSMatLim.getNewMatLimit(this.ivValue, -1)) != -1) {
            if (returnVal == 0) {
                this.ivValue = -1;
            } else {
                try {
                    if (returnVal < Standards.cvMaturityMinValue || returnVal > Standards.cvMaturityMaxValue) {
                        Alert.showAlert(Babel.get("MATLIM_INVALID"), true);
                        return;
                    }
                    this.ivValue = returnVal;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.ivStatus = -3;
            this.setTextAccordingly();
            this.changed(this.ivRememberValue != this.ivValue);
        }
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.isEmpty()) {
            this.setToNonApplicable();
        } else {
            this.getCommonMatLim(v);
            this.setTextAccordingly();
            this.ivRememberValue = this.ivValue;
            this.changed(false);
        }
    }

    public String getValueLabel() {
        return this.ivValue == -1 ? Babel.get("DELETEMATLIM") : Integer.toString(this.ivValue);
    }

    public void setLabel(String label) {
        super.setLabel(label);
    }

    private void getCommonMatLim(Vector v) {
        int matlim = -2;
        if (v != null && !v.isEmpty()) {
            matlim = CSMatLim.getMatLim((IDObject)v.elementAt(0), -2);
            if (v.size() > 1) {
                int i = 1;
                while (i < v.size()) {
                    if (matlim != CSMatLim.getMatLim((IDObject)v.elementAt(i), -2)) {
                        this.ivStatus = -2;
                        this.ivValue = -2;
                        return;
                    }
                    ++i;
                }
            }
        }
        if (matlim == -2) {
            this.ivStatus = -1;
            this.ivValue = -2;
        } else {
            this.ivStatus = -3;
            this.ivValue = matlim;
        }
    }

    private static int getMatLim(IDObject ido, int defVal) {
        if (ido instanceof Mouse) {
            Mouse m = (Mouse)ido;
            return m.getInt("MOS_MATLIM", defVal);
        }
        if (ido instanceof Line) {
            Line l = (Line)ido;
            return l.getInt("LIN_MATLIM", defVal);
        }
        if (ido instanceof Strain) {
            Strain s = (Strain)ido;
            return s.getInt("STR_MATLIM", defVal);
        }
        return defVal;
    }
}

