/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.requester.AllgChoiceRequester;
import mausoleum.room.Room;

public class CSSecurityLevel
extends CSAllg {
    private static String[] CHOICES = null;
    private int ivValue;
    private int ivRememberValue;

    public CSSecurityLevel(InspectorPanel ip) {
        super(ip, Babel.get("SECURITY_LEVEL"));
    }

    public int getValue() {
        return this.ivValue;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void actionPerformed(ActionEvent e) {
        InspectorPanel ip = this.getMatchingPanel();
        if (ip != null && this.activePossible(ip.ivSelObjects)) {
            String s;
            if (CHOICES == null) {
                CHOICES = new String[Room.SECURITY_STRINGS.length];
                int i = 0;
                while (i < CHOICES.length) {
                    CSSecurityLevel.CHOICES[i] = Babel.get(Room.SECURITY_STRINGS[i]);
                    ++i;
                }
            }
            if ((s = AllgChoiceRequester.getStringAnswer(Inspector.getInspector(), Babel.get("SECURITY_LEVEL"), CHOICES)) != null && s.length() != 0) {
                int i = 0;
                while (i < CHOICES.length) {
                    if (s.equals(CHOICES[i])) {
                        this.ivValue = Room.SECURITY_INTS[i];
                        this.ivStatus = -3;
                    }
                    ++i;
                }
            }
            this.setTextAccordingly();
            this.changed(this.ivRememberValue != this.ivValue);
        }
    }

    public void adaptToVector(Vector v) {
        if (v == null || v.isEmpty()) {
            this.setToNonApplicable();
            return;
        }
        this.ivValue = IDObject.getCommonIntValue(v, "ROM_SECURITY", 0, -1);
        this.ivStatus = this.ivValue == -1 ? -2 : (this.ivValue == 0 ? -1 : -3);
        this.setTextAccordingly();
        this.ivRememberValue = this.ivValue;
        if (this.activePossible(v)) {
            this.setToActive();
        } else {
            this.setToPassive();
        }
        this.changed(false);
    }

    private boolean activePossible(Vector v) {
        boolean res = false;
        if (Privileges.hasPrivilege("ROM_CHANGE_SECURITY")) {
            res = true;
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                Room room = (Room)iter.next();
                if (!room.isSharedWithOtherGroups()) continue;
                res = false;
            }
        }
        return res;
    }

    public String getValueLabel() {
        return StringHelper.getStringForInt(this.ivValue, Room.SECURITY_INTS, Room.SECURITY_STRINGS, true, "");
    }
}

