/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.mouse.Mouse;
import mausoleum.requester.strain.StrainSelector;
import mausoleum.strain.Strain;
import mausoleum.strain.StrainManager;

public class CSStrain
extends CSAllg {
    private static final IndexObject[] NIX_MACHEN_VAL = new IndexObject[0];
    private IndexObject[] ivValue = null;
    private IndexObject[] ivRememberValue = null;

    public CSStrain(InspectorPanel ip) {
        super(ip, Babel.get("STRAIN"));
    }

    public String getCommandValue() {
        return IndexObject.getTransportString(this.ivValue);
    }

    public String getValue(String group) {
        return IndexObject.getDisplayString(this.ivValue, group, 8, false, false, true);
    }

    public void actionPerformed(ActionEvent e) {
        InspectorPanel ip = this.getMatchingPanel();
        String group = ip == null ? null : IDObject.commonGroup(ip.ivSelObjects);
        IndexObject[] res = CSStrain.selectStrain(group);
        if (res == null || res.length != 0) {
            this.ivValue = res;
            this.ivStatus = this.ivValue == null ? -1 : -3;
            this.setTextAccordingly();
            this.changed(this.ivRememberValue != this.ivValue);
        }
    }

    public static IndexObject[] selectStrain(String group) {
        if (group != null) {
            Vector sv = StrainManager.cvInstance.getActualObjectVector(group, true, true);
            Collections.sort(sv);
            Vector<String> names = new Vector<String>();
            Vector<Object> ids = new Vector<Object>();
            if (sv != null) {
                Iterator iter = sv.iterator();
                while (iter.hasNext()) {
                    Strain strain = (Strain)iter.next();
                    if (!strain.isAliveAndVisible()) continue;
                    names.add(strain.getBrowseName());
                    ids.add(strain.get("IDO_ID"));
                }
            }
            try {
                StrainSelector ss = new StrainSelector(Inspector.getInspector(), names, ids, true, true);
                if (ss.ivWarOK) {
                    return ss.ivRes;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NIX_MACHEN_VAL;
    }

    public void adaptToVector(Vector v) {
        this.getCommonMouseStrain(v);
        this.ivRememberValue = this.ivValue;
        this.setTextAccordingly();
        this.changed(false);
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public String getValueLabel() {
        String group;
        InspectorPanel ip = this.getMatchingPanel();
        String string = group = ip == null ? null : IDObject.commonGroup(ip.ivSelObjects);
        if (group != null) {
            return IndexObject.getDisplayString(this.ivValue, group, 8, false, false, true);
        }
        return "";
    }

    private void getCommonMouseStrain(Vector v) {
        String group;
        this.ivValue = null;
        this.ivStatus = -1;
        if (v != null && !v.isEmpty() && (group = IDObject.commonGroup(v)) != null) {
            int i = 0;
            while (i < v.size()) {
                Mouse mausi = (Mouse)v.elementAt(i);
                IndexObject[] arr = (IndexObject[])mausi.get("MOS_STRAIN");
                if (i == 0) {
                    this.ivValue = arr;
                    this.ivStatus = arr == null ? -1 : -3;
                } else if (!IndexObject.match(this.ivValue, arr)) {
                    this.ivValue = null;
                    this.ivStatus = -2;
                }
                ++i;
            }
        }
    }
}

