/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.license.License;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.requester.AllgChoiceRequester;

public class CSStressInputNecessary
extends CSAllg {
    private static final String[] CHOICES = new String[]{"MANDATORY", "NOT_MANDATORY"};
    private static final boolean DEFAULT_VAL = false;
    private boolean ivValue = true;
    private boolean ivRememberValue = true;

    public CSStressInputNecessary(InspectorPanel ip) {
        super(ip, Babel.get("LIC_STRESS_INPUT_NECCESSARY"));
    }

    public String getValue() {
        if (this.ivValue) {
            return "1";
        }
        return "0";
    }

    public void actionPerformed(ActionEvent e) {
        int ind;
        InspectorPanel ip = this.getMatchingPanel();
        if (ip != null && ip.hasSelection() && (ind = AllgChoiceRequester.getIndexAnswer((Frame)Inspector.getInspector(), Babel.get("LIC_STRESS_INPUT_NECCESSARY"), Babel.get(CHOICES))) != -1) {
            switch (ind) {
                case 0: {
                    this.ivStatus = -3;
                    this.ivValue = true;
                    break;
                }
                case 1: {
                    this.ivStatus = -3;
                    this.ivValue = false;
                    break;
                }
            }
            this.setTextAccordingly();
            this.changed(this.ivValue ^ this.ivRememberValue);
        }
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void adaptToVector(Vector v) {
        if (!TierSchutz.belastungNeeded() || v == null || v.isEmpty()) {
            this.setToNonApplicable();
        } else {
            boolean allEditable = true;
            Iterator iterator = v.iterator();
            while (iterator.hasNext()) {
                License license = (License)iterator.next();
                if (!TierSchutz.isForcedStressReportInputPossible(license)) {
                    this.setToNonApplicable();
                    return;
                }
                if (license.mayAttributeBeChangedByCommand()) continue;
                allEditable = false;
            }
            this.getCommonStressInput(v);
            this.setTextAccordingly();
            this.ivRememberValue = this.ivValue;
            this.setState(allEditable && Privileges.hasPrivilege("LIC_SET_STRESS_INPUT"));
            this.changed(false);
        }
    }

    public String getValueLabel() {
        return this.ivValue ? Babel.get(CHOICES[0]) : Babel.get(CHOICES[1]);
    }

    private void getCommonStressInput(Vector v) {
        if (v == null || v.isEmpty()) {
            this.ivStatus = -1;
            this.ivValue = false;
        } else {
            boolean compVal = ((IDObject)v.elementAt(0)).getBoolean("LIC_NMB", false);
            this.ivStatus = -3;
            this.ivValue = compVal;
            if (v.size() > 1) {
                int i = 1;
                while (i < v.size()) {
                    boolean nv = ((IDObject)v.elementAt(i)).getBoolean("LIC_NMB", false);
                    if (compVal != nv) {
                        this.ivStatus = -2;
                        return;
                    }
                    ++i;
                }
            }
        }
    }
}

