/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.actions.line.KnubbelSelector;
import mausoleum.inspector.sensitives.CSAllg;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.tierschutz.Stress;

public class CSStressLevelMouse
extends CSAllg {
    public static final int NULL_VALUE = -2;
    public static final int MULTIPLE_VALUE = -1;
    private final boolean ivResponsibleForStressInLife;
    private int ivStressLevel;
    public HashMap ivStressByMouse = new HashMap();

    public CSStressLevelMouse(InspectorPanel ip, boolean responsibleForStressInLife) {
        super(ip, Babel.get(responsibleForStressInLife ? "STRESS_LEVEL_LIFE" : "STRESS_LEVEL_EXPERIMENT"));
        this.ivResponsibleForStressInLife = responsibleForStressInLife;
    }

    public Vector getAffecteds(Vector selectedObjects) {
        return selectedObjects;
    }

    public void adaptToVector(Vector v) {
        this.ivStressLevel = this.getCommonStressValue(v, -2, -1);
        if (this.ivStressLevel == 0) {
            this.ivStressLevel = -2;
        }
        this.ivStatus = this.ivStressLevel == -1 ? -2 : (this.ivStressLevel == -2 ? -1 : -3);
        boolean allowed = Privileges.hasPrivilege("MOS_DEFINE_STRESS_LEVELS");
        if (allowed && v != null && !v.isEmpty()) {
            if (this.ivResponsibleForStressInLife) {
                allowed = Mouse.areMiceTouchable(v);
            } else if (Mouse.areMiceTouchableInclDeads(v)) {
                Iterator iterator = v.iterator();
                while (iterator.hasNext() && allowed) {
                    Mouse mouse = (Mouse)iterator.next();
                    if (!mouse.isAlive()) continue;
                    allowed = false;
                }
            }
        }
        this.setTextAccordingly();
        this.setState(allowed);
        this.changed(false);
    }

    public void appendCommand(Vector idObjects, StringBuffer msb) {
        HashMap levelsByMouse = this.ivStressByMouse;
        Iterator iterator = idObjects.iterator();
        while (iterator.hasNext()) {
            Mouse mouse = (Mouse)iterator.next();
            Integer level = (Integer)levelsByMouse.get(mouse);
            if (level == null) continue;
            msb.append("MOSStressLevel").append(" ");
            msb.append(mouse.getID()).append(" ");
            msb.append(level).append(" ");
            msb.append(this.ivResponsibleForStressInLife ? 0 : 1).append("\n");
        }
    }

    public String getValueLabel() {
        return this.ivStressLevel >= 0 ? StringHelper.getStringForInt(this.ivStressLevel, Stress.STRESS_INTS, Stress.STRESS_BABELS, true, "") : "";
    }

    private int getCommonStressValue(Vector mice, int nullValue, int errorValue) {
        int tmpValue = nullValue;
        if (mice != null && !mice.isEmpty()) {
            boolean first = true;
            Iterator iter = mice.iterator();
            while (iter.hasNext()) {
                int val;
                Mouse mouse = (Mouse)iter.next();
                int n = val = this.ivResponsibleForStressInLife ? mouse.getMouseLifeStressLevel() : mouse.getMouseDeathStressLevel();
                if (first) {
                    tmpValue = val;
                    first = false;
                    continue;
                }
                if (tmpValue == val) continue;
                return errorValue;
            }
        }
        return tmpValue;
    }

    public void actionPerformed(ActionEvent e) {
        InspectorPanel ip = this.getMatchingPanel();
        Vector selObjects = ip.ivSelObjects;
        KnubbelSelector.getStressLevelsForMice(selObjects, -1, true, true, true, this.ivStressByMouse, this.ivResponsibleForStressInLife);
        if (!this.ivStressByMouse.isEmpty()) {
            this.ivStatus = -3;
            this.changed(true);
        }
    }
}

