/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.inspector.sensitives;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import mausoleum.alert.Alert;
import mausoleum.gui.KomfortTextField;
import mausoleum.helper.FontManager;
import mausoleum.inspector.Inspector;
import mausoleum.inspector.InspectorPanel;
import mausoleum.inspector.sensitives.ChangeSensitive;
import mausoleum.requester.TextRequester;
import mausoleum.ui.MausoleumTextFieldUI;

public abstract class CSTextField
extends KomfortTextField
implements ChangeSensitive,
ActionListener {
    private static final long serialVersionUID = -712506416396119322L;
    private String ivRememberString;
    private InspectorPanel ivPanel = null;
    public boolean ivChanged = false;
    public String ivSetCommand = "ENTERVALUE";
    private final String ivPrefix;
    protected int ivAState = 3;
    protected int ivStatus = -1;
    private MausoleumTextFieldUI ivUI;
    private boolean ivActive = true;
    public boolean ivEmptyAllowed = true;

    public CSTextField(InspectorPanel ip, String prefix) {
        this.ivPanel = ip;
        this.ivPanel.addChangeSensitive(this);
        this.ivPrefix = prefix;
        this.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                CSTextField.this.textValueChanged();
            }
        });
        this.setForeground(Color.black);
        this.setFont(FontManager.getFont("SSB12"));
        this.setMargin(new Insets(0, 4, 0, 4));
        if (this.getUI() instanceof MausoleumTextFieldUI) {
            this.ivUI = (MausoleumTextFieldUI)this.getUI();
            this.ivUI.setImageKey("inspectorBack");
        }
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CSTextField.this.setIfChanged();
            }
        });
    }

    protected void paintBorder(Graphics g) {
        if (!this.isEnabled()) {
            Dimension d = this.getSize();
            g.setColor(Color.black);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        } else {
            super.paintBorder(g);
        }
    }

    public void setText(String text) {
        if (this.ivActive) {
            this.ivRememberString = text;
            this.ivChanged = false;
            this.setEditable(true);
        }
        super.setText(text);
    }

    private void textValueChanged() {
        if (this.isEnabled() && this.ivActive) {
            if (this.ivRememberString == null) {
                this.changed(this.getText().length() != 0);
            } else {
                this.changed(!this.ivRememberString.equals(this.getText()));
            }
        }
    }

    private void setIfChanged() {
        if (this.ivChanged && this.ivPanel != null && Inspector.cvActPanel != null && Inspector.cvActPanel.isSetAllowed()) {
            Inspector.cvActPanel.doTheSet();
        }
    }

    private void changed(boolean val) {
        if (val) {
            this.ivChanged = true;
            if (this.ivUI != null) {
                this.ivUI.setImageKey("redButton");
            } else {
                this.setBackground(Color.red);
            }
            this.setForeground(Color.white);
        } else {
            this.ivChanged = false;
            if (this.ivUI != null) {
                this.ivUI.setImageKey("yellowButton");
            } else {
                this.setBackground(Color.yellow);
            }
            this.setForeground(Color.black);
        }
        this.ivPanel.somethingChanged();
    }

    public boolean didYouChange() {
        return this.ivChanged;
    }

    public void setState(boolean active) {
        if (active) {
            this.setToActive();
        } else {
            this.setToPassive();
        }
    }

    public void setToActive() {
        this.setOpaque(true);
        this.setForeground(Color.black);
        this.setEditable(true);
        this.setEnabled(true);
        this.changed(false);
        this.ivAState = 1;
    }

    public void setToPassive() {
        this.setOpaque(false);
        this.setForeground(Color.black);
        this.setEditable(false);
        this.setEnabled(false);
        this.ivChanged = false;
        this.ivAState = 2;
    }

    public void setToNonApplicable() {
        this.setForeground(Color.black);
        this.ivRememberString = null;
        this.setText("");
        this.setToPassive();
        this.ivAState = 3;
    }

    public boolean isActive() {
        return this.ivAState == 1;
    }

    public boolean isNonApplicable() {
        return this.ivAState == 3;
    }

    public int getStatus() {
        return this.ivStatus;
    }

    public void setForeground(Color fg) {
        this.setDisabledTextColor(fg);
        super.setForeground(fg);
    }

    public String getPrefixText() {
        return this.ivPrefix;
    }

    public String getValueText() {
        return this.getText();
    }

    public void actionPerformed(ActionEvent arg0) {
        String text;
        if (this.isEnabled() && (text = TextRequester.displayTextRequester(Inspector.getInspector(), Babel.get(this.ivSetCommand), this.getText(), this.ivEmptyAllowed)) != null) {
            if ((text = text.trim()).length() > 0 || this.ivEmptyAllowed) {
                this.ivActive = false;
                this.setText(text);
                this.ivActive = true;
                this.textValueChanged();
                this.setIfChanged();
            } else {
                Alert.showAlert(Babel.get("EMPTY_NOT_ALLOWED"), true);
            }
        }
    }
}

